/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.jpa.entity;

import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.keycloak.storage.jpa.KeyUtils;

@NamedQueries(value={@NamedQuery(name="getFederatedUserIds", query="select f.id from FederatedUser f where f.realmId=:realmId"), @NamedQuery(name="getFederatedUserCount", query="select count(u) from FederatedUser u where u.realmId = :realmId"), @NamedQuery(name="deleteFederatedUserByUser", query="delete from  FederatedUser f where f.id = :userId and f.realmId=:realmId"), @NamedQuery(name="deleteFederatedUsersByRealm", query="delete from  FederatedUser f where f.realmId=:realmId"), @NamedQuery(name="deleteFederatedUsersByStorageProvider", query="delete from FederatedUser f where f.storageProviderId=:storageProviderId"), @NamedQuery(name="deleteFederatedUsersByRealmAndLink", query="delete from  FederatedUser f where f.id IN (select u.id from UserEntity u where u.realmId=:realmId and u.federationLink=:link)")})
@Entity
@Table(name="FEDERATED_USER")
public class FederatedUser {
    @Id
    @Column(name="ID")
    @Access(value=AccessType.PROPERTY)
    protected String id;
    @Column(name="REALM_ID")
    protected String realmId;
    @Column(name="STORAGE_PROVIDER_ID")
    protected String storageProviderId;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        KeyUtils.assertValidKey(id);
        this.id = id;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public String getStorageProviderId() {
        return this.storageProviderId;
    }

    public void setStorageProviderId(String storageProviderId) {
        this.storageProviderId = storageProviderId;
    }
}

