/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.vault.VaultKVSecretReactiveEngine;
import io.quarkus.vault.runtime.VaultAuthManager;
import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.client.Private;
import io.quarkus.vault.runtime.client.VaultClient;
import io.quarkus.vault.runtime.client.dto.kv.VaultKvListSecretsData;
import io.quarkus.vault.runtime.client.dto.kv.VaultKvSecretV2Data;
import io.quarkus.vault.runtime.client.dto.kv.VaultKvSecretV2WriteBody;
import io.quarkus.vault.runtime.client.secretengine.VaultInternalKvV1SecretEngine;
import io.quarkus.vault.runtime.client.secretengine.VaultInternalKvV2SecretEngine;
import io.quarkus.vault.runtime.config.VaultBootstrapConfig;
import io.smallrye.mutiny.Uni;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;

@ApplicationScoped
public class VaultKvManager
implements VaultKVSecretReactiveEngine {
    private VaultClient vaultClient;
    private VaultAuthManager vaultAuthManager;
    private VaultConfigHolder vaultConfigHolder;
    private VaultInternalKvV1SecretEngine vaultInternalKvV1SecretEngine;
    private VaultInternalKvV2SecretEngine vaultInternalKvV2SecretEngine;

    @Produces
    @Private
    public static VaultKvManager privateClientManager(@Private VaultClient vaultClient, VaultAuthManager vaultAuthManager, VaultConfigHolder vaultConfigHolder, VaultInternalKvV1SecretEngine vaultInternalKvV1SecretEngine, VaultInternalKvV2SecretEngine vaultInternalKvV2SecretEngine) {
        return new VaultKvManager(vaultClient, vaultAuthManager, vaultConfigHolder, vaultInternalKvV1SecretEngine, vaultInternalKvV2SecretEngine);
    }

    public VaultKvManager(VaultClient vaultClient, VaultAuthManager vaultAuthManager, VaultConfigHolder vaultConfigHolder, VaultInternalKvV1SecretEngine vaultInternalKvV1SecretEngine, VaultInternalKvV2SecretEngine vaultInternalKvV2SecretEngine) {
        this.vaultClient = vaultClient;
        this.vaultAuthManager = vaultAuthManager;
        this.vaultConfigHolder = vaultConfigHolder;
        this.vaultInternalKvV1SecretEngine = vaultInternalKvV1SecretEngine;
        this.vaultInternalKvV2SecretEngine = vaultInternalKvV2SecretEngine;
    }

    private VaultBootstrapConfig getConfig() {
        return this.vaultConfigHolder.getVaultBootstrapConfig();
    }

    @Override
    public Uni<Map<String, String>> readSecret(String path) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> {
            String mount = this.getConfig().kvSecretEngineMountPath;
            if (this.isV1()) {
                return this.vaultInternalKvV1SecretEngine.getSecret(this.vaultClient, (String)token, mount, path).map(r -> (Map)r.data);
            }
            return this.vaultInternalKvV2SecretEngine.getSecret(this.vaultClient, (String)token, mount, path).map(r -> ((VaultKvSecretV2Data)r.data).data);
        });
    }

    @Override
    public Uni<Void> writeSecret(String path, Map<String, String> secret) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> {
            String mount = this.getConfig().kvSecretEngineMountPath;
            if (this.isV1()) {
                return this.vaultInternalKvV1SecretEngine.writeSecret(this.vaultClient, (String)token, mount, path, secret);
            }
            VaultKvSecretV2WriteBody body = new VaultKvSecretV2WriteBody();
            body.data = secret;
            return this.vaultInternalKvV2SecretEngine.writeSecret(this.vaultClient, (String)token, mount, path, body);
        });
    }

    @Override
    public Uni<Void> deleteSecret(String path) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> {
            String mount = this.getConfig().kvSecretEngineMountPath;
            if (this.isV1()) {
                return this.vaultInternalKvV1SecretEngine.deleteSecret(this.vaultClient, (String)token, mount, path);
            }
            return this.vaultInternalKvV2SecretEngine.deleteSecret(this.vaultClient, (String)token, mount, path);
        });
    }

    @Override
    public Uni<List<String>> listSecrets(String path) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> {
            String mount = this.getConfig().kvSecretEngineMountPath;
            return (this.isV1() ? this.vaultInternalKvV1SecretEngine.listSecrets(this.vaultClient, (String)token, mount, path) : this.vaultInternalKvV2SecretEngine.listSecrets(this.vaultClient, (String)token, mount, path)).map(r -> ((VaultKvListSecretsData)r.data).keys);
        });
    }

    private boolean isV1() {
        return this.getConfig().kvSecretEngineVersion == 1;
    }
}

