/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault;

import io.quarkus.vault.VaultPKISecretReactiveEngine;
import io.quarkus.vault.pki.CAChainData;
import io.quarkus.vault.pki.CRLData;
import io.quarkus.vault.pki.CertificateData;
import io.quarkus.vault.pki.ConfigCRLOptions;
import io.quarkus.vault.pki.ConfigURLsOptions;
import io.quarkus.vault.pki.DataFormat;
import io.quarkus.vault.pki.GenerateCertificateOptions;
import io.quarkus.vault.pki.GenerateIntermediateCSROptions;
import io.quarkus.vault.pki.GenerateRootOptions;
import io.quarkus.vault.pki.GeneratedCertificate;
import io.quarkus.vault.pki.GeneratedIntermediateCSRResult;
import io.quarkus.vault.pki.GeneratedRootCertificate;
import io.quarkus.vault.pki.RoleOptions;
import io.quarkus.vault.pki.SignIntermediateCAOptions;
import io.quarkus.vault.pki.SignedCertificate;
import io.quarkus.vault.pki.TidyOptions;
import java.time.OffsetDateTime;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class VaultPKISecretEngine {
    private final VaultPKISecretReactiveEngine engine;

    public VaultPKISecretEngine() {
    }

    @Inject
    public VaultPKISecretEngine(VaultPKISecretReactiveEngine engine) {
        this.engine = engine;
    }

    public CertificateData.PEM getCertificateAuthority() {
        return (CertificateData.PEM)this.engine.getCertificateAuthority().await().indefinitely();
    }

    public CertificateData getCertificateAuthority(DataFormat format) {
        return (CertificateData)this.engine.getCertificateAuthority(format).await().indefinitely();
    }

    public void configCertificateAuthority(String pemBundle) {
        this.engine.configCertificateAuthority(pemBundle).await().indefinitely();
    }

    public void configURLs(ConfigURLsOptions options) {
        this.engine.configURLs(options).await().indefinitely();
    }

    public ConfigURLsOptions readURLsConfig() {
        return (ConfigURLsOptions)this.engine.readURLsConfig().await().indefinitely();
    }

    public void configCRL(ConfigCRLOptions options) {
        this.engine.configCRL(options).await().indefinitely();
    }

    public ConfigCRLOptions readCRLConfig() {
        return (ConfigCRLOptions)this.engine.readCRLConfig().await().indefinitely();
    }

    public CAChainData.PEM getCertificateAuthorityChain() {
        return (CAChainData.PEM)this.engine.getCertificateAuthorityChain().await().indefinitely();
    }

    public CRLData.PEM getCertificateRevocationList() {
        return (CRLData.PEM)this.engine.getCertificateRevocationList().await().indefinitely();
    }

    public CRLData getCertificateRevocationList(DataFormat format) {
        return (CRLData)this.engine.getCertificateRevocationList(format).await().indefinitely();
    }

    public boolean rotateCertificateRevocationList() {
        return (Boolean)this.engine.rotateCertificateRevocationList().await().indefinitely();
    }

    public List<String> getCertificates() {
        return (List)this.engine.getCertificates().await().indefinitely();
    }

    public CertificateData.PEM getCertificate(String serial) {
        return (CertificateData.PEM)this.engine.getCertificate(serial).await().indefinitely();
    }

    public GeneratedCertificate generateCertificate(String role, GenerateCertificateOptions options) {
        return (GeneratedCertificate)this.engine.generateCertificate(role, options).await().indefinitely();
    }

    public SignedCertificate signRequest(String role, String pemSigningRequest, GenerateCertificateOptions options) {
        return (SignedCertificate)this.engine.signRequest(role, pemSigningRequest, options).await().indefinitely();
    }

    public OffsetDateTime revokeCertificate(String serialNumber) {
        return (OffsetDateTime)this.engine.revokeCertificate(serialNumber).await().indefinitely();
    }

    public void updateRole(String role, RoleOptions options) {
        this.engine.updateRole(role, options).await().indefinitely();
    }

    public RoleOptions getRole(String role) {
        return (RoleOptions)this.engine.getRole(role).await().indefinitely();
    }

    public List<String> getRoles() {
        return (List)this.engine.getRoles().await().indefinitely();
    }

    public void deleteRole(String role) {
        this.engine.deleteRole(role).await().indefinitely();
    }

    public GeneratedRootCertificate generateRoot(GenerateRootOptions options) {
        return (GeneratedRootCertificate)this.engine.generateRoot(options).await().indefinitely();
    }

    public void deleteRoot() {
        this.engine.deleteRoot().await().indefinitely();
    }

    public SignedCertificate signIntermediateCA(String pemSigningRequest, SignIntermediateCAOptions options) {
        return (SignedCertificate)this.engine.signIntermediateCA(pemSigningRequest, options).await().indefinitely();
    }

    public GeneratedIntermediateCSRResult generateIntermediateCSR(GenerateIntermediateCSROptions options) {
        return (GeneratedIntermediateCSRResult)this.engine.generateIntermediateCSR(options).await().indefinitely();
    }

    public void setSignedIntermediateCA(String pemCert) {
        this.engine.setSignedIntermediateCA(pemCert).await().indefinitely();
    }

    public void tidy(TidyOptions options) {
        this.engine.tidy(options).await().indefinitely();
    }
}

