/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIoer19;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIoer
extends T4CTTIoer19 {
    long oertyp2;
    long oerchksm;

    T4CTTIoer(T4CConnection t4CConnection) {
        super(t4CConnection);
    }

    @Override
    void init() {
        super.init();
        this.oertyp2 = 0L;
        this.oerchksm = 0L;
    }

    @Override
    int unmarshal() throws IOException, SQLException {
        this.unmarshalAttributes();
        if (this.oerrcd2 != 0L) {
            this.unmarshalErrorMessage();
        }
        return this.currCursorID;
    }

    @Override
    void unmarshalAttributes() throws IOException, SQLException {
        super.unmarshalAttributes();
        if (this.connection.getTTCVersion() >= 14) {
            this.oertyp2 = this.meg.unmarshalUB4();
            this.oerchksm = this.meg.unmarshalUB4();
        }
    }

    @Override
    void print() throws SQLException {
        super.print();
    }

    @Override
    long updateChecksum(long l2) throws SQLException {
        l2 = super.updateChecksum(l2);
        l2 = CRC64.updateChecksum(l2, this.oertyp2);
        l2 = CRC64.updateChecksum(l2, this.oerchksm);
        return l2;
    }
}

