/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability;

import com.openshift.restclient.IApiTypeMapper;
import com.openshift.restclient.IClient;
import com.openshift.restclient.UnsupportedEndpointException;
import com.openshift.restclient.capability.ICapability;
import com.openshift.restclient.model.IResource;

public abstract class AbstractCapability
implements ICapability {
    private IApiTypeMapper mapper;
    private IResource resource;
    private final String capability;

    protected AbstractCapability(IResource resource, IClient client, String capability) {
        this.capability = capability;
        this.resource = resource;
        this.mapper = client.adapt(IApiTypeMapper.class);
    }

    @Override
    public boolean isSupported() {
        if (this.mapper != null) {
            try {
                return this.mapper.getEndpointFor(this.resource.getApiVersion(), this.resource.getKind()).isSupported(this.capability);
            }
            catch (UnsupportedEndpointException unsupportedEndpointException) {
                // empty catch block
            }
        }
        return false;
    }
}

