/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.policy;

import org.keycloak.Config;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.policy.PasswordPolicyConfigException;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PasswordPolicyProviderFactory;
import org.keycloak.policy.PolicyError;

public class HashAlgorithmPasswordPolicyProviderFactory
implements PasswordPolicyProviderFactory,
PasswordPolicyProvider {
    private KeycloakSession session;

    @Override
    public PasswordPolicyProvider create(KeycloakSession session) {
        this.session = session;
        return this;
    }

    @Override
    public void init(Config.Scope config) {
    }

    @Override
    public void postInit(KeycloakSessionFactory factory) {
    }

    @Override
    public void close() {
    }

    @Override
    public String getId() {
        return "hashAlgorithm";
    }

    @Override
    public PolicyError validate(RealmModel realm, UserModel user, String password) {
        return null;
    }

    @Override
    public PolicyError validate(String user, String password) {
        return null;
    }

    @Override
    public String getDisplayName() {
        return "Hashing Algorithm";
    }

    @Override
    public String getConfigType() {
        return "String";
    }

    @Override
    public String getDefaultConfigValue() {
        return "pbkdf2-sha256";
    }

    @Override
    public boolean isMultiplSupported() {
        return false;
    }

    @Override
    public Object parseConfig(String value) {
        String providerId = value != null && value.length() > 0 ? value : "pbkdf2-sha256";
        PasswordHashProvider provider = this.session.getProvider(PasswordHashProvider.class, providerId);
        if (provider == null) {
            throw new PasswordPolicyConfigException("Password hashing provider not found");
        }
        return providerId;
    }
}

