/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.UnsureResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class PartitionHandlingManagerImpl
implements PartitionHandlingManager {
    private static final Log log = LogFactory.getLog(PartitionHandlingManagerImpl.class);
    private final Map<GlobalTransaction, TransactionInfo> partialTransactions;
    private final PartitionHandling partitionHandling;
    private volatile AvailabilityMode availabilityMode = AvailabilityMode.AVAILABLE;
    @ComponentName(value="cacheName")
    @Inject
    String cacheName;
    @Inject
    protected DistributionManager distributionManager;
    @Inject
    LocalTopologyManager localTopologyManager;
    @Inject
    CacheNotifier<Object, Object> notifier;
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    RpcManager rpcManager;
    @Inject
    LockManager lockManager;

    public PartitionHandlingManagerImpl(Configuration configuration) {
        this.partialTransactions = new ConcurrentHashMap<GlobalTransaction, TransactionInfo>();
        this.partitionHandling = configuration.clustering().partitionHandling().whenSplit();
    }

    @Override
    public AvailabilityMode getAvailabilityMode() {
        return this.availabilityMode;
    }

    private void updateAvailabilityMode(AvailabilityMode mode) {
        log.debugf("Updating availability for cache %s: %s -> %s", this.cacheName, (Object)this.availabilityMode, (Object)mode);
        this.availabilityMode = mode;
    }

    @Override
    public CompletionStage<Void> setAvailabilityMode(AvailabilityMode availabilityMode) {
        if (availabilityMode != this.availabilityMode) {
            return this.notifier.notifyPartitionStatusChanged(availabilityMode, true).thenCompose(ignore -> {
                this.updateAvailabilityMode(availabilityMode);
                return this.notifier.notifyPartitionStatusChanged(availabilityMode, false);
            });
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public void checkWrite(Object key) {
        this.doCheck(key, true, 0L);
    }

    @Override
    public void checkRead(Object key, long flagBitSet) {
        this.doCheck(key, false, flagBitSet);
    }

    @Override
    public void checkClear() {
        if (this.isBulkOperationForbidden(true)) {
            throw Log.CONTAINER.clearDisallowedWhilePartitioned();
        }
    }

    @Override
    public void checkBulkRead() {
        if (this.isBulkOperationForbidden(false)) {
            throw Log.CONTAINER.partitionDegraded();
        }
    }

    @Override
    public CacheTopology getLastStableTopology() {
        return this.localTopologyManager.getStableCacheTopology(this.cacheName);
    }

    @Override
    public boolean addPartialRollbackTransaction(GlobalTransaction globalTransaction, Collection<Address> affectedNodes, Collection<Object> lockedKeys) {
        if (log.isTraceEnabled()) {
            log.tracef("Added partially rollback transaction %s", globalTransaction);
        }
        this.partialTransactions.put(globalTransaction, new RollbackTransactionInfo(globalTransaction, affectedNodes, lockedKeys));
        return true;
    }

    @Override
    public boolean addPartialCommit2PCTransaction(GlobalTransaction globalTransaction, Collection<Address> affectedNodes, Collection<Object> lockedKeys, Map<Object, IncrementableEntryVersion> newVersions) {
        if (log.isTraceEnabled()) {
            log.tracef("Added partially committed (2PC) transaction %s", globalTransaction);
        }
        this.partialTransactions.put(globalTransaction, new Commit2PCTransactionInfo(globalTransaction, affectedNodes, lockedKeys, newVersions));
        return true;
    }

    @Override
    public boolean addPartialCommit1PCTransaction(GlobalTransaction globalTransaction, Collection<Address> affectedNodes, Collection<Object> lockedKeys, List<WriteCommand> modifications) {
        if (log.isTraceEnabled()) {
            log.tracef("Added partially committed (1PC) transaction %s", globalTransaction);
        }
        this.partialTransactions.put(globalTransaction, new Commit1PCTransactionInfo(globalTransaction, affectedNodes, lockedKeys, modifications));
        return true;
    }

    @Override
    public boolean isTransactionPartiallyCommitted(GlobalTransaction globalTransaction) {
        boolean partiallyCommitted;
        TransactionInfo transactionInfo = this.partialTransactions.get(globalTransaction);
        boolean bl = partiallyCommitted = transactionInfo != null && !transactionInfo.isRolledBack();
        if (log.isTraceEnabled()) {
            log.tracef("Can release resources for transaction %s? %s. Transaction info=%s", globalTransaction, !partiallyCommitted, transactionInfo);
        }
        return partiallyCommitted;
    }

    @Override
    public Collection<GlobalTransaction> getPartialTransactions() {
        return Collections.unmodifiableCollection(this.partialTransactions.keySet());
    }

    @Override
    public boolean canRollbackTransactionAfterOriginatorLeave(GlobalTransaction globalTransaction) {
        boolean canRollback;
        boolean bl = canRollback = this.availabilityMode == AvailabilityMode.AVAILABLE && !this.getLastStableTopology().getActualMembers().contains(globalTransaction.getAddress());
        if (log.isTraceEnabled()) {
            log.tracef("Can rollback transaction? %s", canRollback);
        }
        return canRollback;
    }

    @Override
    public void onTopologyUpdate(CacheTopology cacheTopology) {
        if (this.isTopologyStable(cacheTopology)) {
            if (log.isDebugEnabled()) {
                log.debugf("On stable topology update. Pending txs: %d", this.partialTransactions.size());
            }
            for (TransactionInfo transactionInfo : this.partialTransactions.values()) {
                if (log.isTraceEnabled()) {
                    log.tracef("Completing transaction %s", transactionInfo.getGlobalTransaction());
                }
                this.completeTransaction(transactionInfo, cacheTopology);
            }
            if (log.isDebugEnabled()) {
                log.debug("Finished sending commit commands for partial completed transactions");
            }
        }
    }

    private void completeTransaction(TransactionInfo transactionInfo, CacheTopology cacheTopology) {
        List<Address> commitNodes = transactionInfo.getCommitNodes(cacheTopology);
        TransactionBoundaryCommand command = transactionInfo.buildCommand(this.commandsFactory);
        command.setTopologyId(cacheTopology.getTopologyId());
        CompletionStage<Map<Address, Response>> remoteInvocation = commitNodes != null ? this.rpcManager.invokeCommand(commitNodes, (ReplicableCommand)command, MapResponseCollector.ignoreLeavers(commitNodes.size()), this.rpcManager.getSyncRpcOptions()) : this.rpcManager.invokeCommandOnAll(command, MapResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions());
        remoteInvocation.whenComplete((responseMap, throwable) -> {
            boolean trace = log.isTraceEnabled();
            GlobalTransaction globalTransaction = transactionInfo.getGlobalTransaction();
            if (throwable != null) {
                log.failedPartitionHandlingTxCompletion(globalTransaction, (Throwable)throwable);
                return;
            }
            if (trace) {
                log.tracef("Future done for transaction %s. Response are %s", globalTransaction, responseMap);
            }
            for (Response response : responseMap.values()) {
                if (response != UnsureResponse.INSTANCE && response != CacheNotFoundResponse.INSTANCE) continue;
                if (trace) {
                    log.tracef("Topology changed while completing partial transaction %s", globalTransaction);
                }
                return;
            }
            if (trace) {
                log.tracef("Performing cleanup for transaction %s", globalTransaction);
            }
            this.lockManager.unlockAll(transactionInfo.getLockedKeys(), globalTransaction);
            this.partialTransactions.remove(globalTransaction);
            TxCompletionNotificationCommand completionCommand = this.commandsFactory.buildTxCompletionNotificationCommand(null, globalTransaction);
            this.rpcManager.sendToAll(completionCommand, DeliverOrder.NONE);
        });
    }

    private boolean isTopologyStable(CacheTopology cacheTopology) {
        CacheTopology stableTopology = this.localTopologyManager.getStableCacheTopology(this.cacheName);
        if (log.isTraceEnabled()) {
            log.tracef("Check if topology %s is stable. Last stable topology is %s", cacheTopology, stableTopology);
        }
        return stableTopology != null && stableTopology.equals(cacheTopology);
    }

    protected void doCheck(Object key, boolean isWrite, long flagBitSet) {
        if (log.isTraceEnabled()) {
            log.tracef("Checking availability for key=%s, status=%s", key, (Object)this.availabilityMode);
        }
        if (this.availabilityMode == AvailabilityMode.AVAILABLE) {
            return;
        }
        LocalizedCacheTopology cacheTopology = this.distributionManager.getCacheTopology();
        if (this.isKeyOperationAllowed(isWrite, flagBitSet, cacheTopology, key)) {
            if (log.isTraceEnabled()) {
                log.tracef("Key %s is available.", key);
            }
            return;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Partition is in %s mode, PartitionHandling is set to to %s, access is not allowed for key %s", (Object)this.availabilityMode, (Object)this.partitionHandling, key);
        }
        if (EnumUtil.containsAny((long)flagBitSet, (long)FlagBitSets.FORCE_WRITE_LOCK)) {
            throw Log.CONTAINER.degradedModeLockUnavailable(key);
        }
        throw Log.CONTAINER.degradedModeKeyUnavailable(key);
    }

    protected boolean isKeyOperationAllowed(boolean isWrite, long flagBitSet, LocalizedCacheTopology cacheTopology, Object key) {
        if (this.availabilityMode == AvailabilityMode.AVAILABLE) {
            return true;
        }
        assert (this.partitionHandling != PartitionHandling.ALLOW_READ_WRITES) : "ALLOW_READ_WRITES caches should always be AVAILABLE";
        List<Address> actualMembers = cacheTopology.getActualMembers();
        switch (this.partitionHandling) {
            case ALLOW_READS: {
                List<Address> owners = this.getOwners(cacheTopology, key, isWrite);
                if (isWrite || EnumUtil.containsAny((long)flagBitSet, (long)FlagBitSets.FORCE_WRITE_LOCK)) {
                    return actualMembers.containsAll(owners);
                }
                return InfinispanCollections.containsAny(actualMembers, owners);
            }
            case DENY_READ_WRITES: {
                return actualMembers.containsAll(this.getOwners(cacheTopology, key, isWrite));
            }
        }
        throw new IllegalStateException("Unsupported partition handling type: " + (Object)((Object)this.partitionHandling));
    }

    private boolean isBulkOperationForbidden(boolean isWrite) {
        if (this.availabilityMode == AvailabilityMode.AVAILABLE) {
            return false;
        }
        assert (this.partitionHandling != PartitionHandling.ALLOW_READ_WRITES) : "ALLOW_READ_WRITES caches should always be AVAILABLE";
        if (isWrite) {
            return true;
        }
        switch (this.partitionHandling) {
            case ALLOW_READS: {
                LocalizedCacheTopology cacheTopology = this.distributionManager.getCacheTopology();
                for (int i = 0; i < cacheTopology.getReadConsistentHash().getNumSegments(); ++i) {
                    List<Address> owners = cacheTopology.getSegmentDistribution(i).readOwners();
                    if (InfinispanCollections.containsAny(owners, cacheTopology.getActualMembers())) continue;
                    return true;
                }
                return false;
            }
            case DENY_READ_WRITES: {
                return true;
            }
        }
        throw new IllegalStateException("Unsupported partition handling type: " + (Object)((Object)this.partitionHandling));
    }

    protected PartitionHandling getPartitionHandling() {
        return this.partitionHandling;
    }

    private List<Address> getOwners(LocalizedCacheTopology cacheTopology, Object key, boolean isWrite) {
        DistributionInfo distribution = cacheTopology.getDistribution(key);
        return isWrite ? distribution.writeOwners() : distribution.readOwners();
    }

    private static abstract class BaseTransactionInfo
    implements TransactionInfo {
        private final GlobalTransaction globalTransaction;
        private final Collection<Address> affectedNodes;
        private final Collection<Object> lockedKeys;

        protected BaseTransactionInfo(GlobalTransaction globalTransaction, Collection<Address> affectedNodes, Collection<Object> lockedKeys) {
            this.globalTransaction = globalTransaction;
            this.lockedKeys = lockedKeys;
            this.affectedNodes = affectedNodes;
        }

        @Override
        public final List<Address> getCommitNodes(CacheTopology stableTopology) {
            if (this.affectedNodes == null) {
                return null;
            }
            ArrayList<Address> commitNodes = new ArrayList<Address>(this.affectedNodes);
            commitNodes.retainAll(stableTopology.getActualMembers());
            return commitNodes;
        }

        @Override
        public final GlobalTransaction getGlobalTransaction() {
            return this.globalTransaction;
        }

        @Override
        public Collection<Object> getLockedKeys() {
            return this.lockedKeys;
        }

        public String toString() {
            return "TransactionInfo{globalTransaction=" + this.globalTransaction + ", rollback=" + this.isRolledBack() + ", affectedNodes=" + this.affectedNodes + '}';
        }
    }

    private static class Commit1PCTransactionInfo
    extends BaseTransactionInfo {
        private final List<WriteCommand> modifications;

        public Commit1PCTransactionInfo(GlobalTransaction globalTransaction, Collection<Address> affectedNodes, Collection<Object> lockedKeys, List<WriteCommand> modifications) {
            super(globalTransaction, affectedNodes, lockedKeys);
            this.modifications = modifications;
        }

        @Override
        public boolean isRolledBack() {
            return false;
        }

        @Override
        public TransactionBoundaryCommand buildCommand(CommandsFactory commandsFactory) {
            return commandsFactory.buildPrepareCommand(this.getGlobalTransaction(), this.modifications, true);
        }
    }

    private static class Commit2PCTransactionInfo
    extends BaseTransactionInfo {
        private final Map<Object, IncrementableEntryVersion> newVersions;

        public Commit2PCTransactionInfo(GlobalTransaction globalTransaction, Collection<Address> affectedNodes, Collection<Object> lockedKeys, Map<Object, IncrementableEntryVersion> newVersions) {
            super(globalTransaction, affectedNodes, lockedKeys);
            this.newVersions = newVersions;
        }

        @Override
        public boolean isRolledBack() {
            return false;
        }

        @Override
        public TransactionBoundaryCommand buildCommand(CommandsFactory commandsFactory) {
            if (this.newVersions != null) {
                VersionedCommitCommand commitCommand = commandsFactory.buildVersionedCommitCommand(this.getGlobalTransaction());
                commitCommand.setUpdatedVersions(this.newVersions);
                return commitCommand;
            }
            return commandsFactory.buildCommitCommand(this.getGlobalTransaction());
        }
    }

    private static class RollbackTransactionInfo
    extends BaseTransactionInfo {
        protected RollbackTransactionInfo(GlobalTransaction globalTransaction, Collection<Address> affectedNodes, Collection<Object> lockedKeys) {
            super(globalTransaction, affectedNodes, lockedKeys);
        }

        @Override
        public boolean isRolledBack() {
            return true;
        }

        @Override
        public TransactionBoundaryCommand buildCommand(CommandsFactory commandsFactory) {
            return commandsFactory.buildRollbackCommand(this.getGlobalTransaction());
        }
    }

    private static interface TransactionInfo {
        public boolean isRolledBack();

        public List<Address> getCommitNodes(CacheTopology var1);

        public TransactionBoundaryCommand buildCommand(CommandsFactory var1);

        public GlobalTransaction getGlobalTransaction();

        public Collection<Object> getLockedKeys();
    }
}

