/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

final class LinuxIDUtil {
    private LinuxIDUtil() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static String getLinuxID(String option) {
        try {
            StringBuilder responseBuilder = new StringBuilder();
            ProcessBuilder idPB = new ProcessBuilder(new String[0]).command("id", option);
            idPB.redirectError(new File("/dev/null"));
            idPB.redirectInput(new File("/dev/null"));
            Process process = idPB.start();
            try (InputStream inputStream = process.getInputStream();){
                String string;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        responseBuilder.append(line);
                    }
                    LinuxIDUtil.safeWaitFor(process);
                    string = responseBuilder.toString();
                }
                return string;
            }
            catch (Throwable t) {
                LinuxIDUtil.safeWaitFor(process);
                throw t;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    private static void safeWaitFor(Process process) {
        boolean intr = false;
        while (true) {
            try {
                process.waitFor();
                return;
            }
            catch (InterruptedException ex) {
                intr = true;
                continue;
            }
            break;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

