/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.wait.strategy;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.wait.internal.ExternalPortListeningCheck;
import org.testcontainers.containers.wait.internal.InternalCommandPortListeningCheck;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;
import org.testcontainers.shaded.org.awaitility.Awaitility;

public class HostPortWaitStrategy
extends AbstractWaitStrategy {
    private static final Logger log = LoggerFactory.getLogger(HostPortWaitStrategy.class);

    @Override
    protected void waitUntilReady() {
        Set<Integer> externalLivenessCheckPorts = this.getLivenessCheckPorts();
        if (externalLivenessCheckPorts.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Liveness check ports of {} is empty. Not waiting.", (Object)this.waitStrategyTarget.getContainerInfo().getName());
            }
            return;
        }
        List<Integer> exposedPorts = this.waitStrategyTarget.getExposedPorts();
        Set<Integer> internalPorts = this.getInternalPorts(externalLivenessCheckPorts, exposedPorts);
        InternalCommandPortListeningCheck internalCheck = new InternalCommandPortListeningCheck(this.waitStrategyTarget, internalPorts);
        ExternalPortListeningCheck externalCheck = new ExternalPortListeningCheck(this.waitStrategyTarget, externalLivenessCheckPorts);
        try {
            List futures = EXECUTOR.invokeAll(Arrays.asList(() -> {
                Instant now = Instant.now();
                Boolean result = (Boolean)internalCheck.call();
                log.debug("Internal port check {} for {} in {}", new Object[]{Boolean.TRUE.equals(result) ? "passed" : "failed", internalPorts, Duration.between(now, Instant.now())});
                return result;
            }, () -> {
                Instant now = Instant.now();
                Awaitility.await().pollInSameThread().pollInterval(Duration.ofMillis(100L)).pollDelay(Duration.ZERO).ignoreExceptions().forever().until(externalCheck);
                log.debug("External port check passed for {} mapped as {} in {}", new Object[]{internalPorts, externalLivenessCheckPorts, Duration.between(now, Instant.now())});
                return true;
            }), this.startupTimeout.getSeconds(), TimeUnit.SECONDS);
            for (Future future : futures) {
                future.get(0L, TimeUnit.SECONDS);
            }
        }
        catch (CancellationException | ExecutionException | TimeoutException e) {
            throw new ContainerLaunchException("Timed out waiting for container port to open (" + this.waitStrategyTarget.getHost() + " ports: " + externalLivenessCheckPorts + " should be listening)");
        }
    }

    private Set<Integer> getInternalPorts(Set<Integer> externalLivenessCheckPorts, List<Integer> exposedPorts) {
        return exposedPorts.stream().filter(it -> externalLivenessCheckPorts.contains(this.waitStrategyTarget.getMappedPort((int)it))).collect(Collectors.toSet());
    }
}

