/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa;

import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.internal.PersistenceXmlParser;
import org.hibernate.jpa.boot.spi.Bootstrap;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.common.Profile;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.component.AmphibianProviderFactory;
import org.keycloak.events.Event;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SingleUseObjectValueModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.dblock.DBLockProvider;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.client.MapProtocolMapperEntityImpl;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.realm.entity.MapAuthenticationExecutionEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationExecutionEntityImpl;
import org.keycloak.models.map.realm.entity.MapAuthenticationFlowEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationFlowEntityImpl;
import org.keycloak.models.map.realm.entity.MapAuthenticatorConfigEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticatorConfigEntityImpl;
import org.keycloak.models.map.realm.entity.MapClientInitialAccessEntity;
import org.keycloak.models.map.realm.entity.MapClientInitialAccessEntityImpl;
import org.keycloak.models.map.realm.entity.MapIdentityProviderEntity;
import org.keycloak.models.map.realm.entity.MapIdentityProviderEntityImpl;
import org.keycloak.models.map.realm.entity.MapIdentityProviderMapperEntity;
import org.keycloak.models.map.realm.entity.MapIdentityProviderMapperEntityImpl;
import org.keycloak.models.map.realm.entity.MapOTPPolicyEntity;
import org.keycloak.models.map.realm.entity.MapOTPPolicyEntityImpl;
import org.keycloak.models.map.realm.entity.MapRequiredActionProviderEntity;
import org.keycloak.models.map.realm.entity.MapRequiredActionProviderEntityImpl;
import org.keycloak.models.map.realm.entity.MapRequiredCredentialEntity;
import org.keycloak.models.map.realm.entity.MapRequiredCredentialEntityImpl;
import org.keycloak.models.map.realm.entity.MapWebAuthnPolicyEntity;
import org.keycloak.models.map.realm.entity.MapWebAuthnPolicyEntityImpl;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.map.storage.jpa.JpaMapStorageProvider;
import org.keycloak.models.map.storage.jpa.JpaMapUtils;
import org.keycloak.models.map.storage.jpa.authSession.JpaRootAuthenticationSessionMapKeycloakTransaction;
import org.keycloak.models.map.storage.jpa.authSession.entity.JpaAuthenticationSessionEntity;
import org.keycloak.models.map.storage.jpa.authSession.entity.JpaRootAuthenticationSessionEntity;
import org.keycloak.models.map.storage.jpa.authorization.permission.JpaPermissionMapKeycloakTransaction;
import org.keycloak.models.map.storage.jpa.authorization.permission.entity.JpaPermissionEntity;
import org.keycloak.models.map.storage.jpa.authorization.policy.JpaPolicyMapKeycloakTransaction;
import org.keycloak.models.map.storage.jpa.authorization.policy.entity.JpaPolicyEntity;
import org.keycloak.models.map.storage.jpa.authorization.resource.JpaResourceMapKeycloakTransaction;
import org.keycloak.models.map.storage.jpa.authorization.resource.entity.JpaResourceEntity;
import org.keycloak.models.map.storage.jpa.authorization.resourceServer.JpaResourceServerMapKeycloakTransaction;
import org.keycloak.models.map.storage.jpa.authorization.resourceServer.entity.JpaResourceServerEntity;
import org.keycloak.models.map.storage.jpa.authorization.scope.JpaScopeMapKeycloakTransaction;
import org.keycloak.models.map.storage.jpa.authorization.scope.entity.JpaScopeEntity;
import org.keycloak.models.map.storage.jpa.client.JpaClientMapKeycloakTransaction;
import org.keycloak.models.map.storage.jpa.client.entity.JpaClientEntity;
import org.keycloak.models.map.storage.jpa.clientScope.JpaClientScopeMapKeycloakTransaction;
import org.keycloak.models.map.storage.jpa.clientScope.entity.JpaClientScopeEntity;
import org.keycloak.models.map.storage.jpa.event.admin.JpaAdminEventMapKeycloakTransaction;
import org.keycloak.models.map.storage.jpa.event.admin.entity.JpaAdminEventEntity;
import org.keycloak.models.map.storage.jpa.event.auth.JpaAuthEventMapKeycloakTransaction;
import org.keycloak.models.map.storage.jpa.event.auth.entity.JpaAuthEventEntity;
import org.keycloak.models.map.storage.jpa.group.JpaGroupMapKeycloakTransaction;
import org.keycloak.models.map.storage.jpa.group.entity.JpaGroupEntity;
import org.keycloak.models.map.storage.jpa.loginFailure.JpaUserLoginFailureMapKeycloakTransaction;
import org.keycloak.models.map.storage.jpa.loginFailure.entity.JpaUserLoginFailureEntity;
import org.keycloak.models.map.storage.jpa.realm.JpaRealmMapKeycloakTransaction;
import org.keycloak.models.map.storage.jpa.realm.entity.JpaComponentEntity;
import org.keycloak.models.map.storage.jpa.realm.entity.JpaRealmEntity;
import org.keycloak.models.map.storage.jpa.role.JpaRoleMapKeycloakTransaction;
import org.keycloak.models.map.storage.jpa.role.entity.JpaRoleEntity;
import org.keycloak.models.map.storage.jpa.singleUseObject.JpaSingleUseObjectMapKeycloakTransaction;
import org.keycloak.models.map.storage.jpa.singleUseObject.entity.JpaSingleUseObjectEntity;
import org.keycloak.models.map.storage.jpa.updater.MapJpaUpdaterProvider;
import org.keycloak.models.map.storage.jpa.user.JpaUserMapKeycloakTransaction;
import org.keycloak.models.map.storage.jpa.user.entity.JpaUserConsentEntity;
import org.keycloak.models.map.storage.jpa.user.entity.JpaUserEntity;
import org.keycloak.models.map.storage.jpa.user.entity.JpaUserFederatedIdentityEntity;
import org.keycloak.models.map.storage.jpa.userSession.JpaUserSessionMapKeycloakTransaction;
import org.keycloak.models.map.storage.jpa.userSession.entity.JpaClientSessionEntity;
import org.keycloak.models.map.storage.jpa.userSession.entity.JpaUserSessionEntity;
import org.keycloak.models.map.user.MapUserCredentialEntity;
import org.keycloak.models.map.user.MapUserCredentialEntityImpl;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class JpaMapStorageProviderFactory
implements AmphibianProviderFactory<MapStorageProvider>,
MapStorageProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "jpa";
    private static final String SESSION_TX_PREFIX = "jpa-map-tx-";
    private static final AtomicInteger ENUMERATOR = new AtomicInteger(0);
    private static final Logger logger = Logger.getLogger(JpaMapStorageProviderFactory.class);
    public static final String HIBERNATE_DEFAULT_SCHEMA = "hibernate.default_schema";
    private volatile EntityManagerFactory emf;
    private final Set<Class<?>> validatedModels = ConcurrentHashMap.newKeySet();
    private Config.Scope config;
    private final String sessionProviderKey;
    private final String sessionTxKey;
    private final ConcurrentHashMap<Class<?>, Object> SYNC_MODELS = new ConcurrentHashMap();
    public static final DeepCloner CLONER = new DeepCloner.Builder().constructor(JpaRootAuthenticationSessionEntity.class, JpaRootAuthenticationSessionEntity::new).constructor(JpaAuthenticationSessionEntity.class, JpaAuthenticationSessionEntity::new).constructor(JpaResourceServerEntity.class, JpaResourceServerEntity::new).constructor(JpaResourceEntity.class, JpaResourceEntity::new).constructor(JpaScopeEntity.class, JpaScopeEntity::new).constructor(JpaPermissionEntity.class, JpaPermissionEntity::new).constructor(JpaPolicyEntity.class, JpaPolicyEntity::new).constructor(JpaClientEntity.class, JpaClientEntity::new).constructor(MapProtocolMapperEntity.class, MapProtocolMapperEntityImpl::new).constructor(JpaClientScopeEntity.class, JpaClientScopeEntity::new).constructor(JpaAdminEventEntity.class, JpaAdminEventEntity::new).constructor(JpaAuthEventEntity.class, JpaAuthEventEntity::new).constructor(JpaGroupEntity.class, JpaGroupEntity::new).constructor(JpaRealmEntity.class, JpaRealmEntity::new).constructor(JpaComponentEntity.class, JpaComponentEntity::new).constructor(MapAuthenticationExecutionEntity.class, MapAuthenticationExecutionEntityImpl::new).constructor(MapAuthenticationFlowEntity.class, MapAuthenticationFlowEntityImpl::new).constructor(MapAuthenticatorConfigEntity.class, MapAuthenticatorConfigEntityImpl::new).constructor(MapClientInitialAccessEntity.class, MapClientInitialAccessEntityImpl::new).constructor(MapIdentityProviderEntity.class, MapIdentityProviderEntityImpl::new).constructor(MapIdentityProviderMapperEntity.class, MapIdentityProviderMapperEntityImpl::new).constructor(MapOTPPolicyEntity.class, MapOTPPolicyEntityImpl::new).constructor(MapRequiredActionProviderEntity.class, MapRequiredActionProviderEntityImpl::new).constructor(MapRequiredCredentialEntity.class, MapRequiredCredentialEntityImpl::new).constructor(MapWebAuthnPolicyEntity.class, MapWebAuthnPolicyEntityImpl::new).constructor(JpaRoleEntity.class, JpaRoleEntity::new).constructor(JpaSingleUseObjectEntity.class, JpaSingleUseObjectEntity::new).constructor(JpaUserLoginFailureEntity.class, JpaUserLoginFailureEntity::new).constructor(JpaUserEntity.class, JpaUserEntity::new).constructor(JpaUserConsentEntity.class, JpaUserConsentEntity::new).constructor(JpaUserFederatedIdentityEntity.class, JpaUserFederatedIdentityEntity::new).constructor(MapUserCredentialEntity.class, MapUserCredentialEntityImpl::new).constructor(JpaClientSessionEntity.class, JpaClientSessionEntity::new).constructor(JpaUserSessionEntity.class, JpaUserSessionEntity::new).build();
    private static final Map<Class<?>, BiFunction<KeycloakSession, EntityManager, MapKeycloakTransaction>> MODEL_TO_TX = new HashMap();

    public JpaMapStorageProviderFactory() {
        int index = ENUMERATOR.getAndIncrement();
        this.sessionProviderKey = "jpa-" + index;
        this.sessionTxKey = SESSION_TX_PREFIX + index;
    }

    public MapKeycloakTransaction createTransaction(KeycloakSession session, Class<?> modelType, EntityManager em) {
        return MODEL_TO_TX.get(modelType).apply(session, em);
    }

    public MapStorageProvider create(KeycloakSession session) {
        this.lazyInit();
        JpaMapStorageProvider provider = (JpaMapStorageProvider)session.getAttribute(this.sessionProviderKey, JpaMapStorageProvider.class);
        if (provider == null) {
            provider = new JpaMapStorageProvider(this, session, this.getEntityManager(), this.sessionTxKey);
            session.setAttribute(this.sessionProviderKey, (Object)provider);
        }
        return provider;
    }

    protected EntityManager getEntityManager() {
        return this.emf.createEntityManager();
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "JPA Map Storage";
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }

    public void close() {
        if (this.emf != null) {
            this.emf.close();
        }
        this.validatedModels.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (this.emf == null) {
            JpaMapStorageProviderFactory jpaMapStorageProviderFactory = this;
            synchronized (jpaMapStorageProviderFactory) {
                if (this.emf == null) {
                    this.emf = this.createEntityManagerFactory();
                    JpaMapUtils.addSpecificNamedQueries(this.emf);
                }
            }
        }
    }

    protected EntityManagerFactory createEntityManagerFactory() {
        logger.debugf("Initializing JPA connections %s", StackUtil.getShortStackTrace());
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String dataSource = this.config.get("dataSource");
        if (dataSource != null) {
            properties.put("javax.persistence.nonJtaDataSource", dataSource);
        } else {
            String password;
            properties.put("javax.persistence.jdbc.url", this.config.get("url"));
            properties.put("javax.persistence.jdbc.driver", this.config.get("driver"));
            String user = this.config.get("user");
            if (user != null) {
                properties.put("javax.persistence.jdbc.user", user);
            }
            if ((password = this.config.get("password")) != null) {
                properties.put("javax.persistence.jdbc.password", password);
            }
        }
        String schema = this.config.get("schema");
        if (schema != null) {
            properties.put(HIBERNATE_DEFAULT_SCHEMA, schema);
        }
        properties.put("hibernate.show_sql", this.config.getBoolean("showSql", Boolean.valueOf(false)));
        properties.put("hibernate.format_sql", this.config.getBoolean("formatSql", Boolean.valueOf(true)));
        properties.put("hibernate.dialect", this.config.get("driverDialect"));
        logger.trace((Object)"Creating EntityManagerFactory");
        ParsedPersistenceXmlDescriptor descriptor = PersistenceXmlParser.locateIndividualPersistenceUnit((URL)JpaMapStorageProviderFactory.class.getClassLoader().getResource("default-map-jpa-persistence.xml"));
        EntityManagerFactory emf = Bootstrap.getEntityManagerFactoryBuilder((PersistenceUnitDescriptor)descriptor, properties).build();
        logger.trace((Object)"EntityManagerFactory created");
        return emf;
    }

    protected EntityManagerFactory getEntityManagerFactory() {
        return this.emf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateAndUpdateSchema(KeycloakSession session, Class<?> modelType) {
        if (!this.validatedModels.contains(modelType)) {
            Object object = this.SYNC_MODELS.computeIfAbsent(modelType, mc -> new Object());
            synchronized (object) {
                if (!this.validatedModels.contains(modelType)) {
                    Connection connection = this.getConnection();
                    try {
                        MapJpaUpdaterProvider updater;
                        MapJpaUpdaterProvider.Status status;
                        if (logger.isDebugEnabled()) {
                            this.printOperationalInfo(connection);
                        }
                        if (!(status = (updater = (MapJpaUpdaterProvider)session.getProvider(MapJpaUpdaterProvider.class)).validate(modelType, connection, this.config.get("schema"))).equals((Object)MapJpaUpdaterProvider.Status.VALID)) {
                            this.update(modelType, connection, session);
                        }
                    }
                    finally {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (SQLException e) {
                                logger.warn((Object)"Can't close connection", (Throwable)e);
                            }
                        }
                    }
                    this.validatedModels.add(modelType);
                }
            }
        }
    }

    protected Connection getConnection() {
        try {
            String dataSourceLookup = this.config.get("dataSource");
            if (dataSourceLookup != null) {
                DataSource dataSource = (DataSource)new InitialContext().lookup(dataSourceLookup);
                return dataSource.getConnection();
            }
            Class.forName(this.config.get("driver"));
            return DriverManager.getConnection(StringPropertyReplacer.replaceProperties((String)this.config.get("url"), (Properties)System.getProperties()), this.config.get("user"), this.config.get("password"));
        }
        catch (ClassNotFoundException | SQLException | NamingException e) {
            throw new RuntimeException("Failed to connect to database", e);
        }
    }

    private void printOperationalInfo(Connection connection) {
        try {
            LinkedHashMap<String, String> operationalInfo = new LinkedHashMap<String, String>();
            DatabaseMetaData md = connection.getMetaData();
            operationalInfo.put("databaseUrl", md.getURL());
            operationalInfo.put("databaseUser", md.getUserName());
            operationalInfo.put("databaseProduct", md.getDatabaseProductName() + " " + md.getDatabaseProductVersion());
            operationalInfo.put("databaseDriver", md.getDriverName() + " " + md.getDriverVersion());
            logger.debugf("Database info: %s", (Object)operationalInfo.toString());
        }
        catch (SQLException e) {
            logger.warn((Object)("Unable to prepare operational info due database exception: " + e.getMessage()));
        }
    }

    private void update(Class<?> modelType, Connection connection, KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), lockSession -> {
            DBLockProvider dbLock = (DBLockProvider)session.getProvider(DBLockProvider.class);
            dbLock.waitForLock(DBLockProvider.Namespace.DATABASE);
            try {
                ((MapJpaUpdaterProvider)session.getProvider(MapJpaUpdaterProvider.class)).update(modelType, connection, this.config.get("schema"));
            }
            finally {
                dbLock.releaseLock();
            }
        });
    }

    static {
        MODEL_TO_TX.put(RootAuthenticationSessionModel.class, JpaRootAuthenticationSessionMapKeycloakTransaction::new);
        MODEL_TO_TX.put(ResourceServer.class, JpaResourceServerMapKeycloakTransaction::new);
        MODEL_TO_TX.put(Resource.class, JpaResourceMapKeycloakTransaction::new);
        MODEL_TO_TX.put(Scope.class, JpaScopeMapKeycloakTransaction::new);
        MODEL_TO_TX.put(PermissionTicket.class, JpaPermissionMapKeycloakTransaction::new);
        MODEL_TO_TX.put(Policy.class, JpaPolicyMapKeycloakTransaction::new);
        MODEL_TO_TX.put(ClientModel.class, JpaClientMapKeycloakTransaction::new);
        MODEL_TO_TX.put(ClientScopeModel.class, JpaClientScopeMapKeycloakTransaction::new);
        MODEL_TO_TX.put(AdminEvent.class, JpaAdminEventMapKeycloakTransaction::new);
        MODEL_TO_TX.put(Event.class, JpaAuthEventMapKeycloakTransaction::new);
        MODEL_TO_TX.put(GroupModel.class, JpaGroupMapKeycloakTransaction::new);
        MODEL_TO_TX.put(RealmModel.class, JpaRealmMapKeycloakTransaction::new);
        MODEL_TO_TX.put(RoleModel.class, JpaRoleMapKeycloakTransaction::new);
        MODEL_TO_TX.put(SingleUseObjectValueModel.class, JpaSingleUseObjectMapKeycloakTransaction::new);
        MODEL_TO_TX.put(UserLoginFailureModel.class, JpaUserLoginFailureMapKeycloakTransaction::new);
        MODEL_TO_TX.put(UserModel.class, JpaUserMapKeycloakTransaction::new);
        MODEL_TO_TX.put(UserSessionModel.class, JpaUserSessionMapKeycloakTransaction::new);
    }
}

