/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.authorization.scope;

import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.keycloak.authorization.model.Scope;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.storage.CriterionNotSupportedException;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaPredicateFunction;
import org.keycloak.models.map.storage.jpa.authorization.scope.entity.JpaScopeEntity;
import org.keycloak.storage.SearchableModelField;

public class JpaScopeModelCriteriaBuilder
extends JpaModelCriteriaBuilder<JpaScopeEntity, Scope, JpaScopeModelCriteriaBuilder> {
    public JpaScopeModelCriteriaBuilder() {
        super(JpaScopeModelCriteriaBuilder::new);
    }

    private JpaScopeModelCriteriaBuilder(JpaPredicateFunction<JpaScopeEntity> predicateFunc) {
        super(JpaScopeModelCriteriaBuilder::new, predicateFunc);
    }

    public JpaScopeModelCriteriaBuilder compare(SearchableModelField<? super Scope> modelField, ModelCriteriaBuilder.Operator op, Object ... value) {
        switch (op) {
            case EQ: {
                if (modelField == Scope.SearchableFields.ID || modelField == Scope.SearchableFields.RESOURCE_SERVER_ID) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaScopeModelCriteriaBuilder((cb, query, root) -> {
                        UUID uuid = (UUID)StringKeyConverter.UUIDKey.INSTANCE.fromStringSafe(Objects.toString(value[0], null));
                        if (uuid == null) {
                            return cb.or(new Predicate[0]);
                        }
                        return cb.equal((Expression)root.get(modelField.getName()), (Object)uuid);
                    });
                }
                if (modelField == Scope.SearchableFields.REALM_ID || modelField == Scope.SearchableFields.NAME) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaScopeModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.get(modelField.getName()), value[0]));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case ILIKE: {
                if (modelField == Scope.SearchableFields.NAME) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaScopeModelCriteriaBuilder((cb, query, root) -> cb.like(cb.lower((Expression)root.get(modelField.getName())), value[0].toString().toLowerCase()));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case IN: {
                if (modelField == Scope.SearchableFields.ID) {
                    Collection<? super Scope> collectionValues = this.getValuesForInOperator(value, modelField);
                    if (collectionValues.isEmpty()) {
                        return new JpaScopeModelCriteriaBuilder((cb, query, root) -> cb.or(new Predicate[0]));
                    }
                    return new JpaScopeModelCriteriaBuilder((cb, query, root) -> {
                        CriteriaBuilder.In in = cb.in((Expression)root.get("id"));
                        for (Object id : collectionValues) {
                            try {
                                in.value((Object)StringKeyConverter.UUIDKey.INSTANCE.fromString(Objects.toString(id, null)));
                            }
                            catch (IllegalArgumentException e) {
                                throw new CriterionNotSupportedException(modelField, op, id + " id is not in uuid format.", (Throwable)e);
                            }
                        }
                        return in;
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
        }
        throw new CriterionNotSupportedException(modelField, op);
    }
}

