/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Futures;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.MultiResultNode;
import io.quarkus.qute.ResultNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class Results {
    public static final CompletedStage<Object> FALSE = CompletedStage.of(false);
    public static final CompletedStage<Object> TRUE = CompletedStage.of(true);
    public static final CompletedStage<Object> NULL = CompletedStage.of(null);

    private Results() {
    }

    public static boolean isNotFound(Object result) {
        return result instanceof NotFound;
    }

    public static CompletionStage<Object> notFound(EvalContext evalContext) {
        return CompletedStage.of(NotFound.from(evalContext));
    }

    public static CompletionStage<Object> notFound(String name) {
        return CompletedStage.of(NotFound.from(name));
    }

    public static CompletionStage<Object> notFound() {
        return CompletedStage.of(NotFound.EMPTY);
    }

    static CompletionStage<ResultNode> process(List<CompletionStage<ResultNode>> results) {
        Supplier[] allResults = new Supplier[results.size()];
        ArrayList<CompletableFuture<ResultNode>> asyncResults = null;
        int idx = 0;
        for (CompletionStage<ResultNode> result : results) {
            if (result instanceof CompletedStage) {
                allResults[idx++] = (CompletedStage)result;
                continue;
            }
            CompletableFuture<ResultNode> fu = result.toCompletableFuture();
            if (asyncResults == null) {
                asyncResults = new ArrayList<CompletableFuture<ResultNode>>();
            }
            asyncResults.add(fu);
            allResults[idx++] = Futures.toSupplier(fu);
        }
        if (asyncResults == null) {
            return CompletedStage.of(new MultiResultNode(allResults));
        }
        CompletableFuture<ResultNode> ret = new CompletableFuture<ResultNode>();
        CompletableFuture<Void> cs = asyncResults.size() == 1 ? (CompletableFuture<Void>)asyncResults.get(0) : CompletableFuture.allOf(asyncResults.toArray(new CompletableFuture[0]));
        cs.whenComplete((v, t) -> {
            if (t != null) {
                ret.completeExceptionally((Throwable)t);
            } else {
                ret.complete(new MultiResultNode(allResults));
            }
        });
        return ret;
    }

    public static final class NotFound {
        public static final NotFound EMPTY = new NotFound(null, null);
        private final Optional<String> name;
        private final EvalContext evalContext;

        public static NotFound from(EvalContext context) {
            return new NotFound(Objects.requireNonNull(context), null);
        }

        public static NotFound from(String name) {
            return new NotFound(null, Objects.requireNonNull(name));
        }

        private NotFound(EvalContext evalContext, String name) {
            this.name = Optional.ofNullable(name);
            this.evalContext = evalContext;
        }

        public Optional<Object> getBase() {
            return this.evalContext != null ? Optional.ofNullable(this.evalContext.getBase()) : Optional.empty();
        }

        public Optional<String> getName() {
            return this.evalContext != null ? Optional.of(this.evalContext.getName()) : this.name;
        }

        public List<Expression> getParams() {
            return this.evalContext != null ? this.evalContext.getParams() : Collections.emptyList();
        }

        public String asMessage() {
            String name = this.getName().orElse(null);
            if (name != null) {
                Object base = this.getBase().orElse(null);
                List<Expression> params = this.getParams();
                boolean isDataMap = this.isDataMap(base);
                StringBuilder builder = new StringBuilder();
                if (isDataMap) {
                    builder.append("Entry ");
                } else if (params.isEmpty()) {
                    builder.append("Property ");
                } else {
                    builder.append("Method ");
                }
                builder.append("\"").append(name);
                if (!params.isEmpty()) {
                    builder.append("(");
                    builder.append(params.stream().map(Expression::toOriginalString).collect(Collectors.joining(",")));
                    builder.append(")");
                }
                builder.append("\" not found");
                if (isDataMap) {
                    builder.append(" in the data map");
                } else {
                    builder.append(" on the base object \"").append(base == null ? "null" : base.getClass().getName()).append("\"");
                }
                return builder.toString();
            }
            return "NOT_FOUND";
        }

        private boolean isDataMap(Object base) {
            if (base instanceof Map) {
                return ((Map)base).containsKey("io.quarkus.qute.dataMap");
            }
            if (base instanceof Mapper) {
                return ((Mapper)base).get("io.quarkus.qute.dataMap") != null;
            }
            return false;
        }

        public String toString() {
            return "NOT_FOUND";
        }
    }
}

