/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.hotRod.IckleQueryMapModelCriteriaBuilder;

public class IckleQueryOperators {
    private static final Pattern UNWANTED_CHARACTERS_REGEX = Pattern.compile("[^a-zA-Z\\d]");
    public static final String C = "c";
    private static final Map<ModelCriteriaBuilder.Operator, String> OPERATOR_TO_STRING = new HashMap<ModelCriteriaBuilder.Operator, String>();
    private static final Map<ModelCriteriaBuilder.Operator, ExpressionCombinator> OPERATOR_TO_EXPRESSION_COMBINATORS = new HashMap<ModelCriteriaBuilder.Operator, ExpressionCombinator>();

    private static String exists(String modelFieldName, Object[] values, Map<String, Object> parameters) {
        String field = "c." + modelFieldName;
        return field + " IS NOT NULL AND " + field + " IS NOT EMPTY";
    }

    private static String notExists(String modelFieldName, Object[] values, Map<String, Object> parameters) {
        String field = "c." + modelFieldName;
        return field + " IS NULL OR " + field + " IS EMPTY";
    }

    private static String like(String modelFieldName, Object[] values, Map<String, Object> parameters) {
        String sanitizedValue = (String)IckleQueryMapModelCriteriaBuilder.sanitizeNonAnalyzed(values[0]);
        return IckleQueryOperators.singleValueOperator(ModelCriteriaBuilder.Operator.LIKE).combine(modelFieldName, new String[]{sanitizedValue}, parameters);
    }

    private static String in(String modelFieldName, Object[] values, Map<String, Object> parameters) {
        Collection<Object> operands;
        if (values == null || values.length == 0) {
            return "false";
        }
        if (values.length == 1) {
            Object value0 = values[0];
            if (value0 instanceof Collection) {
                operands = (Collection)value0;
            } else if (value0 instanceof Stream) {
                try (Stream valueS = (Stream)value0;){
                    operands = valueS.collect(Collectors.toSet());
                }
            } else {
                operands = Collections.singleton(value0);
            }
        } else {
            operands = new HashSet<Object>(Arrays.asList(values));
        }
        return operands.isEmpty() ? "false" : "c." + modelFieldName + " IN (" + operands.stream().map(operand -> {
            String namedParam = IckleQueryOperators.findAvailableNamedParam(parameters.keySet(), modelFieldName);
            parameters.put(namedParam, operand);
            return ":" + namedParam;
        }).collect(Collectors.joining(", ")) + ")";
    }

    private static String removeForbiddenCharactersFromNamedParameter(String name) {
        return UNWANTED_CHARACTERS_REGEX.matcher(name).replaceAll("");
    }

    public static String findAvailableNamedParam(Set<String> existingNames, String namePrefix) {
        String namePrefixCleared = IckleQueryOperators.removeForbiddenCharactersFromNamedParameter(namePrefix);
        return IntStream.iterate(0, i -> i + 1).boxed().map(num -> namePrefixCleared + num).filter(name -> !existingNames.contains(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create Parameter name for " + namePrefix));
    }

    private static ExpressionCombinator singleValueOperator(ModelCriteriaBuilder.Operator op) {
        return (modelFieldName, values, parameters) -> {
            if (values.length != 1) {
                throw new RuntimeException("Invalid arguments, expected (" + modelFieldName + "), got: " + Arrays.toString(values));
            }
            if (values[0] == null && op.equals((Object)ModelCriteriaBuilder.Operator.EQ)) {
                return "c." + modelFieldName + " IS NULL";
            }
            String namedParameter = IckleQueryOperators.findAvailableNamedParam(parameters.keySet(), modelFieldName);
            parameters.put(namedParameter, values[0]);
            return "c." + modelFieldName + " " + IckleQueryOperators.operatorToString(op) + " :" + namedParameter;
        };
    }

    private static String operatorToString(ModelCriteriaBuilder.Operator op) {
        return OPERATOR_TO_STRING.get(op);
    }

    private static ExpressionCombinator operatorToExpressionCombinator(ModelCriteriaBuilder.Operator op) {
        return OPERATOR_TO_EXPRESSION_COMBINATORS.getOrDefault(op, IckleQueryOperators.singleValueOperator(op));
    }

    public static String combineExpressions(ModelCriteriaBuilder.Operator op, String modelFieldName, Object[] values, Map<String, Object> parameters) {
        return IckleQueryOperators.operatorToExpressionCombinator(op).combine(modelFieldName, values, parameters);
    }

    static {
        OPERATOR_TO_EXPRESSION_COMBINATORS.put(ModelCriteriaBuilder.Operator.IN, IckleQueryOperators::in);
        OPERATOR_TO_EXPRESSION_COMBINATORS.put(ModelCriteriaBuilder.Operator.EXISTS, IckleQueryOperators::exists);
        OPERATOR_TO_EXPRESSION_COMBINATORS.put(ModelCriteriaBuilder.Operator.NOT_EXISTS, IckleQueryOperators::notExists);
        OPERATOR_TO_EXPRESSION_COMBINATORS.put(ModelCriteriaBuilder.Operator.ILIKE, IckleQueryOperators::like);
        OPERATOR_TO_EXPRESSION_COMBINATORS.put(ModelCriteriaBuilder.Operator.LIKE, IckleQueryOperators::like);
        OPERATOR_TO_STRING.put(ModelCriteriaBuilder.Operator.EQ, "=");
        OPERATOR_TO_STRING.put(ModelCriteriaBuilder.Operator.NE, "!=");
        OPERATOR_TO_STRING.put(ModelCriteriaBuilder.Operator.LT, "<");
        OPERATOR_TO_STRING.put(ModelCriteriaBuilder.Operator.LE, "<=");
        OPERATOR_TO_STRING.put(ModelCriteriaBuilder.Operator.GT, ">");
        OPERATOR_TO_STRING.put(ModelCriteriaBuilder.Operator.GE, ">=");
        OPERATOR_TO_STRING.put(ModelCriteriaBuilder.Operator.LIKE, "LIKE");
        OPERATOR_TO_STRING.put(ModelCriteriaBuilder.Operator.ILIKE, "LIKE");
        OPERATOR_TO_STRING.put(ModelCriteriaBuilder.Operator.IN, "IN");
    }

    @FunctionalInterface
    private static interface ExpressionCombinator {
        public String combine(String var1, Object[] var2, Map<String, Object> var3);
    }
}

