/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.UserCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.UserCacheInvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class UserCacheRealmInvalidationEvent
extends InvalidationEvent
implements UserCacheInvalidationEvent {
    private String realmId;

    public static UserCacheRealmInvalidationEvent create(String realmId) {
        UserCacheRealmInvalidationEvent event = new UserCacheRealmInvalidationEvent();
        event.realmId = realmId;
        return event;
    }

    @Override
    public String getId() {
        return this.realmId;
    }

    public String toString() {
        return String.format("UserCacheRealmInvalidationEvent [ realmId=%s ]", this.realmId);
    }

    @Override
    public void addInvalidations(UserCacheManager userCache, Set<String> invalidations) {
        userCache.invalidateRealmUsers(this.realmId, invalidations);
    }

    public static class ExternalizerImpl
    implements Externalizer<UserCacheRealmInvalidationEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, UserCacheRealmInvalidationEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.realmId, (ObjectOutput)output);
        }

        public UserCacheRealmInvalidationEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public UserCacheRealmInvalidationEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            UserCacheRealmInvalidationEvent res = new UserCacheRealmInvalidationEvent();
            res.realmId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

