/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.providers.serialisers;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import org.jboss.resteasy.reactive.common.providers.serialisers.PrimitiveBodyHandler;

public class NumberMessageBodyHandler
extends PrimitiveBodyHandler
implements MessageBodyReader<Number> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Number.class.isAssignableFrom(type);
    }

    public Number readFrom(Class<Number> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return this.doReadFrom(type, entityStream);
    }

    protected Number doReadFrom(Class<Number> type, InputStream entityStream) throws IOException {
        String text = this.readFrom(entityStream, false);
        if (type == Byte.class || type == Byte.TYPE) {
            return Byte.valueOf(text);
        }
        if (type == Short.class || type == Short.TYPE) {
            return Integer.valueOf(text);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.valueOf(text);
        }
        if (type == Long.class || type == Long.TYPE) {
            return Long.valueOf(text);
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(text);
        }
        if (type == Double.class || type == Double.TYPE) {
            return Double.valueOf(text);
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(text);
        }
        if (type == BigInteger.class) {
            return new BigInteger(text);
        }
        throw new RuntimeException("Don't know how to handle number class " + type);
    }
}

