/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.configuration;

import java.util.List;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.server.core.configuration.SniConfiguration;

public class EncryptionConfiguration
extends ConfigurationElement<EncryptionConfiguration> {
    static final AttributeDefinition<String> SECURITY_REALM = AttributeDefinition.builder((String)"security-realm", null, String.class).build();
    static final AttributeDefinition<Boolean> REQUIRE_CLIENT_AUTH = AttributeDefinition.builder((String)"require-ssl-client-auth", (Object)false, Boolean.class).build();
    private final List<SniConfiguration> sniConfigurations;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(EncryptionConfiguration.class, new AttributeDefinition[]{REQUIRE_CLIENT_AUTH, SECURITY_REALM});
    }

    EncryptionConfiguration(AttributeSet attributes, List<SniConfiguration> sniConfigurations) {
        super("encryption", attributes, EncryptionConfiguration.children(sniConfigurations));
        this.sniConfigurations = sniConfigurations;
    }

    public List<SniConfiguration> sniConfigurations() {
        return this.sniConfigurations;
    }

    public String realm() {
        return (String)this.attributes.attribute(SECURITY_REALM).get();
    }

    public boolean requireClientAuth() {
        return (Boolean)this.attributes.attribute(REQUIRE_CLIENT_AUTH).get();
    }
}

