/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.security.simple;

import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthenticationException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.infinispan.server.core.security.AuthorizingCallbackHandler;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.core.security.SubjectUserInfo;
import org.infinispan.server.core.security.simple.SimpleGroupPrincipal;
import org.infinispan.server.core.security.simple.SimpleSubjectUserInfo;
import org.infinispan.server.core.security.simple.SimpleUserPrincipal;

public final class SimpleServerAuthenticationProvider
implements ServerAuthenticationProvider {
    private final Map<String, Map<String, Entry>> map = new HashMap<String, Map<String, Entry>>();

    @Override
    public AuthorizingCallbackHandler getCallbackHandler(String mechanismName, Map<String, String> mechanismProperties) {
        return new AuthorizingCallbackHandler(){
            Subject subject = new Subject();
            Principal userPrincipal;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                String userName = null;
                String realmName = null;
                Callback[] callbackArray = callbacks;
                int n = callbackArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Callback callback = callbackArray[n2];
                    if (callback instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)callback;
                        String defaultName = nameCallback.getDefaultName();
                        userName = defaultName.toLowerCase().trim();
                        nameCallback.setName(userName);
                        this.userPrincipal = new SimpleUserPrincipal(userName);
                        this.subject.getPrincipals().add(this.userPrincipal);
                    } else if (callback instanceof RealmCallback) {
                        RealmCallback realmCallback = (RealmCallback)callback;
                        String defaultRealm = realmCallback.getDefaultText();
                        if (defaultRealm != null) {
                            realmName = defaultRealm.toLowerCase().trim();
                            realmCallback.setText(realmName);
                        }
                    } else if (callback instanceof RealmChoiceCallback) {
                        RealmChoiceCallback realmChoiceCallback = (RealmChoiceCallback)callback;
                        realmChoiceCallback.setSelectedIndex(realmChoiceCallback.getDefaultChoice());
                    } else if (callback instanceof PasswordCallback) {
                        String[] stringArray;
                        PasswordCallback passwordCallback = (PasswordCallback)callback;
                        Entry entry = null;
                        if (realmName == null) {
                            stringArray = SimpleServerAuthenticationProvider.this.map;
                            // MONITORENTER : SimpleServerAuthenticationProvider.this.map
                            for (Map<String, Entry> realmMap : SimpleServerAuthenticationProvider.this.map.values()) {
                                if (!realmMap.containsKey(userName)) continue;
                                entry = realmMap.get(userName);
                                break;
                            }
                            // MONITOREXIT : stringArray
                        } else {
                            stringArray = SimpleServerAuthenticationProvider.this.map;
                            // MONITORENTER : stringArray
                            Map<String, Entry> realmMap = SimpleServerAuthenticationProvider.this.map.get(realmName);
                            if (realmMap != null) {
                                entry = realmMap.get(userName);
                            }
                            // MONITOREXIT : stringArray
                        }
                        if (entry == null) {
                            throw new AuthenticationException("No matching user found");
                        }
                        for (String group : entry.getGroups()) {
                            this.subject.getPrincipals().add(new SimpleGroupPrincipal(group));
                        }
                        passwordCallback.setPassword(entry.getPassword());
                    } else {
                        if (!(callback instanceof AuthorizeCallback)) throw new UnsupportedCallbackException(callback, "Callback not supported: " + callback);
                        AuthorizeCallback authorizeCallback = (AuthorizeCallback)callback;
                        authorizeCallback.setAuthorized(authorizeCallback.getAuthenticationID().equals(authorizeCallback.getAuthorizationID()));
                    }
                    ++n2;
                }
            }

            @Override
            public SubjectUserInfo getSubjectUserInfo(Collection<Principal> principals) {
                if (principals != null) {
                    this.subject.getPrincipals().addAll(principals);
                }
                if (this.userPrincipal != null) {
                    return new SimpleSubjectUserInfo(this.userPrincipal.getName(), this.subject);
                }
                return new SimpleSubjectUserInfo(this.subject);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUser(String userName, String userRealm, char[] password, String ... groups) {
        if (userName == null) {
            throw new IllegalArgumentException("userName is null");
        }
        if (userRealm == null) {
            throw new IllegalArgumentException("userRealm is null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password is null");
        }
        String canonUserRealm = userRealm.toLowerCase().trim();
        String canonUserName = userName.toLowerCase().trim();
        Map<String, Map<String, Entry>> map = this.map;
        synchronized (map) {
            Map<String, Entry> realmMap = this.map.get(canonUserRealm);
            if (realmMap == null) {
                realmMap = new HashMap<String, Entry>();
                this.map.put(canonUserRealm, realmMap);
            }
            realmMap.put(canonUserName, new Entry(canonUserName, canonUserRealm, password, groups != null ? groups : new String[]{}));
        }
    }

    private static final class Entry {
        private final String userName;
        private final String userRealm;
        private final char[] password;
        private final String[] groups;

        private Entry(String userName, String userRealm, char[] password, String[] groups) {
            this.userName = userName;
            this.userRealm = userRealm;
            this.password = password;
            this.groups = groups;
        }

        String getUserName() {
            return this.userName;
        }

        String getUserRealm() {
            return this.userRealm;
        }

        char[] getPassword() {
            return this.password;
        }

        String[] getGroups() {
            return this.groups;
        }
    }
}

