/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.telemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import java.util.Collections;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.server.core.telemetry.TelemetryService;
import org.infinispan.server.core.telemetry.impl.OpenTelemetryService;

@Scope(value=Scopes.GLOBAL)
@DefaultFactoryFor(classes={TelemetryService.class})
public class TelemetryServiceFactory
extends AbstractComponentFactory
implements AutoInstantiableFactory {
    private static final Log log = LogFactory.getLog(TelemetryServiceFactory.class);
    private static final String TRACING_ENABLED = System.getProperty("infinispan.tracing.enabled");

    public Object construct(String name) {
        if (TRACING_ENABLED == null || !"true".equalsIgnoreCase(TRACING_ENABLED.trim())) {
            log.telemetryDisabled();
            return null;
        }
        try {
            OpenTelemetrySdk openTelemetry = AutoConfiguredOpenTelemetrySdk.builder().addPropertiesSupplier(() -> Collections.singletonMap("otel.metrics.exporter", "none")).build().getOpenTelemetrySdk();
            log.telemetryLoaded((Object)openTelemetry);
            return new OpenTelemetryService((OpenTelemetry)openTelemetry);
        }
        catch (Throwable e) {
            log.errorOnLoadingTelemetry();
            return null;
        }
    }
}

