/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.caffeine.runtime.graal;

import java.lang.reflect.Executable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public class CacheConstructorsFeature
implements Feature {
    private final AtomicBoolean triggered = new AtomicBoolean(false);
    private static final boolean log = Boolean.getBoolean("io.quarkus.caffeine.graalvm.diagnostics");

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class caffeineCoreClazz = access.findClassByName("com.github.benmanes.caffeine.cache.Caffeine");
        access.registerReachabilityHandler(this::ensureCaffeineSupportEnabled, new Object[]{caffeineCoreClazz});
    }

    private void ensureCaffeineSupportEnabled(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        boolean needsEnablingYet = this.triggered.compareAndSet(false, true);
        if (needsEnablingYet) {
            if (log) {
                System.out.println("Quarkus's automatic feature for GraalVM native images: enabling support for core Caffeine caches");
            }
            this.registerCaffeineReflections(duringAnalysisAccess);
        }
    }

    private void registerCaffeineReflections(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        String[] needsHavingSimpleConstructors;
        for (String className : needsHavingSimpleConstructors = CacheConstructorsFeature.typesNeedingConstructorsRegistered()) {
            this.registerForReflection(className, duringAnalysisAccess);
        }
    }

    private void registerForReflection(String className, Feature.DuringAnalysisAccess duringAnalysisAccess) {
        Class aClass = duringAnalysisAccess.findClassByName(className);
        Executable[] z = aClass.getDeclaredConstructors();
        RuntimeReflection.register((Class[])new Class[]{aClass});
        RuntimeReflection.register((Executable[])z);
    }

    public static String[] typesNeedingConstructorsRegistered() {
        return new String[]{"com.github.benmanes.caffeine.cache.PDMS", "com.github.benmanes.caffeine.cache.PSA", "com.github.benmanes.caffeine.cache.PSMS", "com.github.benmanes.caffeine.cache.PSW", "com.github.benmanes.caffeine.cache.PSWMS", "com.github.benmanes.caffeine.cache.PSWMW", "com.github.benmanes.caffeine.cache.SILMS", "com.github.benmanes.caffeine.cache.SSA", "com.github.benmanes.caffeine.cache.SSLA", "com.github.benmanes.caffeine.cache.SSLMS", "com.github.benmanes.caffeine.cache.SSMS", "com.github.benmanes.caffeine.cache.SSMSA", "com.github.benmanes.caffeine.cache.SSMSW", "com.github.benmanes.caffeine.cache.SSW"};
    }
}

