/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.jpa.entities.PolicyEntity;
import org.keycloak.authorization.jpa.store.JPAAuthorizationStoreFactory;
import org.keycloak.authorization.jpa.store.PolicyAdapter;
import org.keycloak.authorization.jpa.store.ResourceServerAdapter;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.utils.StreamsUtil;

public class JPAPolicyStore
implements PolicyStore {
    private final EntityManager entityManager;
    private final AuthorizationProvider provider;

    public JPAPolicyStore(EntityManager entityManager, AuthorizationProvider provider) {
        this.entityManager = entityManager;
        this.provider = provider;
    }

    public Policy create(ResourceServer resourceServer, AbstractPolicyRepresentation representation) {
        PolicyEntity entity = new PolicyEntity();
        if (representation.getId() == null) {
            entity.setId(KeycloakModelUtils.generateId());
        } else {
            entity.setId(representation.getId());
        }
        entity.setType(representation.getType());
        entity.setName(representation.getName());
        entity.setResourceServer(ResourceServerAdapter.toEntity(this.entityManager, resourceServer));
        this.entityManager.persist((Object)entity);
        this.entityManager.flush();
        PolicyAdapter model = new PolicyAdapter(entity, this.entityManager, this.provider.getStoreFactory());
        return model;
    }

    public void delete(RealmModel realm, String id) {
        PolicyEntity policy = (PolicyEntity)this.entityManager.find(PolicyEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE);
        if (policy != null) {
            this.entityManager.remove((Object)policy);
        }
    }

    public Policy findById(RealmModel realm, ResourceServer resourceServer, String id) {
        if (id == null) {
            return null;
        }
        PolicyEntity policyEntity = (PolicyEntity)this.entityManager.find(PolicyEntity.class, (Object)id);
        if (policyEntity == null) {
            return null;
        }
        return new PolicyAdapter(policyEntity, this.entityManager, this.provider.getStoreFactory());
    }

    public Policy findByName(ResourceServer resourceServer, String name) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByName", PolicyEntity.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("serverId", (Object)resourceServer.getId());
        query.setParameter("name", (Object)name);
        try {
            return new PolicyAdapter((PolicyEntity)query.getSingleResult(), this.entityManager, this.provider.getStoreFactory());
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public List<Policy> findByResourceServer(ResourceServer resourceServer) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByServerId", String.class);
        query.setParameter("serverId", (Object)resourceServer.getId());
        List result = query.getResultList();
        LinkedList<Policy> list = new LinkedList<Policy>();
        for (String id : result) {
            Policy policy = this.provider.getStoreFactory().getPolicyStore().findById(JPAAuthorizationStoreFactory.NULL_REALM, resourceServer, id);
            if (!Objects.nonNull(policy)) continue;
            list.add(policy);
        }
        return list;
    }

    public List<Policy> find(RealmModel realm, ResourceServer resourceServer, Map<Policy.FilterOption, String[]> attributes, Integer firstResult, Integer maxResults) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery querybuilder = builder.createQuery(PolicyEntity.class);
        Root root = querybuilder.from(PolicyEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        querybuilder.select((Selection)root.get("id"));
        if (resourceServer != null) {
            predicates.add(builder.equal((Expression)root.get("resourceServer").get("id"), (Object)resourceServer.getId()));
        }
        attributes.forEach((filterOption, value) -> {
            switch (filterOption) {
                case ID: 
                case OWNER: {
                    predicates.add(root.get(filterOption.getName()).in((Object[])value));
                    break;
                }
                case SCOPE_ID: 
                case RESOURCE_ID: {
                    String[] predicateValues = filterOption.getName().split("\\.");
                    predicates.add(root.join(predicateValues[0]).get(predicateValues[1]).in((Object[])value));
                    break;
                }
                case PERMISSION: {
                    if (Boolean.parseBoolean(value[0])) {
                        predicates.add(root.get("type").in(new Object[]{"resource", "scope", "uma"}));
                        break;
                    }
                    predicates.add(builder.not((Expression)root.get("type").in(new Object[]{"resource", "scope", "uma"})));
                    break;
                }
                case ANY_OWNER: {
                    break;
                }
                case CONFIG: {
                    if (((String[])value).length != 2) {
                        throw new IllegalArgumentException("Config filter option requires value with two items: [config_name, expected_config_value]");
                    }
                    predicates.add(root.joinMap("config").key().in(new Object[]{value[0]}));
                    predicates.add(builder.like(root.joinMap("config").value().as(String.class), "%" + value[1] + "%"));
                    break;
                }
                case TYPE: 
                case NAME: {
                    predicates.add(builder.like(builder.lower((Expression)root.get(filterOption.getName())), "%" + value[0].toLowerCase() + "%"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported filter [" + filterOption + "]");
                }
            }
        });
        if (!attributes.containsKey(Policy.FilterOption.OWNER) && !attributes.containsKey(Policy.FilterOption.ANY_OWNER)) {
            predicates.add(builder.isNull((Expression)root.get("owner")));
        }
        querybuilder.where(predicates.toArray(new Predicate[predicates.size()])).orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        TypedQuery query = this.entityManager.createQuery(querybuilder);
        List result = PaginationUtils.paginateQuery(query, firstResult, maxResults).getResultList();
        LinkedList<Policy> list = new LinkedList<Policy>();
        PolicyStore policyStore = this.provider.getStoreFactory().getPolicyStore();
        for (String id : result) {
            Policy policy = policyStore.findById(JPAAuthorizationStoreFactory.NULL_REALM, resourceServer, id);
            if (!Objects.nonNull(policy)) continue;
            list.add(policy);
        }
        return list;
    }

    public void findByResource(ResourceServer resourceServer, Resource resource, Consumer<Policy> consumer) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByResource", PolicyEntity.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("resourceId", (Object)resource.getId());
        query.setParameter("serverId", (Object)resourceServer.getId());
        PolicyStore storeFactory = this.provider.getStoreFactory().getPolicyStore();
        StreamsUtil.closing(query.getResultStream().map(entity -> storeFactory.findById(JPAAuthorizationStoreFactory.NULL_REALM, resourceServer, entity.getId())).filter(Objects::nonNull)).forEach(consumer::accept);
    }

    public void findByResourceType(ResourceServer resourceServer, String resourceType, Consumer<Policy> consumer) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByResourceType", PolicyEntity.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("type", (Object)resourceType);
        query.setParameter("serverId", (Object)resourceServer.getId());
        StreamsUtil.closing(query.getResultStream().map(id -> new PolicyAdapter((PolicyEntity)id, this.entityManager, this.provider.getStoreFactory())).filter(Objects::nonNull)).forEach(consumer::accept);
    }

    public List<Policy> findByScopes(ResourceServer resourceServer, List<Scope> scopes) {
        if (scopes == null || scopes.isEmpty()) {
            return Collections.emptyList();
        }
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByScope", PolicyEntity.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("scopeIds", scopes.stream().map(Scope::getId).collect(Collectors.toSet()));
        query.setParameter("serverId", (Object)resourceServer.getId());
        LinkedList<Policy> list = new LinkedList<Policy>();
        PolicyStore storeFactory = this.provider.getStoreFactory().getPolicyStore();
        for (PolicyEntity entity : query.getResultList()) {
            list.add(storeFactory.findById(JPAAuthorizationStoreFactory.NULL_REALM, resourceServer, entity.getId()));
        }
        return list;
    }

    public void findByScopes(ResourceServer resourceServer, Resource resource, List<Scope> scopes, Consumer<Policy> consumer) {
        TypedQuery query;
        if (resource == null) {
            query = this.entityManager.createNamedQuery("findPolicyIdByNullResourceScope", PolicyEntity.class);
        } else {
            query = this.entityManager.createNamedQuery("findPolicyIdByResourceScope", PolicyEntity.class);
            query.setParameter("resourceId", (Object)resource.getId());
        }
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("scopeIds", scopes.stream().map(Scope::getId).collect(Collectors.toSet()));
        query.setParameter("serverId", (Object)resourceServer.getId());
        StoreFactory storeFactory = this.provider.getStoreFactory();
        StreamsUtil.closing(query.getResultStream().map(id -> new PolicyAdapter((PolicyEntity)id, this.entityManager, storeFactory)).filter(Objects::nonNull)).forEach(consumer::accept);
    }

    public List<Policy> findByType(ResourceServer resourceServer, String type) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByType", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("serverId", (Object)resourceServer.getId());
        query.setParameter("type", (Object)type);
        List result = query.getResultList();
        LinkedList<Policy> list = new LinkedList<Policy>();
        for (String id : result) {
            Policy policy = this.provider.getStoreFactory().getPolicyStore().findById(JPAAuthorizationStoreFactory.NULL_REALM, resourceServer, id);
            if (!Objects.nonNull(policy)) continue;
            list.add(policy);
        }
        return list;
    }

    public List<Policy> findDependentPolicies(ResourceServer resourceServer, String policyId) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByDependentPolices", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("serverId", (Object)resourceServer.getId());
        query.setParameter("policyId", (Object)policyId);
        List result = query.getResultList();
        LinkedList<Policy> list = new LinkedList<Policy>();
        for (String id : result) {
            Policy policy = this.provider.getStoreFactory().getPolicyStore().findById(JPAAuthorizationStoreFactory.NULL_REALM, resourceServer, id);
            if (!Objects.nonNull(policy)) continue;
            list.add(policy);
        }
        return list;
    }
}

