/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import java.lang.reflect.Field;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.AssignableExpression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;
import org.jboss.byteman.rule.type.TypeGroup;

public class StaticExpression
extends AssignableExpression {
    private String ownerTypeName;
    private String fieldName;
    private Field field;
    private Type ownerType;
    private boolean isPublicField;
    private int fieldIndex;

    public StaticExpression(Rule rule, Type type, ParseNode token, String fieldName, String ownerTypeName) {
        super(rule, type, token);
        this.ownerTypeName = ownerTypeName;
        this.fieldName = fieldName;
        this.ownerType = null;
        this.fieldIndex = -1;
    }

    @Override
    public void bind() throws TypeException {
    }

    @Override
    public void bindAssign() throws TypeException {
        this.bind();
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        this.typeCheckAny(false);
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
            throw new TypeException("StaticExpression.typeCheck : invalid expected return type " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Type typeCheckAssign(Type expected) throws TypeException {
        this.typeCheckAny(true);
        if (Type.dereference(expected).isDefined() && !this.type.isAssignableFrom(expected)) {
            throw new TypeException("StaticExpression.typeCheck : invalid value type " + expected.getName() + " for static field assignment " + this.getPos());
        }
        return this.type;
    }

    public void typeCheckAny(boolean isAssign) throws TypeException {
        TypeGroup typeGroup = this.getTypeGroup();
        this.ownerType = Type.dereference(typeGroup.create(this.ownerTypeName));
        if (this.ownerType.isUndefined()) {
            throw new TypeException("StaticExpression.typeCheck : invalid path " + this.ownerTypeName + " to static field " + this.fieldName + this.getPos());
        }
        Class<?> clazz = this.ownerType.getTargetClass();
        try {
            this.field = this.lookupField(clazz, isAssign);
        }
        catch (NoSuchFieldException e) {
            throw new TypeException("StaticExpression.typeCheck : invalid field name " + this.fieldName + this.getPos());
        }
        if ((this.field.getModifiers() & 8) == 0) {
            throw new TypeException("StaticExpression.typeCheck : field is not static " + this.fieldName + this.getPos());
        }
        clazz = this.field.getType();
        this.type = typeGroup.ensureType(clazz);
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        try {
            if (this.isPublicField) {
                return this.field.get(null);
            }
            return this.rule.getAccessibleField(null, this.fieldIndex);
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new ExecuteException("StaticExpression.interpret : error accessing field " + this.ownerTypeName + "." + this.fieldName + this.getPos(), e);
        }
        catch (Exception e) {
            throw new ExecuteException("StaticExpression.interpret : unexpected exception accessing field " + this.ownerTypeName + "." + this.fieldName + this.getPos(), e);
        }
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        int currentStack = compileContext.getStackCount();
        if (this.isPublicField) {
            String ownerType = Type.internalName(this.field.getDeclaringClass());
            String fieldName = this.field.getName();
            String fieldType = Type.internalName(this.field.getType(), true);
            mv.visitFieldInsn(178, ownerType, fieldName, fieldType);
            int expected = this.type.getNBytes() > 4 ? 2 : 1;
            compileContext.addStackCount(expected);
        } else {
            mv.visitVarInsn(25, 0);
            mv.visitInsn(1);
            mv.visitLdcInsn(this.fieldIndex);
            compileContext.addStackCount(3);
            mv.visitMethodInsn(185, Type.internalName(HelperAdapter.class), "getAccessibleField", "(Ljava/lang/Object;I)Ljava/lang/Object;");
            compileContext.addStackCount(-2);
            if (!this.rule.requiresAccess(this.type)) {
                compileContext.compileTypeConversion(Type.OBJECT, this.type);
            }
        }
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        stringWriter.write(this.ownerTypeName);
        stringWriter.write(".");
        stringWriter.write(this.fieldName);
    }

    @Override
    public Object interpretAssign(HelperAdapter helperAdapter, Object value) throws ExecuteException {
        try {
            if (this.isPublicField) {
                this.field.set(null, value);
            } else {
                this.rule.setAccessibleField(null, value, this.fieldIndex);
            }
            return value;
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new ExecuteException("StaticExpression.interpretAssign : error accessing field " + this.ownerTypeName + "." + this.fieldName + this.getPos(), e);
        }
        catch (IllegalArgumentException e) {
            throw new ExecuteException("StaticExpression.interpretAssign : invalid value assigning field " + this.ownerTypeName + "." + this.fieldName + this.getPos(), e);
        }
        catch (Exception e) {
            throw new ExecuteException("StaticExpression.interpretAssign : unexpected exception accessing field " + this.ownerTypeName + "." + this.fieldName + this.getPos(), e);
        }
    }

    @Override
    public void compileAssign(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        int size;
        compileContext.notifySourceLine(this.line);
        int currentStack = compileContext.getStackCount();
        int n = size = this.type.getNBytes() > 4 ? 2 : 1;
        if (size == 1) {
            mv.visitInsn(89);
        } else {
            mv.visitInsn(92);
        }
        compileContext.addStackCount(size);
        if (this.isPublicField) {
            String ownerType = Type.internalName(this.field.getDeclaringClass());
            String fieldName = this.field.getName();
            String fieldType = Type.internalName(this.field.getType(), true);
            compileContext.addStackCount(-size);
            mv.visitFieldInsn(179, ownerType, fieldName, fieldType);
        } else {
            if (this.type.isPrimitive()) {
                compileContext.compileBox(Type.boxType(this.type));
            }
            mv.visitVarInsn(25, 0);
            mv.visitInsn(95);
            mv.visitInsn(1);
            mv.visitInsn(95);
            mv.visitLdcInsn(this.fieldIndex);
            compileContext.addStackCount(3);
            mv.visitMethodInsn(185, Type.internalName(HelperAdapter.class), "setAccessibleField", "(Ljava/lang/Object;Ljava/lang/Object;I)V");
            compileContext.addStackCount(-4);
        }
        if (compileContext.getStackCount() != currentStack) {
            throw new CompileException("StaticExpression.compileAssign : invalid stack height " + compileContext.getStackCount() + " expecting " + currentStack);
        }
    }

    private Field lookupField(Class<?> ownerClazz, boolean isAssign) throws NoSuchFieldException {
        try {
            Field field = ownerClazz.getField(this.fieldName);
            if (!this.rule.requiresAccess(field)) {
                this.isPublicField = true;
                return field;
            }
            this.isPublicField = false;
            this.fieldIndex = isAssign ? this.rule.addAccessibleFieldSetter(field) : this.rule.addAccessibleFieldGetter(field);
            return field;
        }
        catch (NoSuchFieldException nsfe) {
            for (Class<?> nextClass = ownerClazz; nextClass != null; nextClass = nextClass.getSuperclass()) {
                try {
                    this.field = nextClass.getDeclaredField(this.fieldName);
                    this.isPublicField = false;
                    this.fieldIndex = isAssign ? this.rule.addAccessibleFieldSetter(this.field) : this.rule.addAccessibleFieldGetter(this.field);
                    return this.field;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            throw nsfe;
        }
    }
}

