/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.graalvm.internal;

import antlr.CommonToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.hibernate.hql.internal.ast.HqlToken;
import org.hibernate.hql.internal.ast.tree.AggregateNode;
import org.hibernate.hql.internal.ast.tree.BetweenOperatorNode;
import org.hibernate.hql.internal.ast.tree.BinaryArithmeticOperatorNode;
import org.hibernate.hql.internal.ast.tree.BinaryLogicOperatorNode;
import org.hibernate.hql.internal.ast.tree.BooleanLiteralNode;
import org.hibernate.hql.internal.ast.tree.CastFunctionNode;
import org.hibernate.hql.internal.ast.tree.CollectionFunction;
import org.hibernate.hql.internal.ast.tree.ComponentJoin;
import org.hibernate.hql.internal.ast.tree.ConstructorNode;
import org.hibernate.hql.internal.ast.tree.CountNode;
import org.hibernate.hql.internal.ast.tree.DeleteStatement;
import org.hibernate.hql.internal.ast.tree.DotNode;
import org.hibernate.hql.internal.ast.tree.EntityJoinFromElement;
import org.hibernate.hql.internal.ast.tree.FromClause;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.HqlSqlWalkerNode;
import org.hibernate.hql.internal.ast.tree.IdentNode;
import org.hibernate.hql.internal.ast.tree.ImpliedFromElement;
import org.hibernate.hql.internal.ast.tree.InLogicOperatorNode;
import org.hibernate.hql.internal.ast.tree.IndexNode;
import org.hibernate.hql.internal.ast.tree.InsertStatement;
import org.hibernate.hql.internal.ast.tree.IntoClause;
import org.hibernate.hql.internal.ast.tree.IsNotNullLogicOperatorNode;
import org.hibernate.hql.internal.ast.tree.IsNullLogicOperatorNode;
import org.hibernate.hql.internal.ast.tree.JavaConstantNode;
import org.hibernate.hql.internal.ast.tree.LiteralNode;
import org.hibernate.hql.internal.ast.tree.MapEntryNode;
import org.hibernate.hql.internal.ast.tree.MapKeyEntityFromElement;
import org.hibernate.hql.internal.ast.tree.MapKeyNode;
import org.hibernate.hql.internal.ast.tree.MapValueNode;
import org.hibernate.hql.internal.ast.tree.MethodNode;
import org.hibernate.hql.internal.ast.tree.Node;
import org.hibernate.hql.internal.ast.tree.NullNode;
import org.hibernate.hql.internal.ast.tree.OrderByClause;
import org.hibernate.hql.internal.ast.tree.ParameterNode;
import org.hibernate.hql.internal.ast.tree.QueryNode;
import org.hibernate.hql.internal.ast.tree.ResultVariableRefNode;
import org.hibernate.hql.internal.ast.tree.SearchedCaseNode;
import org.hibernate.hql.internal.ast.tree.SelectClause;
import org.hibernate.hql.internal.ast.tree.SelectExpressionImpl;
import org.hibernate.hql.internal.ast.tree.SimpleCaseNode;
import org.hibernate.hql.internal.ast.tree.SqlFragment;
import org.hibernate.hql.internal.ast.tree.SqlNode;
import org.hibernate.hql.internal.ast.tree.UnaryArithmeticNode;
import org.hibernate.hql.internal.ast.tree.UnaryLogicOperatorNode;
import org.hibernate.hql.internal.ast.tree.UpdateStatement;
import org.hibernate.internal.build.AllowSysOut;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.sql.ordering.antlr.CollationSpecification;
import org.hibernate.sql.ordering.antlr.NodeSupport;
import org.hibernate.sql.ordering.antlr.OrderByFragment;
import org.hibernate.sql.ordering.antlr.OrderingSpecification;
import org.hibernate.sql.ordering.antlr.SortKey;
import org.hibernate.sql.ordering.antlr.SortSpecification;

public final class QueryParsingSupport
implements Feature {
    private final AtomicBoolean triggered = new AtomicBoolean(false);
    private static final boolean log = Boolean.getBoolean("org.hibernate.graalvm.diagnostics");

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class lexerClazz = access.findClassByName("org.hibernate.hql.internal.ast.HqlLexer");
        Class parserClazz = access.findClassByName("org.hibernate.hql.internal.ast.HqlParser");
        access.registerReachabilityHandler(this::enableHQLSupport, new Object[]{lexerClazz});
        access.registerReachabilityHandler(this::enableHQLSupport, new Object[]{parserClazz});
    }

    public String getDescription() {
        return "Hibernate ORM's support for HQL Parser in GraalVM";
    }

    @AllowSysOut
    private void enableHQLSupport(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        boolean needsEnablingYet = this.triggered.compareAndSet(false, true);
        if (needsEnablingYet) {
            if (log) {
                System.out.println("Hibernate ORM 's automatic feature for GraalVM native images: enabling support for HQL query parsing");
            }
            this.enableAntlrParsersSupport();
        }
    }

    private void enableAntlrParsersSupport() {
        Class[] needsHavingSimpleConstructors = QueryParsingSupport.typesNeedingDefaultConstructorAccessible();
        Class[] neddingAllConstructorsAccessible = QueryParsingSupport.typesNeedingAllConstructorsAccessible();
        ArrayList executables = new ArrayList(needsHavingSimpleConstructors.length + neddingAllConstructorsAccessible.length * 3);
        for (Class c : needsHavingSimpleConstructors) {
            executables.add(ReflectHelper.getDefaultConstructor((Class)c));
        }
        for (Class c : neddingAllConstructorsAccessible) {
            for (Constructor<?> declaredConstructor : c.getDeclaredConstructors()) {
                executables.add(declaredConstructor);
            }
        }
        RuntimeReflection.register((Class[])needsHavingSimpleConstructors);
        RuntimeReflection.register((Class[])neddingAllConstructorsAccessible);
        RuntimeReflection.register((Executable[])executables.toArray(new Executable[0]));
    }

    public static Class[] typesNeedingAllConstructorsAccessible() {
        return new Class[]{EntityJoinFromElement.class, MapKeyEntityFromElement.class, ComponentJoin.class};
    }

    public static Class[] typesNeedingDefaultConstructorAccessible() {
        return new Class[]{NodeSupport.class, OrderByFragment.class, SortSpecification.class, OrderingSpecification.class, CollationSpecification.class, SortKey.class, CommonToken.class, SelectClause.class, HqlSqlWalkerNode.class, MethodNode.class, UnaryLogicOperatorNode.class, NullNode.class, IntoClause.class, UpdateStatement.class, SelectExpressionImpl.class, CastFunctionNode.class, DeleteStatement.class, SqlNode.class, SearchedCaseNode.class, FromElement.class, JavaConstantNode.class, SqlFragment.class, MapKeyNode.class, ImpliedFromElement.class, IsNotNullLogicOperatorNode.class, InsertStatement.class, UnaryArithmeticNode.class, CollectionFunction.class, BinaryLogicOperatorNode.class, CountNode.class, IsNullLogicOperatorNode.class, IdentNode.class, ParameterNode.class, MapEntryNode.class, MapValueNode.class, InLogicOperatorNode.class, IndexNode.class, DotNode.class, ResultVariableRefNode.class, BetweenOperatorNode.class, AggregateNode.class, QueryNode.class, BooleanLiteralNode.class, SimpleCaseNode.class, OrderByClause.class, FromClause.class, ConstructorNode.class, LiteralNode.class, BinaryArithmeticOperatorNode.class, HqlToken.class, Node.class};
    }
}

