/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;

public final class Gizmo {
    public static final int ASM_API_VERSION = 589824;
    public static final MethodDescriptor TO_STRING = MethodDescriptor.ofMethod(Object.class, "toString", String.class, new Class[0]);
    public static final MethodDescriptor EQUALS = MethodDescriptor.ofMethod(Object.class, "equals", Boolean.TYPE, Object.class);
    public static final MethodDescriptor PRINTLN = MethodDescriptor.ofMethod(PrintStream.class, "println", Void.TYPE, String.class);
    public static final FieldDescriptor SYSTEM_OUT = FieldDescriptor.of(System.class, "out", PrintStream.class);
    public static final FieldDescriptor SYSTEM_ERR = FieldDescriptor.of(System.class, "err", PrintStream.class);

    private Gizmo() {
    }

    public static ResultHandle toString(BytecodeCreator target, ResultHandle obj) {
        return target.invokeVirtualMethod(TO_STRING, obj, new ResultHandle[0]);
    }

    public static ResultHandle equals(BytecodeCreator target, ResultHandle obj1, ResultHandle obj2) {
        return target.invokeVirtualMethod(EQUALS, obj1, obj2);
    }

    public static void systemOutPrintln(BytecodeCreator target, ResultHandle obj) {
        target.invokeVirtualMethod(PRINTLN, target.readStaticField(SYSTEM_OUT), obj);
    }

    public static void systemErrPrintln(BytecodeCreator target, ResultHandle obj) {
        target.invokeVirtualMethod(PRINTLN, target.readStaticField(SYSTEM_ERR), obj);
    }

    public static JdkList listOperations(BytecodeCreator target) {
        return new JdkList(target);
    }

    public static JdkCollection collectionOperations(BytecodeCreator target) {
        return new JdkCollection(target);
    }

    public static JdkSet setOperations(BytecodeCreator target) {
        return new JdkSet(target);
    }

    public static JdkOptional optionalOperations(BytecodeCreator target) {
        return new JdkOptional(target);
    }

    public static JdkIterable iterableOperations(BytecodeCreator target) {
        return new JdkIterable(target);
    }

    public static JdkIterator iteratorOperations(BytecodeCreator target) {
        return new JdkIterator(target);
    }

    public static JdkMap mapOperations(BytecodeCreator target) {
        return new JdkMap(target);
    }

    public static ResultHandle newHashMap(BytecodeCreator target) {
        return target.newInstance(MethodDescriptor.ofConstructor(HashMap.class, new Class[0]), new ResultHandle[0]);
    }

    public static ResultHandle newHashSet(BytecodeCreator target) {
        return target.newInstance(MethodDescriptor.ofConstructor(HashSet.class, new Class[0]), new ResultHandle[0]);
    }

    public static ResultHandle newArrayList(BytecodeCreator target) {
        return target.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, new Class[0]), new ResultHandle[0]);
    }

    public static ResultHandle newArrayList(BytecodeCreator target, int initialCapacity) {
        return target.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, Integer.TYPE), target.load(initialCapacity));
    }

    public static class JdkMap
    extends StaticInvocationGenerator {
        public static final MethodDescriptor GET = MethodDescriptor.ofMethod(Map.class, "get", Object.class, Object.class);
        public static final MethodDescriptor PUT = MethodDescriptor.ofMethod(Map.class, "put", Object.class, Object.class, Object.class);
        public static final MethodDescriptor OF1 = MethodDescriptor.ofMethod(Map.class, "of", Map.class, Object.class, Object.class);
        public static final MethodDescriptor SIZE = MethodDescriptor.ofMethod(Map.class, "size", Integer.TYPE, new Class[0]);
        public static final MethodDescriptor IS_EMPTY = MethodDescriptor.ofMethod(Map.class, "isEmpty", Boolean.TYPE, new Class[0]);
        public static final MethodDescriptor CONTAINS_KEY = MethodDescriptor.ofMethod(Map.class, "containsKey", Boolean.TYPE, Object.class);

        public JdkMap(BytecodeCreator target) {
            super(target);
        }

        public JdkMapInstance instance(ResultHandle list) {
            return new JdkMapInstance(list);
        }

        public ResultHandle of(ResultHandle k1, ResultHandle v1) {
            return this.target.invokeStaticInterfaceMethod(OF1, k1, v1);
        }

        public class JdkMapInstance
        extends InstanceInvocationGenerator {
            JdkMapInstance(ResultHandle instance) {
                super(instance);
            }

            public ResultHandle get(ResultHandle key) {
                return JdkMap.this.target.invokeInterfaceMethod(GET, this.instance, key);
            }

            public ResultHandle put(ResultHandle key, ResultHandle val) {
                return JdkMap.this.target.invokeInterfaceMethod(PUT, this.instance, key, val);
            }

            public ResultHandle size() {
                return JdkMap.this.target.invokeInterfaceMethod(SIZE, this.instance, new ResultHandle[0]);
            }

            public ResultHandle isEmpty() {
                return JdkMap.this.target.invokeInterfaceMethod(IS_EMPTY, this.instance, new ResultHandle[0]);
            }

            public ResultHandle containsKey(ResultHandle key) {
                return JdkMap.this.target.invokeInterfaceMethod(CONTAINS_KEY, this.instance, key);
            }
        }
    }

    public static class JdkSet
    extends JdkCollection {
        public static final MethodDescriptor OF1 = MethodDescriptor.ofMethod(Set.class, "of", Set.class, Object.class);
        public static final MethodDescriptor OF2 = MethodDescriptor.ofMethod(Set.class, "of", Set.class, Object.class, Object.class);
        public static final MethodDescriptor OF3 = MethodDescriptor.ofMethod(Set.class, "of", Set.class, Object.class, Object.class, Object.class);

        public JdkSet(BytecodeCreator target) {
            super(target);
        }

        @Override
        public JdkSetInstance on(ResultHandle list) {
            return new JdkSetInstance(list);
        }

        public ResultHandle of(ResultHandle e1) {
            return this.target.invokeStaticInterfaceMethod(OF1, e1);
        }

        public ResultHandle of(ResultHandle e1, ResultHandle e2) {
            return this.target.invokeStaticInterfaceMethod(OF2, e1, e2);
        }

        public ResultHandle of(ResultHandle e1, ResultHandle e2, ResultHandle e3) {
            return this.target.invokeStaticInterfaceMethod(OF3, e1, e2, e3);
        }

        public class JdkSetInstance
        extends JdkCollection.JdkCollectionInstance {
            JdkSetInstance(ResultHandle instance) {
                super(instance);
            }
        }
    }

    public static class JdkList
    extends JdkCollection {
        public static final MethodDescriptor GET = MethodDescriptor.ofMethod(List.class, "get", Object.class, Integer.TYPE);
        public static final MethodDescriptor OF1 = MethodDescriptor.ofMethod(List.class, "of", List.class, Object.class);
        public static final MethodDescriptor OF2 = MethodDescriptor.ofMethod(List.class, "of", List.class, Object.class, Object.class);
        public static final MethodDescriptor OF3 = MethodDescriptor.ofMethod(List.class, "of", List.class, Object.class, Object.class, Object.class);

        public JdkList(BytecodeCreator target) {
            super(target);
        }

        @Override
        public JdkListInstance on(ResultHandle list) {
            return new JdkListInstance(list);
        }

        public ResultHandle of(ResultHandle e1) {
            return this.target.invokeStaticInterfaceMethod(OF1, e1);
        }

        public ResultHandle of(ResultHandle e1, ResultHandle e2) {
            return this.target.invokeStaticInterfaceMethod(OF2, e1, e2);
        }

        public ResultHandle of(ResultHandle e1, ResultHandle e2, ResultHandle e3) {
            return this.target.invokeStaticInterfaceMethod(OF3, e1, e2, e3);
        }

        public class JdkListInstance
        extends JdkCollection.JdkCollectionInstance {
            JdkListInstance(ResultHandle instance) {
                super(instance);
            }

            public ResultHandle get(int index) {
                return this.get(JdkList.this.target.load(index));
            }

            public ResultHandle get(ResultHandle index) {
                return JdkList.this.target.invokeInterfaceMethod(GET, this.instance, index);
            }
        }
    }

    public static class JdkCollection
    extends JdkIterable {
        public static final MethodDescriptor SIZE = MethodDescriptor.ofMethod(Collection.class, "size", Integer.TYPE, new Class[0]);
        public static final MethodDescriptor IS_EMPTY = MethodDescriptor.ofMethod(Collection.class, "isEmpty", Boolean.TYPE, new Class[0]);
        public static final MethodDescriptor CONTAINS = MethodDescriptor.ofMethod(Collection.class, "contains", Boolean.TYPE, Object.class);
        public static final MethodDescriptor ADD = MethodDescriptor.ofMethod(Collection.class, "add", Boolean.TYPE, Object.class);
        public static final MethodDescriptor ADD_ALL = MethodDescriptor.ofMethod(Collection.class, "addAll", Boolean.TYPE, Collection.class);
        public static final MethodDescriptor CLEAR = MethodDescriptor.ofMethod(Collection.class, "clear", Void.TYPE, new Class[0]);

        public JdkCollection(BytecodeCreator target) {
            super(target);
        }

        @Override
        public JdkCollectionInstance on(ResultHandle list) {
            return new JdkCollectionInstance(list);
        }

        public class JdkCollectionInstance
        extends JdkIterable.JdkIterableInstance {
            JdkCollectionInstance(ResultHandle instance) {
                super(instance);
            }

            public ResultHandle size() {
                return JdkCollection.this.target.invokeInterfaceMethod(SIZE, this.instance, new ResultHandle[0]);
            }

            public ResultHandle isEmpty() {
                return JdkCollection.this.target.invokeInterfaceMethod(IS_EMPTY, this.instance, new ResultHandle[0]);
            }

            public ResultHandle contains(ResultHandle obj) {
                return JdkCollection.this.target.invokeInterfaceMethod(CONTAINS, this.instance, obj);
            }

            public ResultHandle add(ResultHandle element) {
                return JdkCollection.this.target.invokeInterfaceMethod(ADD, this.instance, element);
            }

            public ResultHandle addAll(ResultHandle collection) {
                return JdkCollection.this.target.invokeInterfaceMethod(ADD_ALL, this.instance, collection);
            }

            public void clear() {
                JdkCollection.this.target.invokeInterfaceMethod(CLEAR, this.instance, new ResultHandle[0]);
            }
        }
    }

    public static class JdkIterator
    extends StaticInvocationGenerator {
        public static final MethodDescriptor NEXT = MethodDescriptor.ofMethod(Iterator.class, "next", Object.class, new Class[0]);
        public static final MethodDescriptor HAS_NEXT = MethodDescriptor.ofMethod(Iterator.class, "hasNext", Boolean.TYPE, new Class[0]);

        public JdkIterator(BytecodeCreator target) {
            super(target);
        }

        public JdkIteratorInstance on(ResultHandle iterable) {
            return new JdkIteratorInstance(iterable);
        }

        public class JdkIteratorInstance
        extends InstanceInvocationGenerator {
            JdkIteratorInstance(ResultHandle instance) {
                super(instance);
            }

            public ResultHandle next() {
                return JdkIterator.this.target.invokeInterfaceMethod(NEXT, this.instance, new ResultHandle[0]);
            }

            public ResultHandle hasNext() {
                return JdkIterator.this.target.invokeInterfaceMethod(HAS_NEXT, this.instance, new ResultHandle[0]);
            }
        }
    }

    public static class JdkIterable
    extends StaticInvocationGenerator {
        public static final MethodDescriptor ITERATOR = MethodDescriptor.ofMethod(Iterable.class, "iterator", Iterator.class, new Class[0]);

        public JdkIterable(BytecodeCreator target) {
            super(target);
        }

        public JdkIterableInstance on(ResultHandle iterable) {
            return new JdkIterableInstance(iterable);
        }

        public class JdkIterableInstance
        extends InstanceInvocationGenerator {
            JdkIterableInstance(ResultHandle instance) {
                super(instance);
            }

            public ResultHandle iterator() {
                return JdkIterable.this.target.invokeInterfaceMethod(ITERATOR, this.instance, new ResultHandle[0]);
            }
        }
    }

    public static class JdkOptional
    extends StaticInvocationGenerator {
        public static final MethodDescriptor OF = MethodDescriptor.ofMethod(Optional.class, "of", Optional.class, Object.class);
        public static final MethodDescriptor OF_NULLABLE = MethodDescriptor.ofMethod(Optional.class, "ofNullable", Optional.class, Object.class);
        public static final MethodDescriptor GET = MethodDescriptor.ofMethod(Optional.class, "get", Object.class, new Class[0]);
        public static final MethodDescriptor IS_PRESENT = MethodDescriptor.ofMethod(Optional.class, "isPresent", Boolean.TYPE, new Class[0]);
        public static final MethodDescriptor IS_EMPTY = MethodDescriptor.ofMethod(Optional.class, "isEmpty", Boolean.TYPE, new Class[0]);

        public JdkOptional(BytecodeCreator target) {
            super(target);
        }

        public JdkOptionalInstance on(ResultHandle list) {
            return new JdkOptionalInstance(list);
        }

        public ResultHandle of(ResultHandle value) {
            return this.target.invokeStaticMethod(OF, value);
        }

        public ResultHandle ofNullable(ResultHandle value) {
            return this.target.invokeStaticMethod(OF_NULLABLE, value);
        }

        public class JdkOptionalInstance
        extends InstanceInvocationGenerator {
            JdkOptionalInstance(ResultHandle instance) {
                super(instance);
            }

            public ResultHandle isPresent() {
                return JdkOptional.this.target.invokeVirtualMethod(IS_PRESENT, this.instance, new ResultHandle[0]);
            }

            public ResultHandle isEmpty() {
                return JdkOptional.this.target.invokeVirtualMethod(IS_EMPTY, this.instance, new ResultHandle[0]);
            }

            public ResultHandle get() {
                return JdkOptional.this.target.invokeVirtualMethod(GET, this.instance, new ResultHandle[0]);
            }
        }
    }

    public static class CustomInvocationGenerator
    extends StaticInvocationGenerator {
        private final BiFunction<BytecodeCreator, ResultHandle[], ResultHandle> fun;

        public CustomInvocationGenerator(BytecodeCreator target, BiFunction<BytecodeCreator, ResultHandle[], ResultHandle> fun) {
            super(target);
            this.fun = fun;
        }

        public ResultHandle invoke(ResultHandle ... args) {
            return this.fun.apply(this.target, args);
        }
    }

    public static abstract class InstanceInvocationGenerator {
        protected final ResultHandle instance;

        InstanceInvocationGenerator(ResultHandle instance) {
            this.instance = Objects.requireNonNull(instance);
        }
    }

    public static abstract class StaticInvocationGenerator {
        protected BytecodeCreator target;

        StaticInvocationGenerator(BytecodeCreator target) {
            this.setTarget(target);
        }

        void setTarget(BytecodeCreator target) {
            this.target = Objects.requireNonNull(target);
        }
    }
}

