/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DecoratorInfo;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.StereotypeInfo;
import java.util.Collection;
import java.util.Map;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public interface BuildExtension {
    public static final int DEFAULT_PRIORITY = 1000;

    public static int compare(BuildExtension e1, BuildExtension e2) {
        return Integer.compare(e2.getPriority(), e1.getPriority());
    }

    default public int getPriority() {
        return 1000;
    }

    default public boolean initialize(BuildContext buildContext) {
        return true;
    }

    public static class SimpleKey<V>
    implements Key<V> {
        private final String str;

        static <V> SimpleKey<V> simpleBuiltIn(String val) {
            return new SimpleKey<V>(BUILT_IN_PREFIX + val);
        }

        public SimpleKey(String str) {
            this.str = str;
        }

        @Override
        public String asString() {
            return this.str;
        }
    }

    public static interface Key<T> {
        public static final String BUILT_IN_PREFIX = BuildExtension.class.getPackage().getName() + ".";
        public static final Key<IndexView> INDEX = SimpleKey.simpleBuiltIn("index");
        public static final Key<Collection<InjectionPointInfo>> INJECTION_POINTS = SimpleKey.simpleBuiltIn("injectionPoints");
        public static final Key<Collection<BeanInfo>> BEANS = SimpleKey.simpleBuiltIn("beans");
        public static final Key<Collection<BeanInfo>> REMOVED_BEANS = SimpleKey.simpleBuiltIn("removedBeans");
        public static final Key<Collection<ObserverInfo>> OBSERVERS = SimpleKey.simpleBuiltIn("observers");
        public static final Key<Collection<InterceptorInfo>> INTERCEPTORS = SimpleKey.simpleBuiltIn("interceptors");
        public static final Key<Collection<InterceptorInfo>> REMOVED_INTERCEPTORS = SimpleKey.simpleBuiltIn("removedInterceptors");
        public static final Key<Collection<DecoratorInfo>> DECORATORS = SimpleKey.simpleBuiltIn("decorators");
        public static final Key<Collection<DecoratorInfo>> REMOVED_DECORATORS = SimpleKey.simpleBuiltIn("removedDecorators");
        public static final Key<AnnotationStore> ANNOTATION_STORE = SimpleKey.simpleBuiltIn("annotationStore");
        public static final Key<Collection<ScopeInfo>> SCOPES = SimpleKey.simpleBuiltIn("scopes");
        public static final Key<Map<DotName, ClassInfo>> QUALIFIERS = SimpleKey.simpleBuiltIn("qualifiers");
        public static final Key<Map<DotName, ClassInfo>> INTERCEPTOR_BINDINGS = SimpleKey.simpleBuiltIn("interceptorBindings");
        public static final Key<Map<DotName, StereotypeInfo>> STEREOTYPES = SimpleKey.simpleBuiltIn("stereotypes");
        public static final Key<BeanDeployment> DEPLOYMENT = SimpleKey.simpleBuiltIn("deployment");

        public String asString();
    }

    public static interface BuildContext {
        public <V> V get(Key<V> var1);

        public <V> V put(Key<V> var1, V var2);
    }
}

