/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleTriggerAdapter;
import org.jboss.byteman.agent.adapter.RuleTriggerMethodAdapter;
import org.jboss.byteman.objectweb.asm.ClassVisitor;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.objectweb.asm.Type;
import org.jboss.byteman.rule.type.TypeHelper;

public class NewArrayTriggerAdapter
extends RuleTriggerAdapter {
    protected String typeName;
    protected int count;
    protected int dims;
    protected boolean whenComplete;

    public NewArrayTriggerAdapter(ClassVisitor cv, TransformContext transformContext, String typeName, int count, int dims, boolean whenComplete) {
        super(cv, transformContext);
        this.typeName = typeName;
        this.count = count;
        this.dims = dims;
        this.whenComplete = whenComplete;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.injectIntoMethod(name, desc)) {
            if (name.equals("<init>")) {
                return new NewArrayTriggerConstructorAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
            }
            return new NewArrayTriggerMethodAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class NewArrayTriggerConstructorAdapter
    extends NewArrayTriggerMethodAdapter {
        NewArrayTriggerConstructorAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor, signature, exceptions);
            this.latched = true;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            if (this.latched && NewArrayTriggerAdapter.this.isSuperOrSiblingConstructorCall(opcode, owner, name)) {
                this.latched = false;
            }
        }
    }

    private class NewArrayTriggerMethodAdapter
    extends RuleTriggerMethodAdapter {
        protected boolean latched;
        private int visitedCount;
        private String matchedBaseName;

        NewArrayTriggerMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor, signature, exceptions);
            this.visitedCount = 0;
            this.latched = false;
            this.matchedBaseName = null;
        }

        @Override
        public String getNewClassName() {
            StringBuilder builder = new StringBuilder(this.matchedBaseName);
            for (int i = 0; i < NewArrayTriggerAdapter.this.dims; ++i) {
                builder.append("[]");
            }
            return builder.toString();
        }

        @Override
        public void visitTypeInsn(int opcode, String type) {
            boolean triggerReady = false;
            int elementDims = TypeHelper.dimCount(type);
            if (!this.inBytemanTrigger() && opcode == 189 && (NewArrayTriggerAdapter.this.count == 0 || this.visitedCount < NewArrayTriggerAdapter.this.count) && NewArrayTriggerAdapter.this.dims == elementDims + 1 && this.matchType(type)) {
                ++this.visitedCount;
                if (NewArrayTriggerAdapter.this.count == 0 || this.visitedCount == NewArrayTriggerAdapter.this.count) {
                    if (NewArrayTriggerAdapter.this.whenComplete) {
                        triggerReady = true;
                    } else {
                        this.injectTriggerPoint();
                    }
                }
            }
            super.visitTypeInsn(opcode, type);
            if (triggerReady) {
                this.injectTriggerPoint();
            }
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
            boolean triggerReady = false;
            if (opcode == 188 && NewArrayTriggerAdapter.this.dims == 1 && (NewArrayTriggerAdapter.this.count == 0 || this.visitedCount < NewArrayTriggerAdapter.this.count) && this.matchType(operand)) {
                ++this.visitedCount;
                if (NewArrayTriggerAdapter.this.count == 0 || this.visitedCount == NewArrayTriggerAdapter.this.count) {
                    if (NewArrayTriggerAdapter.this.whenComplete) {
                        triggerReady = true;
                    } else {
                        this.injectTriggerPoint();
                    }
                }
            }
            super.visitIntInsn(opcode, operand);
            if (triggerReady) {
                this.injectTriggerPoint();
            }
        }

        @Override
        public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
            boolean triggerReady = false;
            int totalDims = TypeHelper.dimCount(descriptor);
            if (NewArrayTriggerAdapter.this.dims == totalDims && (NewArrayTriggerAdapter.this.count == 0 || this.visitedCount < NewArrayTriggerAdapter.this.count) && this.matchType(descriptor)) {
                ++this.visitedCount;
                if (NewArrayTriggerAdapter.this.count == 0 || this.visitedCount == NewArrayTriggerAdapter.this.count) {
                    if (NewArrayTriggerAdapter.this.whenComplete) {
                        triggerReady = true;
                    } else {
                        this.injectTriggerPoint();
                    }
                }
            }
            super.visitMultiANewArrayInsn(descriptor, numDimensions);
            if (triggerReady) {
                this.injectTriggerPoint();
            }
        }

        private boolean matchType(int operand) {
            String baseName = null;
            switch (operand) {
                case 4: {
                    baseName = "boolean";
                    break;
                }
                case 8: {
                    baseName = "byte";
                    break;
                }
                case 5: {
                    baseName = "char";
                    break;
                }
                case 9: {
                    baseName = "short";
                    break;
                }
                case 10: {
                    baseName = "int";
                    break;
                }
                case 11: {
                    baseName = "long";
                    break;
                }
                case 6: {
                    baseName = "float";
                    break;
                }
                case 7: {
                    baseName = "double";
                    break;
                }
            }
            if (NewArrayTriggerAdapter.this.typeName.length() == 0 || NewArrayTriggerAdapter.this.typeName.equals(baseName)) {
                this.matchedBaseName = baseName;
                return true;
            }
            return false;
        }

        private boolean matchType(String type) {
            String baseName = TypeHelper.internalizeClass(type, true);
            boolean matched = false;
            if (NewArrayTriggerAdapter.this.typeName.length() == 0) {
                matched = true;
            } else if (NewArrayTriggerAdapter.this.typeName.equals(baseName)) {
                matched = true;
            } else if (!NewArrayTriggerAdapter.this.typeName.contains(".") && baseName.contains(".")) {
                int tailIdx = baseName.lastIndexOf(".");
                matched = NewArrayTriggerAdapter.this.typeName.equals(baseName.substring(tailIdx + 1));
            }
            if (matched) {
                this.matchedBaseName = baseName;
            }
            return matched;
        }

        @Override
        public Type getReturnBindingType() {
            return Type.getObjectType(TypeHelper.externalizeType(this.getNewClassName()));
        }
    }
}

