/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.layer;

import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.byteman.layer.LayerModuleReader;
import org.jboss.byteman.layer.LayerModuleReference;

public class LayerModuleFinder
implements ModuleFinder {
    private final String moduleName;
    private ModuleReference reference;

    public LayerModuleFinder(String moduleName, String[] exportsNames, String[] requiresNames, Function<String, byte[]> classMapper) {
        URI uri = null;
        try {
            uri = new URI("byteman", moduleName, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        ModuleDescriptor.Builder builder = ModuleDescriptor.newModule(moduleName);
        for (String required : requiresNames) {
            builder.requires(required);
        }
        for (String exported : exportsNames) {
            builder.exports(exported);
        }
        ModuleDescriptor desc = builder.build();
        final LayerModuleReader reader = new LayerModuleReader(classMapper);
        LayerModuleReference reference = new LayerModuleReference(desc, uri, new Supplier<ModuleReader>(){

            @Override
            public ModuleReader get() {
                return reader;
            }
        });
        this.moduleName = moduleName;
        this.reference = reference;
    }

    @Override
    public Optional<ModuleReference> find(String name) {
        if (this.moduleName.equals(name)) {
            return Optional.of(this.reference);
        }
        return null;
    }

    @Override
    public Set<ModuleReference> findAll() {
        return Set.of(this.reference);
    }
}

