/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.realm.entity;

import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import jakarta.persistence.Version;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hibernate.annotations.Type;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UuidValidator;
import org.keycloak.models.map.realm.MapRealmEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationExecutionEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationFlowEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticatorConfigEntity;
import org.keycloak.models.map.realm.entity.MapClientInitialAccessEntity;
import org.keycloak.models.map.realm.entity.MapComponentEntity;
import org.keycloak.models.map.realm.entity.MapIdentityProviderEntity;
import org.keycloak.models.map.realm.entity.MapIdentityProviderMapperEntity;
import org.keycloak.models.map.realm.entity.MapOTPPolicyEntity;
import org.keycloak.models.map.realm.entity.MapRequiredActionProviderEntity;
import org.keycloak.models.map.realm.entity.MapRequiredCredentialEntity;
import org.keycloak.models.map.realm.entity.MapWebAuthnPolicyEntity;
import org.keycloak.models.map.storage.jpa.Constants;
import org.keycloak.models.map.storage.jpa.JpaAttributeEntity;
import org.keycloak.models.map.storage.jpa.JpaMapStorageProviderFactory;
import org.keycloak.models.map.storage.jpa.JpaRootVersionedEntity;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;
import org.keycloak.models.map.storage.jpa.realm.entity.JpaComponentEntity;
import org.keycloak.models.map.storage.jpa.realm.entity.JpaRealmAttributeEntity;
import org.keycloak.models.map.storage.jpa.realm.entity.JpaRealmMetadata;

@Entity
@Table(name="kc_realm", uniqueConstraints={@UniqueConstraint(columnNames={"name"})})
@EnhancementInfo(version="6.2.5.Final")
public class JpaRealmEntity
extends MapRealmEntity.AbstractRealmEntity
implements JpaRootVersionedEntity,
ManagedEntity,
PersistentAttributeInterceptable {
    @Id
    @Column
    UUID id;
    @Version
    @Column
    int version;
    @Type(value=JsonbType.class)
    @Column(columnDefinition="jsonb")
    JpaRealmMetadata metadata;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    Integer entityVersion;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    String name;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    String displayName;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    String displayNameHtml;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    Boolean enabled;
    @OneToMany(mappedBy="root", cascade={CascadeType.PERSIST}, orphanRemoval=true)
    Set<JpaRealmAttributeEntity> attributes = new HashSet<JpaRealmAttributeEntity>();
    @OneToMany(mappedBy="root", cascade={CascadeType.PERSIST}, orphanRemoval=true)
    Set<JpaComponentEntity> components = new HashSet<JpaComponentEntity>();
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;

    public JpaRealmEntity() {
        this.metadata = new JpaRealmMetadata();
    }

    public JpaRealmEntity(DeepCloner cloner) {
        this.metadata = new JpaRealmMetadata(cloner);
    }

    public JpaRealmEntity(UUID id, int version, Integer entityVersion, String name, String displayName, String displayNameHtml, Boolean enabled) {
        this.$$_hibernate_write_id(id);
        this.$$_hibernate_write_version(version);
        this.$$_hibernate_write_entityVersion(entityVersion);
        this.$$_hibernate_write_name(name);
        this.$$_hibernate_write_displayName(displayName);
        this.$$_hibernate_write_displayNameHtml(displayNameHtml);
        this.$$_hibernate_write_enabled(enabled);
        this.metadata = null;
    }

    public boolean isMetadataInitialized() {
        return this.$$_hibernate_read_metadata() != null;
    }

    @Override
    public Integer getEntityVersion() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getEntityVersion();
        }
        return this.$$_hibernate_read_entityVersion();
    }

    @Override
    public void setEntityVersion(Integer entityVersion) {
        this.$$_hibernate_read_metadata().setEntityVersion(entityVersion);
    }

    @Override
    public Integer getCurrentSchemaVersion() {
        return Constants.CURRENT_SCHEMA_VERSION_REALM;
    }

    @Override
    public int getVersion() {
        return this.$$_hibernate_read_version();
    }

    public String getId() {
        return this.$$_hibernate_read_id() == null ? null : this.$$_hibernate_read_id().toString();
    }

    public void setId(String id) {
        String validatedId = UuidValidator.validateAndConvert((String)id);
        this.$$_hibernate_write_id(UUID.fromString(validatedId));
    }

    public String getName() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getName();
        }
        return this.$$_hibernate_read_name();
    }

    public void setName(String name) {
        this.$$_hibernate_read_metadata().setName(name);
    }

    public String getDisplayName() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getDisplayName();
        }
        return this.$$_hibernate_read_displayName();
    }

    public void setDisplayName(String displayName) {
        this.$$_hibernate_read_metadata().setDisplayName(displayName);
    }

    public String getDisplayNameHtml() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getDisplayNameHtml();
        }
        return this.$$_hibernate_read_displayNameHtml();
    }

    public void setDisplayNameHtml(String displayNameHtml) {
        this.$$_hibernate_read_metadata().setDisplayNameHtml(displayNameHtml);
    }

    public Boolean isEnabled() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().isEnabled();
        }
        return this.$$_hibernate_read_enabled();
    }

    public void setEnabled(Boolean enabled) {
        this.$$_hibernate_read_metadata().setEnabled(enabled);
    }

    public Boolean isRegistrationAllowed() {
        return this.$$_hibernate_read_metadata().isRegistrationAllowed();
    }

    public void setRegistrationAllowed(Boolean registrationAllowed) {
        this.$$_hibernate_read_metadata().setRegistrationAllowed(registrationAllowed);
    }

    public Boolean isRegistrationEmailAsUsername() {
        return this.$$_hibernate_read_metadata().isRegistrationEmailAsUsername();
    }

    public void setRegistrationEmailAsUsername(Boolean registrationEmailAsUsername) {
        this.$$_hibernate_read_metadata().setRegistrationEmailAsUsername(registrationEmailAsUsername);
    }

    public Boolean isVerifyEmail() {
        return this.$$_hibernate_read_metadata().isVerifyEmail();
    }

    public void setVerifyEmail(Boolean verifyEmail) {
        this.$$_hibernate_read_metadata().setVerifyEmail(verifyEmail);
    }

    public Boolean isResetPasswordAllowed() {
        return this.$$_hibernate_read_metadata().isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(Boolean resetPasswordAllowed) {
        this.$$_hibernate_read_metadata().setResetPasswordAllowed(resetPasswordAllowed);
    }

    public Boolean isLoginWithEmailAllowed() {
        return this.$$_hibernate_read_metadata().isLoginWithEmailAllowed();
    }

    public void setLoginWithEmailAllowed(Boolean loginWithEmailAllowed) {
        this.$$_hibernate_read_metadata().setLoginWithEmailAllowed(loginWithEmailAllowed);
    }

    public Boolean isDuplicateEmailsAllowed() {
        return this.$$_hibernate_read_metadata().isDuplicateEmailsAllowed();
    }

    public void setDuplicateEmailsAllowed(Boolean duplicateEmailsAllowed) {
        this.$$_hibernate_read_metadata().setDuplicateEmailsAllowed(duplicateEmailsAllowed);
    }

    public Boolean isRememberMe() {
        return this.$$_hibernate_read_metadata().isRememberMe();
    }

    public void setRememberMe(Boolean rememberMe) {
        this.$$_hibernate_read_metadata().setRememberMe(rememberMe);
    }

    public Boolean isEditUsernameAllowed() {
        return this.$$_hibernate_read_metadata().isEditUsernameAllowed();
    }

    public void setEditUsernameAllowed(Boolean editUsernameAllowed) {
        this.$$_hibernate_read_metadata().setEditUsernameAllowed(editUsernameAllowed);
    }

    public Boolean isRevokeRefreshToken() {
        return this.$$_hibernate_read_metadata().isRevokeRefreshToken();
    }

    public void setRevokeRefreshToken(Boolean revokeRefreshToken) {
        this.$$_hibernate_read_metadata().setRevokeRefreshToken(revokeRefreshToken);
    }

    public Boolean isAdminEventsEnabled() {
        return this.$$_hibernate_read_metadata().isAdminEventsEnabled();
    }

    public void setAdminEventsEnabled(Boolean adminEventsEnabled) {
        this.$$_hibernate_read_metadata().setAdminEventsEnabled(adminEventsEnabled);
    }

    public Boolean isAdminEventsDetailsEnabled() {
        return this.$$_hibernate_read_metadata().isAdminEventsDetailsEnabled();
    }

    public void setAdminEventsDetailsEnabled(Boolean adminEventsDetailsEnabled) {
        this.$$_hibernate_read_metadata().setAdminEventsDetailsEnabled(adminEventsDetailsEnabled);
    }

    public Boolean isInternationalizationEnabled() {
        return this.$$_hibernate_read_metadata().isInternationalizationEnabled();
    }

    public void setInternationalizationEnabled(Boolean internationalizationEnabled) {
        this.$$_hibernate_read_metadata().setInternationalizationEnabled(internationalizationEnabled);
    }

    public Boolean isAllowUserManagedAccess() {
        return this.$$_hibernate_read_metadata().isAllowUserManagedAccess();
    }

    public void setAllowUserManagedAccess(Boolean allowUserManagedAccess) {
        this.$$_hibernate_read_metadata().setAllowUserManagedAccess(allowUserManagedAccess);
    }

    public Boolean isOfflineSessionMaxLifespanEnabled() {
        return this.$$_hibernate_read_metadata().isOfflineSessionMaxLifespanEnabled();
    }

    public void setOfflineSessionMaxLifespanEnabled(Boolean offlineSessionMaxLifespanEnabled) {
        this.$$_hibernate_read_metadata().setOfflineSessionMaxLifespanEnabled(offlineSessionMaxLifespanEnabled);
    }

    public Boolean isEventsEnabled() {
        return this.$$_hibernate_read_metadata().isEventsEnabled();
    }

    public void setEventsEnabled(Boolean eventsEnabled) {
        this.$$_hibernate_read_metadata().setEventsEnabled(eventsEnabled);
    }

    public Integer getRefreshTokenMaxReuse() {
        return this.$$_hibernate_read_metadata().getRefreshTokenMaxReuse();
    }

    public void setRefreshTokenMaxReuse(Integer refreshTokenMaxReuse) {
        this.$$_hibernate_read_metadata().setRefreshTokenMaxReuse(refreshTokenMaxReuse);
    }

    public Integer getSsoSessionIdleTimeout() {
        return this.$$_hibernate_read_metadata().getSsoSessionIdleTimeout();
    }

    public void setSsoSessionIdleTimeout(Integer ssoSessionIdleTimeout) {
        this.$$_hibernate_read_metadata().setSsoSessionIdleTimeout(ssoSessionIdleTimeout);
    }

    public Integer getSsoSessionMaxLifespan() {
        return this.$$_hibernate_read_metadata().getSsoSessionMaxLifespan();
    }

    public void setSsoSessionMaxLifespan(Integer ssoSessionMaxLifespan) {
        this.$$_hibernate_read_metadata().setSsoSessionMaxLifespan(ssoSessionMaxLifespan);
    }

    public Integer getSsoSessionIdleTimeoutRememberMe() {
        return this.$$_hibernate_read_metadata().getSsoSessionIdleTimeoutRememberMe();
    }

    public void setSsoSessionIdleTimeoutRememberMe(Integer ssoSessionIdleTimeoutRememberMe) {
        this.$$_hibernate_read_metadata().setSsoSessionIdleTimeoutRememberMe(ssoSessionIdleTimeoutRememberMe);
    }

    public Integer getSsoSessionMaxLifespanRememberMe() {
        return this.$$_hibernate_read_metadata().getSsoSessionMaxLifespanRememberMe();
    }

    public void setSsoSessionMaxLifespanRememberMe(Integer ssoSessionMaxLifespanRememberMe) {
        this.$$_hibernate_read_metadata().setSsoSessionMaxLifespanRememberMe(ssoSessionMaxLifespanRememberMe);
    }

    public Integer getOfflineSessionIdleTimeout() {
        return this.$$_hibernate_read_metadata().getOfflineSessionIdleTimeout();
    }

    public void setOfflineSessionIdleTimeout(Integer offlineSessionIdleTimeout) {
        this.$$_hibernate_read_metadata().setOfflineSessionIdleTimeout(offlineSessionIdleTimeout);
    }

    public Integer getAccessTokenLifespan() {
        return this.$$_hibernate_read_metadata().getAccessTokenLifespan();
    }

    public void setAccessTokenLifespan(Integer accessTokenLifespan) {
        this.$$_hibernate_read_metadata().setAccessTokenLifespan(accessTokenLifespan);
    }

    public Integer getAccessTokenLifespanForImplicitFlow() {
        return this.$$_hibernate_read_metadata().getAccessTokenLifespanForImplicitFlow();
    }

    public void setAccessTokenLifespanForImplicitFlow(Integer accessTokenLifespanForImplicitFlow) {
        this.$$_hibernate_read_metadata().setAccessTokenLifespanForImplicitFlow(accessTokenLifespanForImplicitFlow);
    }

    public Integer getAccessCodeLifespan() {
        return this.$$_hibernate_read_metadata().getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(Integer accessCodeLifespan) {
        this.$$_hibernate_read_metadata().setAccessCodeLifespan(accessCodeLifespan);
    }

    public Integer getAccessCodeLifespanUserAction() {
        return this.$$_hibernate_read_metadata().getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(Integer accessCodeLifespanUserAction) {
        this.$$_hibernate_read_metadata().setAccessCodeLifespanUserAction(accessCodeLifespanUserAction);
    }

    public Integer getAccessCodeLifespanLogin() {
        return this.$$_hibernate_read_metadata().getAccessCodeLifespanLogin();
    }

    public void setAccessCodeLifespanLogin(Integer accessCodeLifespanLogin) {
        this.$$_hibernate_read_metadata().setAccessCodeLifespanLogin(accessCodeLifespanLogin);
    }

    public Long getNotBefore() {
        return this.$$_hibernate_read_metadata().getNotBefore();
    }

    public void setNotBefore(Long notBefore) {
        this.$$_hibernate_read_metadata().setNotBefore(notBefore);
    }

    public Integer getClientSessionIdleTimeout() {
        return this.$$_hibernate_read_metadata().getClientSessionIdleTimeout();
    }

    public void setClientSessionIdleTimeout(Integer clientSessionIdleTimeout) {
        this.$$_hibernate_read_metadata().setClientSessionIdleTimeout(clientSessionIdleTimeout);
    }

    public Integer getClientSessionMaxLifespan() {
        return this.$$_hibernate_read_metadata().getClientSessionMaxLifespan();
    }

    public void setClientSessionMaxLifespan(Integer clientSessionMaxLifespan) {
        this.$$_hibernate_read_metadata().setClientSessionMaxLifespan(clientSessionMaxLifespan);
    }

    public Integer getClientOfflineSessionIdleTimeout() {
        return this.$$_hibernate_read_metadata().getClientOfflineSessionIdleTimeout();
    }

    public void setClientOfflineSessionIdleTimeout(Integer clientOfflineSessionIdleTimeout) {
        this.$$_hibernate_read_metadata().setClientOfflineSessionIdleTimeout(clientOfflineSessionIdleTimeout);
    }

    public Integer getClientOfflineSessionMaxLifespan() {
        return this.$$_hibernate_read_metadata().getClientOfflineSessionMaxLifespan();
    }

    public void setClientOfflineSessionMaxLifespan(Integer clientOfflineSessionMaxLifespan) {
        this.$$_hibernate_read_metadata().setClientOfflineSessionMaxLifespan(clientOfflineSessionMaxLifespan);
    }

    public Integer getActionTokenGeneratedByAdminLifespan() {
        return this.$$_hibernate_read_metadata().getActionTokenGeneratedByAdminLifespan();
    }

    public void setActionTokenGeneratedByAdminLifespan(Integer actionTokenGeneratedByAdminLifespan) {
        this.$$_hibernate_read_metadata().setActionTokenGeneratedByAdminLifespan(actionTokenGeneratedByAdminLifespan);
    }

    public Integer getOfflineSessionMaxLifespan() {
        return this.$$_hibernate_read_metadata().getOfflineSessionMaxLifespan();
    }

    public void setOfflineSessionMaxLifespan(Integer offlineSessionMaxLifespan) {
        this.$$_hibernate_read_metadata().setOfflineSessionMaxLifespan(offlineSessionMaxLifespan);
    }

    public Long getEventsExpiration() {
        return this.$$_hibernate_read_metadata().getEventsExpiration();
    }

    public void setEventsExpiration(Long eventsExpiration) {
        this.$$_hibernate_read_metadata().setEventsExpiration(eventsExpiration);
    }

    public String getPasswordPolicy() {
        return this.$$_hibernate_read_metadata().getPasswordPolicy();
    }

    public void setPasswordPolicy(String passwordPolicy) {
        this.$$_hibernate_read_metadata().setPasswordPolicy(passwordPolicy);
    }

    public String getSslRequired() {
        return this.$$_hibernate_read_metadata().getSslRequired();
    }

    public void setSslRequired(String sslRequired) {
        this.$$_hibernate_read_metadata().setSslRequired(sslRequired);
    }

    public String getLoginTheme() {
        return this.$$_hibernate_read_metadata().getLoginTheme();
    }

    public void setLoginTheme(String loginTheme) {
        this.$$_hibernate_read_metadata().setLoginTheme(loginTheme);
    }

    public String getAccountTheme() {
        return this.$$_hibernate_read_metadata().getAccountTheme();
    }

    public void setAccountTheme(String accountTheme) {
        this.$$_hibernate_read_metadata().setAccountTheme(accountTheme);
    }

    public String getAdminTheme() {
        return this.$$_hibernate_read_metadata().getAdminTheme();
    }

    public void setAdminTheme(String adminTheme) {
        this.$$_hibernate_read_metadata().setAdminTheme(adminTheme);
    }

    public String getEmailTheme() {
        return this.$$_hibernate_read_metadata().getEmailTheme();
    }

    public void setEmailTheme(String emailTheme) {
        this.$$_hibernate_read_metadata().setEmailTheme(emailTheme);
    }

    public String getMasterAdminClient() {
        return this.$$_hibernate_read_metadata().getMasterAdminClient();
    }

    public void setMasterAdminClient(String masterAdminClient) {
        this.$$_hibernate_read_metadata().setMasterAdminClient(masterAdminClient);
    }

    public String getDefaultRoleId() {
        return this.$$_hibernate_read_metadata().getDefaultRoleId();
    }

    public void setDefaultRoleId(String defaultRoleId) {
        this.$$_hibernate_read_metadata().setDefaultRoleId(defaultRoleId);
    }

    public String getDefaultLocale() {
        return this.$$_hibernate_read_metadata().getDefaultLocale();
    }

    public void setDefaultLocale(String defaultLocale) {
        this.$$_hibernate_read_metadata().setDefaultLocale(defaultLocale);
    }

    public String getBrowserFlow() {
        return this.$$_hibernate_read_metadata().getBrowserFlow();
    }

    public void setBrowserFlow(String browserFlow) {
        this.$$_hibernate_read_metadata().setBrowserFlow(browserFlow);
    }

    public String getRegistrationFlow() {
        return this.$$_hibernate_read_metadata().getRegistrationFlow();
    }

    public void setRegistrationFlow(String registrationFlow) {
        this.$$_hibernate_read_metadata().setRegistrationFlow(registrationFlow);
    }

    public String getDirectGrantFlow() {
        return this.$$_hibernate_read_metadata().getDirectGrantFlow();
    }

    public void setDirectGrantFlow(String directGrantFlow) {
        this.$$_hibernate_read_metadata().setDirectGrantFlow(directGrantFlow);
    }

    public String getResetCredentialsFlow() {
        return this.$$_hibernate_read_metadata().getResetCredentialsFlow();
    }

    public void setResetCredentialsFlow(String resetCredentialsFlow) {
        this.$$_hibernate_read_metadata().setResetCredentialsFlow(resetCredentialsFlow);
    }

    public String getClientAuthenticationFlow() {
        return this.$$_hibernate_read_metadata().getClientAuthenticationFlow();
    }

    public void setClientAuthenticationFlow(String clientAuthenticationFlow) {
        this.$$_hibernate_read_metadata().setClientAuthenticationFlow(clientAuthenticationFlow);
    }

    public String getDockerAuthenticationFlow() {
        return this.$$_hibernate_read_metadata().getDockerAuthenticationFlow();
    }

    public void setDockerAuthenticationFlow(String dockerAuthenticationFlow) {
        this.$$_hibernate_read_metadata().setDockerAuthenticationFlow(dockerAuthenticationFlow);
    }

    public MapOTPPolicyEntity getOTPPolicy() {
        return this.$$_hibernate_read_metadata().getOTPPolicy();
    }

    public void setOTPPolicy(MapOTPPolicyEntity otpPolicy) {
        this.$$_hibernate_read_metadata().setOTPPolicy(otpPolicy);
    }

    public MapWebAuthnPolicyEntity getWebAuthnPolicy() {
        return this.$$_hibernate_read_metadata().getWebAuthnPolicy();
    }

    public void setWebAuthnPolicy(MapWebAuthnPolicyEntity webAuthnPolicy) {
        this.$$_hibernate_read_metadata().setWebAuthnPolicy(webAuthnPolicy);
    }

    public MapWebAuthnPolicyEntity getWebAuthnPolicyPasswordless() {
        return this.$$_hibernate_read_metadata().getWebAuthnPolicyPasswordless();
    }

    public void setWebAuthnPolicyPasswordless(MapWebAuthnPolicyEntity webAuthnPolicyPasswordless) {
        this.$$_hibernate_read_metadata().setWebAuthnPolicyPasswordless(webAuthnPolicyPasswordless);
    }

    public Set<String> getDefaultClientScopeIds() {
        return this.$$_hibernate_read_metadata().getDefaultClientScopeIds();
    }

    public void addDefaultClientScopeId(String scopeId) {
        this.$$_hibernate_read_metadata().addDefaultClientScopeId(scopeId);
    }

    public Boolean removeDefaultClientScopeId(String scopeId) {
        return this.$$_hibernate_read_metadata().removeDefaultClientScopeId(scopeId);
    }

    public Set<String> getOptionalClientScopeIds() {
        return this.$$_hibernate_read_metadata().getOptionalClientScopeIds();
    }

    public void addOptionalClientScopeId(String scopeId) {
        this.$$_hibernate_read_metadata().addOptionalClientScopeId(scopeId);
    }

    public Boolean removeOptionalClientScopeId(String scopeId) {
        return this.$$_hibernate_read_metadata().removeOptionalClientScopeId(scopeId);
    }

    public Set<String> getDefaultGroupIds() {
        return this.$$_hibernate_read_metadata().getDefaultGroupIds();
    }

    public void addDefaultGroupId(String groupId) {
        this.$$_hibernate_read_metadata().addDefaultGroupId(groupId);
    }

    public void removeDefaultGroupId(String groupId) {
        this.$$_hibernate_read_metadata().removeDefaultGroupId(groupId);
    }

    public Set<String> getEventsListeners() {
        return this.$$_hibernate_read_metadata().getEventsListeners();
    }

    public void setEventsListeners(Set<String> eventsListeners) {
        this.$$_hibernate_read_metadata().setEventsListeners(eventsListeners);
    }

    public Set<String> getEnabledEventTypes() {
        return this.$$_hibernate_read_metadata().getEnabledEventTypes();
    }

    public void setEnabledEventTypes(Set<String> enabledEventTypes) {
        this.$$_hibernate_read_metadata().setEnabledEventTypes(enabledEventTypes);
    }

    public Set<String> getSupportedLocales() {
        return this.$$_hibernate_read_metadata().getSupportedLocales();
    }

    public void setSupportedLocales(Set<String> supportedLocales) {
        this.$$_hibernate_read_metadata().setSupportedLocales(supportedLocales);
    }

    public Map<String, Map<String, String>> getLocalizationTexts() {
        return this.$$_hibernate_read_metadata().getLocalizationTexts();
    }

    public Map<String, String> getLocalizationText(String locale) {
        return this.$$_hibernate_read_metadata().getLocalizationText(locale);
    }

    public void setLocalizationText(String locale, Map<String, String> texts) {
        this.$$_hibernate_read_metadata().setLocalizationText(locale, texts);
    }

    public Boolean removeLocalizationText(String locale) {
        return this.$$_hibernate_read_metadata().removeLocalizationText(locale);
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        return this.$$_hibernate_read_metadata().getBrowserSecurityHeaders();
    }

    public void setBrowserSecurityHeaders(Map<String, String> headers) {
        this.$$_hibernate_read_metadata().setBrowserSecurityHeaders(headers);
    }

    public void setBrowserSecurityHeader(String name, String value) {
        this.$$_hibernate_read_metadata().setBrowserSecurityHeader(name, value);
    }

    public Map<String, String> getSmtpConfig() {
        return this.$$_hibernate_read_metadata().getSmtpConfig();
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.$$_hibernate_read_metadata().setSmtpConfig(smtpConfig);
    }

    public Set<MapRequiredCredentialEntity> getRequiredCredentials() {
        return this.$$_hibernate_read_metadata().getRequiredCredentials();
    }

    public void addRequiredCredential(MapRequiredCredentialEntity requiredCredential) {
        this.$$_hibernate_read_metadata().addRequiredCredential(requiredCredential);
    }

    public Set<MapComponentEntity> getComponents() {
        return this.$$_hibernate_read_components().stream().map(MapComponentEntity.class::cast).collect(Collectors.toSet());
    }

    public Optional<MapComponentEntity> getComponent(String componentId) {
        return this.$$_hibernate_read_components().stream().filter(c -> Objects.equals(c.getId(), componentId)).findFirst().map(MapComponentEntity.class::cast);
    }

    public void addComponent(MapComponentEntity component) {
        JpaComponentEntity jpaComponent = (JpaComponentEntity)JpaComponentEntity.class.cast(JpaMapStorageProviderFactory.CLONER.from((Object)component));
        jpaComponent.setParent(this);
        jpaComponent.setEntityVersion(Constants.CURRENT_SCHEMA_VERSION_COMPONENT);
        this.$$_hibernate_read_components().add(jpaComponent);
    }

    public Boolean removeComponent(String componentId) {
        return this.$$_hibernate_read_components().removeIf(c -> Objects.equals(c.getId(), componentId));
    }

    public Set<MapAuthenticationFlowEntity> getAuthenticationFlows() {
        return this.$$_hibernate_read_metadata().getAuthenticationFlows();
    }

    public Optional<MapAuthenticationFlowEntity> getAuthenticationFlow(String p0) {
        return this.$$_hibernate_read_metadata().getAuthenticationFlow(p0);
    }

    public void addAuthenticationFlow(MapAuthenticationFlowEntity authenticationFlow) {
        this.$$_hibernate_read_metadata().addAuthenticationFlow(authenticationFlow);
    }

    public Boolean removeAuthenticationFlow(String p0) {
        return this.$$_hibernate_read_metadata().removeAuthenticationFlow(p0);
    }

    public Set<MapAuthenticationExecutionEntity> getAuthenticationExecutions() {
        return this.$$_hibernate_read_metadata().getAuthenticationExecutions();
    }

    public Optional<MapAuthenticationExecutionEntity> getAuthenticationExecution(String p0) {
        return this.$$_hibernate_read_metadata().getAuthenticationExecution(p0);
    }

    public void addAuthenticationExecution(MapAuthenticationExecutionEntity authenticationExecution) {
        this.$$_hibernate_read_metadata().addAuthenticationExecution(authenticationExecution);
    }

    public Boolean removeAuthenticationExecution(String p0) {
        return this.$$_hibernate_read_metadata().removeAuthenticationExecution(p0);
    }

    public Set<MapAuthenticatorConfigEntity> getAuthenticatorConfigs() {
        return this.$$_hibernate_read_metadata().getAuthenticatorConfigs();
    }

    public Optional<MapAuthenticatorConfigEntity> getAuthenticatorConfig(String p0) {
        return this.$$_hibernate_read_metadata().getAuthenticatorConfig(p0);
    }

    public void addAuthenticatorConfig(MapAuthenticatorConfigEntity authenticatorConfig) {
        this.$$_hibernate_read_metadata().addAuthenticatorConfig(authenticatorConfig);
    }

    public Boolean removeAuthenticatorConfig(String p0) {
        return this.$$_hibernate_read_metadata().removeAuthenticatorConfig(p0);
    }

    public Set<MapRequiredActionProviderEntity> getRequiredActionProviders() {
        return this.$$_hibernate_read_metadata().getRequiredActionProviders();
    }

    public Optional<MapRequiredActionProviderEntity> getRequiredActionProvider(String requiredActionProviderId) {
        return this.$$_hibernate_read_metadata().getRequiredActionProvider(requiredActionProviderId);
    }

    public void addRequiredActionProvider(MapRequiredActionProviderEntity requiredActionProvider) {
        this.$$_hibernate_read_metadata().addRequiredActionProvider(requiredActionProvider);
    }

    public Boolean removeRequiredActionProvider(String requiredActionProviderId) {
        return this.$$_hibernate_read_metadata().removeRequiredActionProvider(requiredActionProviderId);
    }

    public Set<MapIdentityProviderEntity> getIdentityProviders() {
        return this.$$_hibernate_read_metadata().getIdentityProviders();
    }

    public void addIdentityProvider(MapIdentityProviderEntity identityProvider) {
        this.$$_hibernate_read_metadata().addIdentityProvider(identityProvider);
    }

    public Boolean removeIdentityProvider(String p0) {
        return this.$$_hibernate_read_metadata().removeIdentityProvider(p0);
    }

    public void addIdentityProviderMapper(MapIdentityProviderMapperEntity identityProviderMapper) {
        this.$$_hibernate_read_metadata().addIdentityProviderMapper(identityProviderMapper);
    }

    public Set<MapIdentityProviderMapperEntity> getIdentityProviderMappers() {
        return this.$$_hibernate_read_metadata().getIdentityProviderMappers();
    }

    public Optional<MapIdentityProviderMapperEntity> getIdentityProviderMapper(String p0) {
        return this.$$_hibernate_read_metadata().getIdentityProviderMapper(p0);
    }

    public Boolean removeIdentityProviderMapper(String p0) {
        return this.$$_hibernate_read_metadata().removeIdentityProviderMapper(p0);
    }

    public Set<MapClientInitialAccessEntity> getClientInitialAccesses() {
        return this.$$_hibernate_read_metadata().getClientInitialAccesses();
    }

    public Optional<MapClientInitialAccessEntity> getClientInitialAccess(String p0) {
        return this.$$_hibernate_read_metadata().getClientInitialAccess(p0);
    }

    public void addClientInitialAccess(MapClientInitialAccessEntity clientInitialAccess) {
        this.$$_hibernate_read_metadata().addClientInitialAccess(clientInitialAccess);
    }

    public Boolean removeClientInitialAccess(String p0) {
        return this.$$_hibernate_read_metadata().removeClientInitialAccess(p0);
    }

    public Map<String, List<String>> getAttributes() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (JpaRealmAttributeEntity attribute : this.$$_hibernate_read_attributes()) {
            List values = result.getOrDefault(attribute.getName(), new LinkedList());
            values.add(attribute.getValue());
            result.put(attribute.getName(), values);
        }
        return result;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.$$_hibernate_read_attributes().clear();
        if (attributes != null) {
            for (Map.Entry<String, List<String>> attrEntry : attributes.entrySet()) {
                this.setAttribute(attrEntry.getKey(), attrEntry.getValue());
            }
        }
    }

    public List<String> getAttribute(String name) {
        return this.$$_hibernate_read_attributes().stream().filter(a -> Objects.equals(a.getName(), name)).map(JpaAttributeEntity::getValue).collect(Collectors.toList());
    }

    public void setAttribute(String name, List<String> values) {
        this.removeAttribute(name);
        for (String value : values) {
            JpaRealmAttributeEntity attribute = new JpaRealmAttributeEntity(this, name, value);
            this.$$_hibernate_read_attributes().add(attribute);
        }
    }

    public void removeAttribute(String name) {
        this.$$_hibernate_read_attributes().removeIf(attr -> Objects.equals(attr.getName(), name));
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JpaRealmEntity)) {
            return false;
        }
        return Objects.equals(this.getId(), ((JpaRealmEntity)obj).getId());
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public UUID $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)uUID);
            return;
        }
        this.id = uUID;
    }

    public int $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().readInt((Object)this, "version", this.version);
        }
        return this.version;
    }

    public void $$_hibernate_write_version(int n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().writeInt((Object)this, "version", this.version, n);
            return;
        }
        this.version = n;
    }

    public JpaRealmMetadata $$_hibernate_read_metadata() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.metadata = (JpaRealmMetadata)this.$$_hibernate_getInterceptor().readObject((Object)this, "metadata", (Object)this.metadata);
        }
        return this.metadata;
    }

    public Integer $$_hibernate_read_entityVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "entityVersion", (Object)this.entityVersion);
        }
        return this.entityVersion;
    }

    public void $$_hibernate_write_entityVersion(Integer n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "entityVersion", (Object)this.entityVersion, (Object)n);
            return;
        }
        this.entityVersion = n;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public String $$_hibernate_read_displayName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.displayName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "displayName", (Object)this.displayName);
        }
        return this.displayName;
    }

    public void $$_hibernate_write_displayName(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.displayName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "displayName", (Object)this.displayName, (Object)string);
            return;
        }
        this.displayName = string;
    }

    public String $$_hibernate_read_displayNameHtml() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.displayNameHtml = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "displayNameHtml", (Object)this.displayNameHtml);
        }
        return this.displayNameHtml;
    }

    public void $$_hibernate_write_displayNameHtml(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.displayNameHtml = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "displayNameHtml", (Object)this.displayNameHtml, (Object)string);
            return;
        }
        this.displayNameHtml = string;
    }

    public Boolean $$_hibernate_read_enabled() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.enabled = (Boolean)this.$$_hibernate_getInterceptor().readObject((Object)this, "enabled", (Object)this.enabled);
        }
        return this.enabled;
    }

    public void $$_hibernate_write_enabled(Boolean bl) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.enabled = (Boolean)this.$$_hibernate_getInterceptor().writeObject((Object)this, "enabled", (Object)this.enabled, (Object)bl);
            return;
        }
        this.enabled = bl;
    }

    public Set $$_hibernate_read_attributes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "attributes", this.attributes);
        }
        return this.attributes;
    }

    public Set $$_hibernate_read_components() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.components = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "components", this.components);
        }
        return this.components;
    }
}

