/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.PublicKeyCredentialEntity;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PublicKeyCredentialUserEntity
extends PublicKeyCredentialEntity {
    private final byte[] id;
    private final String displayName;

    @JsonCreator
    public PublicKeyCredentialUserEntity(@JsonProperty(value="id") @NonNull byte[] id, @JsonProperty(value="name") @NonNull String name, @JsonProperty(value="displayName") @NonNull String displayName) {
        super(name);
        AssertUtil.notNull((Object)name, (String)"name must not be null");
        AssertUtil.notNull((Object)displayName, (String)"displayName must not be null");
        this.id = id;
        this.displayName = displayName;
    }

    public @NonNull byte[] getId() {
        return ArrayUtil.clone((byte[])this.id);
    }

    public @NonNull String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PublicKeyCredentialUserEntity that = (PublicKeyCredentialUserEntity)o;
        return Arrays.equals(this.id, that.id) && Objects.equals(this.displayName, that.displayName);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.displayName);
        result = 31 * result + Arrays.hashCode(this.id);
        return result;
    }

    @Override
    public String toString() {
        return "PublicKeyCredentialUserEntity(id=" + ArrayUtil.toHexString((byte[])this.id) + ", displayName=" + this.displayName + ')';
    }
}

