/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.source.keystore;

import io.smallrye.config.AbstractLocationConfigSourceFactory;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigurableConfigSource;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.source.keystore.KeyStoreConfig;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class KeyStoreConfigSourceFactory
implements ConfigSourceFactory.ConfigurableConfigSourceFactory<KeyStoreConfig> {
    public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context, KeyStoreConfig keyStoreConfig) {
        ArrayList<ConfigSource> keyStoreSources = new ArrayList<ConfigSource>();
        for (Map.Entry<String, KeyStoreConfig.KeyStore> keyStoreEntry : keyStoreConfig.keystores().entrySet()) {
            final KeyStoreConfig.KeyStore keyStore = keyStoreEntry.getValue();
            keyStoreSources.add((ConfigSource)new ConfigurableConfigSource((ConfigSourceFactory)new AbstractLocationConfigSourceFactory(){

                protected String[] getFileExtensions() {
                    return new String[0];
                }

                protected ConfigSource loadConfigSource(URL url, int ordinal) throws IOException {
                    return new UrlKeyStoreConfigSource(url, ordinal).loadKeyStore(keyStore);
                }

                public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context) {
                    return this.loadConfigSources(keyStore.path(), 100);
                }
            }));
        }
        return keyStoreSources;
    }

    private static class UrlKeyStoreConfigSource
    implements ConfigSource {
        private final URL url;
        private final int ordinal;

        UrlKeyStoreConfigSource(URL url, int ordinal) {
            this.url = url;
            this.ordinal = ordinal;
        }

        ConfigSource loadKeyStore(final KeyStoreConfig.KeyStore keyStoreConfig) throws IOException {
            try {
                KeyStore keyStore = KeyStore.getInstance(keyStoreConfig.type());
                keyStore.load(this.url.openStream(), keyStoreConfig.password().toCharArray());
                HashMap<String, Object> properties = new HashMap<String, Object>();
                Enumeration<String> aliases = keyStore.aliases();
                while (aliases.hasMoreElements()) {
                    final String alias = aliases.nextElement();
                    KeyStoreConfig.KeyStore.Alias aliasConfig = keyStoreConfig.aliases().getOrDefault(alias, new KeyStoreConfig.KeyStore.Alias(){

                        @Override
                        public Optional<String> name() {
                            return Optional.of(alias);
                        }

                        @Override
                        public Optional<String> password() {
                            return Optional.of(keyStoreConfig.password());
                        }

                        @Override
                        public Optional<String> handler() {
                            return keyStoreConfig.handler();
                        }
                    });
                    if (keyStore.isKeyEntry(alias)) {
                        Key key = keyStore.getKey(alias, aliasConfig.password().orElse(keyStoreConfig.password()).toCharArray());
                        Optional<String> handler = aliasConfig.handler();
                        Object encoded = handler.isPresent() ? "${" + handler.get() + "::" + new String(key.getEncoded(), StandardCharsets.UTF_8) + "}" : new String(key.getEncoded(), StandardCharsets.UTF_8);
                        properties.put(aliasConfig.name().orElse(alias), encoded);
                        continue;
                    }
                    if (!keyStore.isCertificateEntry(alias)) continue;
                }
                return new PropertiesConfigSource(properties, this.getName(), this.getOrdinal());
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                throw new RuntimeException(e);
            }
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public Set<String> getPropertyNames() {
            throw new UnsupportedOperationException();
        }

        public String getValue(String propertyName) {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return "KeyStoreConfigSource[source=" + this.url.toString() + "]";
        }
    }
}

