/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ShortBuffer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.function.Consumer;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AggregateByteArray;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateAccessor;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.IntervaldsAccessor;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.LobCommonAccessor;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.NumberAccessor;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OutRawAccessor;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.T2CCharByteArray;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CLongAccessor;
import oracle.jdbc.driver.T2CLongRawAccessor;
import oracle.jdbc.driver.T2CPlsqlIndexTableAccessor;
import oracle.jdbc.driver.T2CResultSetAccessor;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.driver.T2CVarcharAccessor;
import oracle.jdbc.driver.TimestampAccessor;
import oracle.jdbc.driver.TimestampltzAccessor;
import oracle.jdbc.driver.TimestamptzAccessor;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.oracore.OracleTypeADT;

class T2CCallableStatement
extends OracleCallableStatement {
    private final String CLASS_NAME = this.getClass().getName();
    T2CConnection t2cConnection = null;
    static int T2C_EXTEND_BUFFER = -3;
    long[] t2cOutput = new long[10];
    long[] t2cOutputUpdateCountArray = null;
    int[] t2cOutputUpdateCountArraySize = new int[1];
    static final int T2C_OUTPUT_USE_NIO = 5;
    static final int T2C_OUTPUT_STMT_LOB_PREFETCH_SIZE = 6;
    static final int T2C_OUTPUT_USE_OCI_DEFAULT_DEFINE_OFFSET = 7;
    static final boolean T2CDEBUG = false;
    int extractedCharOffset;
    int extractedByteOffset;
    int savedRowPrefetch = 0;
    int OCIPrefetch = 1;
    static final byte T2C_LOB_PREFETCH_SIZE_THIS_COLUMN_OFFSET = 0;
    static final byte T2C_LOB_PREFETCH_LOB_LENGTH_OFFSET = 1;
    static final byte T2C_LOB_PREFETCH_FORM_OFFSET = 2;
    static final byte T2C_LOB_PREFETCH_CHUNK_OFFSET = 3;
    static final byte T2C_LOB_PREFETCH_DATA_OFFSET = 4;
    byte[] lobPrefetchTempBytes;
    boolean needToRetainRows = false;
    byte[] returnParamBytes;
    char[] returnParamChars;
    int[] returnParamIndicators;
    int returnParamRowBytes;
    int returnParamRowChars;
    static int PREAMBLE_PER_POSITION = 5;
    SQLException updateDataException = null;
    int lastProcessedCell = 0;
    static final int PROCESS_DEFINE_DYNAMIC_COLUMNS = 16;
    static final int PROCESS_DEFINE_DEFAULT_COLUMNS = 32;
    static final int PROCESS_ADT_OUT_BINDS = 64;
    int lastProcessedAccessorIndex = 0;
    int accessorsProcessed = 0;
    int previousMode = 0;

    T2CCallableStatement(T2CConnection connection, String sql, OracleResultSet.ResultSetType resultSetType) throws SQLException {
        super(connection, sql, resultSetType);
        this.t2cConnection = connection;
        if (this.t2cConnection.useOCIDefaultDefines) {
            this.savedRowPrefetch = this.rowPrefetch;
            this.OCIPrefetch = this.rowPrefetch;
            this.rowPrefetch = 1;
        }
    }

    @Override
    int getPrefetchInternal(boolean statement) {
        if (!this.t2cConnection.useOCIDefaultDefines) {
            return super.getPrefetchInternal(statement);
        }
        int ret_val = statement ? this.defaultRowPrefetch : this.savedRowPrefetch;
        return ret_val;
    }

    @Override
    void setPrefetchInternal(int new_value, boolean setRowPrefetch, boolean statement) throws SQLException {
        int localRowPrefetch = this.rowPrefetch;
        super.setPrefetchInternal(new_value, setRowPrefetch, statement);
        if (this.t2cConnection.useOCIDefaultDefines && localRowPrefetch != this.rowPrefetch) {
            this.savedRowPrefetch = this.rowPrefetch;
            this.OCIPrefetch = this.rowPrefetch;
            this.rowPrefetch = 1;
        }
    }

    @Override
    void prepareForNewResults(boolean resetPrefetch, boolean clearStreamList, boolean clearImplicitResults) throws SQLException {
        super.prepareForNewResults(resetPrefetch, clearStreamList, clearImplicitResults);
        if (this.t2cConnection.useOCIDefaultDefines && this.rowPrefetchChanged) {
            this.savedRowPrefetch = this.rowPrefetch;
            this.OCIPrefetch = this.rowPrefetch;
            this.rowPrefetch = 1;
        }
    }

    @Override
    void prepareAccessors() throws SQLException {
        super.prepareAccessors();
        if (this.rowPrefetchChanged) {
            this.lobPrefetchMetaData = this.getLobPrefetchMetaData();
        }
        if (this.t2cConnection.useOCIDefaultDefines && this.hasStream) {
            this.savedRowPrefetch = 1;
        }
    }

    String bytes2String(byte[] bytes, int offset, int size) throws SQLException {
        byte[] tmp = new byte[size];
        System.arraycopy(bytes, offset, tmp, 0, size);
        return this.connection.conversion.CharBytesToString(tmp, size);
    }

    void processDescribeData() throws SQLException {
        this.described = true;
        this.describedWithNames = true;
        if (this.numberOfDefinePositions < 1) {
            return;
        }
        if (this.accessors == null || this.numberOfDefinePositions > this.accessors.length) {
            this.accessors = new Accessor[this.numberOfDefinePositions];
        }
        int currentShort = this.t2cConnection.queryMetaData1Offset;
        int currentChar = this.t2cConnection.queryMetaData2Offset;
        short[] s = this.t2cConnection.queryMetaData1;
        byte[] c = this.t2cConnection.queryMetaData2;
        int i = 0;
        while (i < this.numberOfDefinePositions) {
            Accessor accessor;
            short accessorType = s[currentShort + 0];
            short maxLength = s[currentShort + 1];
            short maxCharLength = s[currentShort + 11];
            boolean nullable = s[currentShort + 2] != 0;
            short precision = s[currentShort + 3];
            short scale = s[currentShort + 4];
            int flags = 0;
            long contflag = 0L;
            int totalElems = 0;
            short formOfUse = s[currentShort + 5];
            short columnNameLen = s[currentShort + 6];
            String columnName = this.bytes2String(c, currentChar, columnNameLen);
            short schemaNameLen = s[currentShort + 12];
            short typeNameLen = s[currentShort + 13];
            boolean columnInvisible = s[currentShort + 14] != 0;
            boolean columnJSON = s[currentShort + 15] != 0;
            String schemaName = null;
            Object typeName = null;
            OracleTypeADT otype = null;
            currentChar += columnNameLen;
            if (typeNameLen > 0) {
                schemaName = this.bytes2String(c, currentChar, schemaNameLen);
                typeName = this.bytes2String(c, currentChar += schemaNameLen, typeNameLen);
                currentChar += typeNameLen;
                typeName = PhysicalConnection.needToQuoteIdentifier(schemaName) || PhysicalConnection.needToQuoteIdentifier((String)typeName) ? String.format("\"%s\".\"%s\"", schemaName, typeName) : schemaName + "." + (String)typeName;
                otype = new OracleTypeADT((String)typeName, (Connection)this.connection);
                otype.tdoCState = ((long)s[currentShort + 7] & 0xFFFFL) << 48 | ((long)s[currentShort + 8] & 0xFFFFL) << 32 | ((long)s[currentShort + 9] & 0xFFFFL) << 16 | (long)s[currentShort + 10] & 0xFFFFL;
            }
            if ((accessor = this.accessors[i]) == null || accessor.defineType == 0 || accessor.describeType != 0 && accessor.describeType != accessorType) {
                accessor = this.allocateAccessorForDefines(i, accessorType, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse, maxCharLength, otype, (String)typeName);
                if (this.accessors[i] != null) {
                    accessor.rowLength = this.accessors[i].rowLength;
                    accessor.rowOffset = this.accessors[i].rowOffset;
                    accessor.rowNull = this.accessors[i].rowNull;
                    accessor.rowMetadata = this.accessors[i].rowMetadata;
                }
            } else {
                accessor.initForDescribe(accessorType, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse, (String)typeName);
            }
            accessor.describeOtype = otype;
            accessor.columnName = columnName;
            accessor.columnInvisible = columnInvisible;
            accessor.columnJSON = columnJSON;
            this.accessors[i] = accessor;
            ++i;
            currentShort += 16;
        }
    }

    Accessor allocateAccessorForDefines(int index, int accessorType, int maxLength, boolean nullable, int flags, int precision, int scale, long contflag, int totalElems, short formOfUse, int maxCharLength, OracleTypeADT otype, String typeName) throws SQLException {
        Accessor accessor;
        switch (accessorType) {
            case 1: {
                accessor = new VarcharAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse, maxCharLength);
                break;
            }
            case 96: {
                accessor = new CharAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse, maxCharLength);
                break;
            }
            case 2: {
                accessor = new NumberAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                break;
            }
            case 23: {
                accessor = new RawAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                break;
            }
            case 100: {
                accessor = new BinaryFloatAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                break;
            }
            case 101: {
                accessor = new BinaryDoubleAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                break;
            }
            case 8: {
                accessor = new T2CLongAccessor(this, index + 1, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                this.rowPrefetch = 1;
                this.OCIPrefetch = 1;
                this.savedRowPrefetch = 1;
                break;
            }
            case 24: {
                accessor = new T2CLongRawAccessor(this, index + 1, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                this.rowPrefetch = 1;
                this.savedRowPrefetch = 1;
                this.OCIPrefetch = 1;
                break;
            }
            case 104: {
                accessor = new RowidAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, 1);
                break;
            }
            case 102: 
            case 116: {
                if (this.sqlKind.isPlsqlOrCall()) {
                    accessor = new T2CResultSetAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                    break;
                }
                accessor = new ResultSetAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                break;
            }
            case 12: {
                accessor = new DateAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                break;
            }
            case 180: {
                accessor = new TimestampAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                break;
            }
            case 181: {
                accessor = new TimestamptzAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                break;
            }
            case 231: {
                accessor = new TimestampltzAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                break;
            }
            case 182: {
                accessor = new IntervalymAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                break;
            }
            case 183: {
                accessor = new IntervaldsAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                break;
            }
            case 112: {
                accessor = new ClobAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                break;
            }
            case 113: {
                accessor = new BlobAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                break;
            }
            case 114: {
                accessor = new BfileAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                break;
            }
            case 109: {
                accessor = new NamedTypeAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse, typeName, otype);
                break;
            }
            case 111: {
                accessor = new RefTypeAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse, typeName, otype);
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unknown or unimplemented accessor type: " + accessorType).fillInStackTrace();
            }
        }
        return accessor;
    }

    @Override
    void executeForDescribe() throws SQLException {
        boolean try_again;
        int rowsToFetch;
        this.t2cOutput[0] = 0L;
        this.t2cOutput[2] = 0L;
        this.t2cOutput[7] = this.t2cConnection.useOCIDefaultDefines ? 1 : 0;
        this.lobPrefetchMetaData = null;
        boolean need_to_describe = !this.described;
        boolean executed = false;
        int n = rowsToFetch = this.t2cConnection.useOCIDefaultDefines ? this.savedRowPrefetch : this.rowPrefetch;
        assert (rowsToFetch > 0) : "rowsToFetch < 1 (rowsToFetch=" + rowsToFetch + ", maxRows=" + this.maxRows + ", rowPrefetch=" + this.rowPrefetch + ", savedRowPrefetch=" + this.savedRowPrefetch + ")";
        this.validRows = 0L;
        do {
            try_again = false;
            if (this.connection.endToEndAnyChanged) {
                this.pushEndToEndValues();
                this.connection.endToEndAnyChanged = false;
            }
            byte[] array_sql = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
            int status = 0;
            try {
                this.resetStateBeforeFetch();
                if (this.sqlObject.getSqlKind().isDML() && this.numberOfBoundRows > 0) {
                    this.t2cOutputUpdateCountArray = new long[this.numberOfBoundRows];
                    this.t2cOutputUpdateCountArraySize[0] = this.numberOfBoundRows;
                } else {
                    this.t2cOutputUpdateCountArray = null;
                    this.t2cOutputUpdateCountArraySize[0] = 0;
                }
                status = T2CStatement.t2cParseExecuteDescribe(this, this.c_state, this.numberOfBindPositions, this.numberOfBindRowsAllocated, this.firstRowInBatch, this.currentRowBindAccessors != null, this.needToParse, need_to_describe, executed, array_sql, array_sql.length, T2CStatement.convertSqlKindEnumToByte(this.sqlKind), rowsToFetch, this.OCIPrefetch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, this.ibtBindIndicators, this.ibtBindIndicatorOffset, this.ibtBindIndicatorSize, this.ibtBindBytes, this.ibtBindChars, this.ibtBindByteOffset, this.ibtBindCharOffset, this.returnParamMeta, this.t2cConnection.queryMetaData1, this.t2cConnection.queryMetaData2, this.t2cConnection.queryMetaData1Offset, this.t2cConnection.queryMetaData2Offset, this.t2cConnection.queryMetaData1Size, this.t2cConnection.queryMetaData2Size, this.preparedByteBinds, this.preparedCharBinds, this.outBindAccessors, this.binders, this.t2cOutput, this.t2cOutputUpdateCountArray, this.t2cOutputUpdateCountArraySize, this.t2cConnection.plsqlCompilerWarnings);
            }
            catch (IOException iox) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 266).fillInStackTrace();
            }
            finally {
                if (this.t2cOutputUpdateCountArraySize[0] > 0) {
                    this.batchRowsUpdatedArray = new long[this.t2cOutputUpdateCountArraySize[0]];
                    System.arraycopy(this.t2cOutputUpdateCountArray, 0, this.batchRowsUpdatedArray, 0, this.t2cOutputUpdateCountArraySize[0]);
                } else if (this.batchRowsUpdatedArray != null) {
                    this.batchRowsUpdatedArray = new long[0];
                }
            }
            if (this.bindIndicators != null) {
                this.setLengthForOutAccessors();
            }
            this.validRows = this.t2cOutput[1];
            if (status == -1 || status == -4) {
                this.t2cConnection.checkError(status, this.c_state, this.sqlObject);
            } else if (status == T2C_EXTEND_BUFFER) {
                status = this.t2cConnection.queryMetaData1Size * 2;
            }
            if (this.t2cOutput[3] != 0L) {
                this.foundPlsqlCompilerWarning();
            } else if (this.t2cOutput[2] != 0L) {
                this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
            }
            this.connection.endToEndECIDSequenceNumber = (short)this.t2cOutput[4];
            this.needToParse = false;
            executed = true;
            if (this.sqlKind.isSELECT()) {
                this.numberOfDefinePositions = status;
                if (this.numberOfDefinePositions > this.t2cConnection.queryMetaData1Size) {
                    try_again = true;
                    executed = true;
                    this.t2cConnection.reallocateQueryMetaData(this.numberOfDefinePositions, this.numberOfDefinePositions * 8);
                }
            } else {
                this.numberOfDefinePositions = 0;
            }
            if (!this.sqlKind.isPlsqlOrCall()) continue;
            this.checkForImplicitResultSets();
        } while (try_again);
        this.isAllFetched = false;
        this.processDescribeData();
    }

    @Override
    final void executeForDescribeAsync(Consumer<Throwable> callback) {
        callback.accept(new UnsupportedOperationException("Type 2 OCI connections do not support async execution"));
    }

    void checkForImplicitResultSets() throws SQLException {
        int status = 0;
        status = T2CStatement.t2cGetImplicitResultSetCount(this, this.c_state);
        if (status > 0) {
            int implicitResultSetCount;
            this.implicitResultSetStatements = new ArrayDeque(implicitResultSetCount);
            for (implicitResultSetCount = status; implicitResultSetCount != 0; --implicitResultSetCount) {
                OracleStatement newstmt = this.connection.createImplicitResultSetStatement(this);
                ((T2CStatement)newstmt).doDescribe(true);
                ((T2CStatement)newstmt).prepareAccessors();
            }
            this.implicitResultSetIterator = this.implicitResultSetStatements.iterator();
        } else if (status != 0) {
            this.t2cConnection.checkError(status);
        }
    }

    void pushEndToEndValues() throws SQLException {
        T2CConnection c = this.t2cConnection;
        byte[] e2e_action = null;
        byte[] e2e_clientid = null;
        byte[] e2e_ecid = null;
        byte[] e2e_module = null;
        byte[] e2e_dbop = null;
        if (c.endToEndValues != null) {
            if (c.endToEndHasChanged[0]) {
                String action = c.endToEndValues[0];
                e2e_action = action != null ? DBConversion.stringToDriverCharBytes(action, c.m_clientCharacterSet) : PhysicalConnection.EMPTY_BYTE_ARRAY;
                c.endToEndHasChanged[0] = false;
            }
            if (c.endToEndHasChanged[1]) {
                String clientid = c.endToEndValues[1];
                e2e_clientid = clientid != null ? DBConversion.stringToDriverCharBytes(clientid, c.m_clientCharacterSet) : PhysicalConnection.EMPTY_BYTE_ARRAY;
                c.endToEndHasChanged[1] = false;
            }
            if (c.endToEndHasChanged[2]) {
                String ecid = c.endToEndValues[2];
                e2e_ecid = ecid != null ? DBConversion.stringToDriverCharBytes(ecid, c.m_clientCharacterSet) : PhysicalConnection.EMPTY_BYTE_ARRAY;
                c.endToEndHasChanged[2] = false;
            }
            if (c.endToEndHasChanged[3]) {
                String module = c.endToEndValues[3];
                e2e_module = module != null ? DBConversion.stringToDriverCharBytes(module, c.m_clientCharacterSet) : PhysicalConnection.EMPTY_BYTE_ARRAY;
                c.endToEndHasChanged[3] = false;
            }
            if (c.endToEndHasChanged[4]) {
                String dbop = c.endToEndValues[4];
                e2e_module = dbop != null ? DBConversion.stringToDriverCharBytes(dbop, c.m_clientCharacterSet) : PhysicalConnection.EMPTY_BYTE_ARRAY;
                c.endToEndHasChanged[4] = false;
            }
            T2CStatement.t2cEndToEndUpdate(this.c_state, e2e_action, e2e_action == null ? -1 : e2e_action.length, e2e_clientid, e2e_clientid == null ? -1 : e2e_clientid.length, e2e_ecid, e2e_ecid == null ? -1 : e2e_ecid.length, e2e_module, e2e_module == null ? -1 : e2e_module.length, e2e_dbop, e2e_dbop == null ? -1 : e2e_dbop.length, c.endToEndECIDSequenceNumber);
        }
    }

    @Override
    void executeForRows(boolean executed_for_describe) throws SQLException {
        if (this.connection.endToEndAnyChanged) {
            this.pushEndToEndValues();
            this.connection.endToEndAnyChanged = false;
        }
        if (!executed_for_describe) {
            if (this.numberOfDefinePositions > 0) {
                this.doDefineExecuteFetch();
            } else {
                this.executeForDescribe();
            }
        } else if (this.numberOfDefinePositions > 0) {
            this.doDefineFetch();
        }
        if (this.returnParamMeta != null) {
            this.fetchDmlReturnParams();
        }
        this.needToPrepareDefineBuffer = false;
    }

    @Override
    protected boolean isDefineBufferPreparedForExecute() throws SQLException {
        if (this.numberOfDefinePositions > 0) {
            return false;
        }
        return super.isDefineBufferPreparedForExecute();
    }

    @Override
    final void executeForRowsAsync(boolean executed_for_describe, Consumer<Throwable> callback) {
        callback.accept(new UnsupportedOperationException("Type 2 OCI connections do not support async execution"));
    }

    void setupForDefine() throws SQLException {
        if (this.numberOfDefinePositions > this.t2cConnection.queryMetaData1Size) {
            int n = this.numberOfDefinePositions / 100 + 1;
            this.t2cConnection.reallocateQueryMetaData(this.t2cConnection.queryMetaData1Size * n, this.t2cConnection.queryMetaData2Size * n * 8);
        }
        short[] s = this.t2cConnection.queryMetaData1;
        int currentShort = this.t2cConnection.queryMetaData1Offset;
        int i = 0;
        while (i < this.numberOfDefinePositions) {
            Accessor currentAccessor = this.accessors[i];
            if (currentAccessor == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
            }
            s[currentShort + 0] = (short)currentAccessor.defineType;
            if (!this.described && currentAccessor.charLength > 0 && currentAccessor.formOfUse == 1) {
                int charLength = currentAccessor.charLength;
                int byteLength = charLength + 1;
                s[currentShort + 11] = 0;
                s[currentShort + 1] = (short)byteLength;
            } else {
                s[currentShort + 11] = (short)currentAccessor.charLength;
                s[currentShort + 1] = (short)currentAccessor.byteLength;
            }
            s[currentShort + 5] = currentAccessor.formOfUse;
            if (currentAccessor.internalOtype != null) {
                long tdo = ((OracleTypeADT)currentAccessor.internalOtype).getTdoCState();
                s[currentShort + 7] = (short)((tdo & 0xFFFF000000000000L) >> 48);
                s[currentShort + 8] = (short)((tdo & 0xFFFF00000000L) >> 32);
                s[currentShort + 9] = (short)((tdo & 0xFFFF0000L) >> 16);
                s[currentShort + 10] = (short)(tdo & 0xFFFFL);
            }
            switch (currentAccessor.internalType) {
                case 112: 
                case 113: {
                    if (currentAccessor.lobPrefetchSizeForThisColumn == -1) {
                        currentAccessor.setPrefetchLength(this.defaultLobPrefetchSize);
                    }
                    s[currentShort + 7] = (short)currentAccessor.lobPrefetchSizeForThisColumn;
                }
            }
            ++i;
            currentShort += 16;
        }
    }

    @Override
    protected void configureBindData() throws SQLException {
        if (this.outBindAccessors == null) {
            return;
        }
        AggregateByteArray _bindData = (AggregateByteArray)this.bindData;
        T2CCharByteArray _bindChars = (T2CCharByteArray)_bindData.extension;
        AggregateByteArray _bindIbtBytes = (AggregateByteArray)_bindChars.extension;
        T2CCharByteArray _bindIbtChars = (T2CCharByteArray)_bindIbtBytes.extension;
        if (this.bindBytes != null) {
            _bindData.setBytes(this.bindBytes);
        } else {
            _bindData.setBytes(PhysicalConnection.EMPTY_BYTE_ARRAY);
        }
        if (this.bindChars != null) {
            _bindChars.setChars(this.bindChars);
        } else {
            _bindChars.setChars(PhysicalConnection.EMPTY_CHAR_ARRAY);
        }
        if (this.ibtBindBytes != null) {
            _bindIbtBytes.setBytes(this.ibtBindBytes);
        } else {
            _bindIbtBytes.setBytes(PhysicalConnection.EMPTY_BYTE_ARRAY);
        }
        if (this.ibtBindChars != null) {
            _bindIbtChars.setChars(this.ibtBindChars);
        } else {
            _bindIbtChars.setChars(PhysicalConnection.EMPTY_CHAR_ARRAY);
        }
        _bindChars.setDBConversion(this.connection.conversion);
        _bindIbtChars.setDBConversion(this.connection.conversion);
        int bindBytesLength = this.bindBytes == null ? 0 : this.bindBytes.length;
        int bindCharsLength = this.bindChars == null ? 0 : this.bindChars.length;
        int ibtBindBytesLength = this.ibtBindBytes == null ? 0 : this.ibtBindBytes.length;
        int ibtBindCharsLength = this.ibtBindChars == null ? 0 : this.ibtBindChars.length;
        Accessor a = null;
        int lengthPrefix = 0;
        for (int columnNumber = 0; columnNumber < this.numberOfBindPositions; ++columnNumber) {
            a = this.outBindAccessors[columnNumber];
            if (a == null) continue;
            int offset = 0;
            int dataLength = a.byteLength;
            if (a.defineType == 998) {
                PlsqlIndexTableAccessor a1 = (PlsqlIndexTableAccessor)a;
                offset += bindBytesLength + bindCharsLength;
                offset += a1.ibtBindInfo.ibtValueIndex;
                switch (a1.ibtBindInfo.element_internal_type) {
                    case 9: {
                        offset += ibtBindBytesLength;
                        break;
                    }
                }
                a.setOffset(0, offset);
                continue;
            }
            offset = a.columnDataOffset;
            if (a.charLength > 0) {
                offset += bindBytesLength;
                dataLength = a.charLength;
            }
            lengthPrefix = a.defineType == 15 ? 2 : (a.externalType == -8 ? (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK ? 1 : 2) : (a.defineType == 6 || a.defineType == 9 ? 1 : 0));
            for (int rowNumber = 0; rowNumber < this.binders.length; ++rowNumber) {
                int len = this.bindIndicators[a.lengthIndex] - lengthPrefix & Short.MAX_VALUE;
                a.setOffset(rowNumber, offset += dataLength * rowNumber + lengthPrefix);
            }
        }
    }

    @Override
    void initializePlsqlIndexByTableAccessor(Accessor accessor, int indOffset) {
        ((T2CPlsqlIndexTableAccessor)accessor).ibtMetaIndex = indOffset - 8;
    }

    Object[] getLobPrefetchMetaData() {
        Object[] lobPrefetchMetaData = null;
        Object isPrefetchEnabled = null;
        int[] lobPrefetchSizeForThisColumnArray = null;
        int noOfLobColumnsWithPrefetch = 0;
        int lastStreamColumnIndex = 0;
        if (this.accessors != null) {
            int i;
            block7: for (i = 0; i < this.numberOfDefinePositions; ++i) {
                switch (this.accessors[i].internalType) {
                    case 8: 
                    case 24: {
                        lastStreamColumnIndex = i;
                        continue block7;
                    }
                    case 112: 
                    case 113: {
                        if (lobPrefetchSizeForThisColumnArray == null) {
                            lobPrefetchSizeForThisColumnArray = new int[this.accessors.length];
                        }
                        if (this.accessors[i].lobPrefetchSizeForThisColumn != -1) {
                            ++noOfLobColumnsWithPrefetch;
                            lobPrefetchSizeForThisColumnArray[i] = this.accessors[i].lobPrefetchSizeForThisColumn;
                            continue block7;
                        }
                        lobPrefetchSizeForThisColumnArray[i] = -1;
                    }
                }
            }
            if (noOfLobColumnsWithPrefetch > 0) {
                if (lobPrefetchMetaData == null || this.rowPrefetchChanged) {
                    lobPrefetchMetaData = new Object[]{null, new long[this.rowPrefetch * noOfLobColumnsWithPrefetch], new byte[this.accessors.length], new int[this.accessors.length], new Object[this.rowPrefetch * noOfLobColumnsWithPrefetch]};
                }
                for (i = 0; i < lastStreamColumnIndex; ++i) {
                    switch (this.accessors[i].internalType) {
                        case 112: 
                        case 113: {
                            this.accessors[i].setPrefetchLength(-1);
                            lobPrefetchSizeForThisColumnArray[i] = -1;
                        }
                    }
                }
                lobPrefetchMetaData[0] = lobPrefetchSizeForThisColumnArray;
            }
        }
        return lobPrefetchMetaData;
    }

    @Override
    void processLobPrefetchMetaData(Object[] lobPrefetchMetaData) {
        int lobColumnCount = 0;
        int noOfRowsFetched = (int)this.validRows == -2 ? 1 : (int)this.validRows;
        byte[] prefetchedDataFormOfUse = (byte[])lobPrefetchMetaData[2];
        int[] prefetchedChunkSize = (int[])lobPrefetchMetaData[3];
        long[] prefetchedLength = (long[])lobPrefetchMetaData[1];
        Object[] prefetchedData = (Object[])lobPrefetchMetaData[4];
        int[] lobPrefetchSizeForThisColumnArray = (int[])lobPrefetchMetaData[0];
        if (this.accessors != null) {
            block3: for (int col = 0; col < this.numberOfDefinePositions; ++col) {
                switch (this.accessors[col].internalType) {
                    case 112: 
                    case 113: {
                        if (this.accessors[col].lobPrefetchSizeForThisColumn < 0) continue block3;
                        LobCommonAccessor accessor = (LobCommonAccessor)this.accessors[col];
                        if (accessor.prefetchedDataLength == null || accessor.prefetchedDataLength.length < this.rowPrefetch) {
                            if (accessor.internalType == 112) {
                                ((ClobAccessor)accessor).prefetchedDataFormOfUse = new int[this.rowPrefetch];
                            }
                            accessor.prefetchedChunkSize = new int[this.rowPrefetch];
                            accessor.prefetchedDataLength = new int[this.rowPrefetch];
                            accessor.prefetchedLength = new long[this.rowPrefetch];
                            accessor.prefetchedDataOffset = new long[this.rowPrefetch];
                        }
                        int offset = noOfRowsFetched * lobColumnCount;
                        int rowOffset = this.needToRetainRows ? this.storedRowCount : 0;
                        for (int row = 0; row < noOfRowsFetched; ++row) {
                            int dataLength;
                            accessor.prefetchedChunkSize[rowOffset + row] = prefetchedChunkSize[col];
                            accessor.prefetchedLength[rowOffset + row] = prefetchedLength[offset + row];
                            if (accessor.internalType == 112) {
                                ((ClobAccessor)accessor).prefetchedDataFormOfUse[rowOffset + row] = prefetchedDataFormOfUse[col];
                            }
                            accessor.prefetchedDataLength[row] = 0;
                            accessor.prefetchedDataOffset[row] = 0L;
                            if (lobPrefetchSizeForThisColumnArray[col] <= 0 || prefetchedLength[offset + row] <= 0L) continue;
                            byte[] b = (byte[])prefetchedData[offset + row];
                            int n = dataLength = b == null ? 0 : b.length;
                            if (dataLength > 0) {
                                accessor.setPrefetchedDataOffset(rowOffset + row);
                                accessor.rowData.put(b, 0, dataLength);
                            }
                            accessor.prefetchedDataLength[rowOffset + row] = dataLength;
                        }
                        ++lobColumnCount;
                        continue block3;
                    }
                }
            }
        }
    }

    int getRowsToFetch() {
        int rowsToFetch = -1;
        if (this.hasStream) {
            rowsToFetch = 1;
            if (this.t2cConnection.useOCIDefaultDefines) {
                this.savedRowPrefetch = 1;
            } else {
                this.rowPrefetch = 1;
            }
        } else {
            rowsToFetch = this.t2cConnection.useOCIDefaultDefines ? (this.maxRows > 0L && this.maxRows == (long)this.storedRowCount ? 0 : this.rowPrefetch) : (this.maxRows > 0L && this.maxRows < (long)(this.rowPrefetch + this.storedRowCount) ? (this.storedRowCount < 1 && this.maxRows < (long)this.rowPrefetch ? (int)this.maxRows : (int)Math.min((long)this.rowPrefetch, this.maxRows - (long)this.storedRowCount)) : this.rowPrefetch);
        }
        return rowsToFetch;
    }

    void doDefineFetch() throws SQLException {
        int rowsToFetch = this.getRowsToFetch();
        this.validRows = 0L;
        if (!this.needToPrepareDefineBuffer) {
            throw new Error("doDefineFetch called when needToPrepareDefineBuffer=false " + this.sqlObject.getSql(this.processEscapes, this.convertNcharLiterals));
        }
        assert (rowsToFetch > 0) : "rowsToFetch < 1 (rowsToFetch=" + rowsToFetch + ", maxRows=" + this.maxRows + ", rowPrefetch=" + this.rowPrefetch + ", savedRowPrefetch=" + this.savedRowPrefetch + ")";
        if (rowsToFetch > 0) {
            this.setupForDefine();
            this.t2cOutput[2] = 0L;
            this.t2cOutput[5] = this.connection.useNio ? 1 : 0;
            this.t2cOutput[6] = this.defaultLobPrefetchSize;
            if (this.connection.useNio) {
                this.resetNioAttributesBeforeFetch();
                this.allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
            }
            if (this.lobPrefetchMetaData == null) {
                this.lobPrefetchMetaData = this.getLobPrefetchMetaData();
            }
            this.resetStateBeforeFetch();
            this.validRows = T2CStatement.t2cDefineFetch(this, this.c_state, rowsToFetch, this.OCIPrefetch, this.t2cConnection.queryMetaData1, this.t2cConnection.queryMetaData2, this.t2cConnection.queryMetaData1Offset, this.t2cConnection.queryMetaData2Offset, this.accessors, this.t2cOutput, this.nioBuffers, this.lobPrefetchMetaData);
            if (this.validRows == -1L || this.validRows == -4L) {
                this.t2cConnection.checkError((int)this.validRows);
            }
            if (this.t2cOutput[2] != 0L) {
                this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
            }
            if (this.connection.useNio && (this.validRows > 0L || this.validRows == -2L)) {
                this.extractNioDefineBuffers(0);
            }
            if (this.isFetchStreams && this.validRows == -2L) {
                this.copyStreamDataIntoDBA(0);
            }
            if (this.lobPrefetchMetaData != null) {
                this.processLobPrefetchMetaData(this.lobPrefetchMetaData);
            }
        }
        this.isAllFetched = rowsToFetch < 1 || this.validRows >= 0L && this.validRows < (long)rowsToFetch;
    }

    void copyStreamDataIntoDBA(int row) throws SQLException {
        assert (this.isFetchStreams && this.validRows == -2L) : "isFetchStreams: " + this.isFetchStreams + "isScrollable(): " + this.realRsetType.isScrollable() + ", isUpdatable(): " + this.realRsetType.isUpdatable() + ", validRows=" + this.validRows;
        this.checkValidRowsStatus();
        if (this.accessors != null) {
            block4: for (Accessor a : this.accessors) {
                if (a == null) continue;
                switch (a.internalType) {
                    case 8: {
                        ((T2CLongAccessor)a).copyStreamDataIntoDBA(row);
                        continue block4;
                    }
                    case 24: {
                        ((T2CLongRawAccessor)a).copyStreamDataIntoDBA(row);
                    }
                }
            }
        }
    }

    void allocateNioBuffersIfRequired(int charSize, int byteSize, int indSize) throws SQLException {
        if (this.nioBuffers == null) {
            this.nioBuffers = new ByteBuffer[4];
        }
        if (byteSize > 0) {
            if (this.nioBuffers[0] == null || this.nioBuffers[0].capacity() < byteSize) {
                this.nioBuffers[0] = ByteBuffer.allocateDirect(byteSize);
            } else if (this.nioBuffers[0] != null) {
                this.nioBuffers[0].rewind();
            }
        }
        if ((charSize *= 2) > 0) {
            if (this.nioBuffers[1] == null || this.nioBuffers[1].capacity() < charSize) {
                this.nioBuffers[1] = ByteBuffer.allocateDirect(charSize);
            } else if (this.nioBuffers[1] != null) {
                this.nioBuffers[1].rewind();
            }
        }
        if ((indSize *= 2) > 0) {
            if (this.nioBuffers[2] == null || this.nioBuffers[2].capacity() < indSize) {
                this.nioBuffers[2] = ByteBuffer.allocateDirect(indSize);
            } else if (this.nioBuffers[2] != null) {
                this.nioBuffers[2].rewind();
            }
        }
    }

    void doDefineExecuteFetch() throws SQLException {
        short[] queryMetaData1 = null;
        if (this.needToPrepareDefineBuffer || this.needToParse) {
            this.setupForDefine();
            queryMetaData1 = this.t2cConnection.queryMetaData1;
        }
        this.t2cOutput[0] = 0L;
        this.t2cOutput[2] = 0L;
        byte[] array_sql = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
        this.t2cOutput[5] = this.connection.useNio ? 1 : 0;
        this.t2cOutput[6] = this.defaultLobPrefetchSize;
        this.t2cOutput[7] = this.t2cConnection.useOCIDefaultDefines ? 1 : 0;
        if (this.connection.useNio) {
            this.resetNioAttributesBeforeFetch();
            this.allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
        }
        if (this.lobPrefetchMetaData == null) {
            this.lobPrefetchMetaData = this.getLobPrefetchMetaData();
        }
        int rowsToFetch = this.getRowsToFetch();
        assert (rowsToFetch > 0) : "rowsToFetch < 1 (rowsToFetch=" + rowsToFetch + ", maxRows=" + this.maxRows + ", rowPrefetch=" + this.rowPrefetch + ", savedRowPrefetch=" + this.savedRowPrefetch + ")";
        this.validRows = 0L;
        try {
            this.resetStateBeforeFetch();
            this.validRows = T2CStatement.t2cDefineExecuteFetch(this, this.c_state, this.numberOfDefinePositions, this.numberOfBindPositions, this.numberOfBindRowsAllocated, this.firstRowInBatch, this.currentRowBindAccessors != null, this.needToParse, array_sql, array_sql.length, T2CStatement.convertSqlKindEnumToByte(this.sqlKind), rowsToFetch, this.OCIPrefetch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, queryMetaData1, this.t2cConnection.queryMetaData2, this.t2cConnection.queryMetaData1Offset, this.t2cConnection.queryMetaData2Offset, this.preparedByteBinds, this.preparedCharBinds, this.outBindAccessors, this.binders, this.t2cOutput, this.nioBuffers, this.lobPrefetchMetaData);
            if (this.bindIndicators != null) {
                this.setLengthForOutAccessors();
            }
        }
        catch (IOException iox) {
            this.validRows = 0L;
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iox).fillInStackTrace();
        }
        if (this.validRows == -1L) {
            this.t2cConnection.checkError((int)this.validRows);
        }
        if (this.t2cOutput[2] != 0L) {
            this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
        }
        this.connection.endToEndECIDSequenceNumber = (short)this.t2cOutput[4];
        if (this.connection.useNio && (this.validRows > 0L || this.validRows == -2L)) {
            this.extractNioDefineBuffers(0);
        }
        if (this.isFetchStreams && this.validRows == -2L) {
            this.copyStreamDataIntoDBA(0);
        }
        if (this.lobPrefetchMetaData != null) {
            this.processLobPrefetchMetaData(this.lobPrefetchMetaData);
        }
        this.isAllFetched = rowsToFetch < 1 || this.validRows >= 0L && this.validRows < (long)rowsToFetch;
        this.needToParse = false;
    }

    @Override
    protected void fetch(int firstRow, boolean retainRows) throws SQLException {
        this.needToRetainRows = retainRows;
        int rowsToFetch = this.getRowsToFetch();
        assert (rowsToFetch > 0) : "rowsToFetch < 1 (rowsToFetch=" + rowsToFetch + ", maxRows=" + this.maxRows + ", rowPrefetch=" + this.rowPrefetch + ", savedRowPrefetch=" + this.savedRowPrefetch + ")";
        this.validRows = 0L;
        if (rowsToFetch > 0 && this.numberOfDefinePositions > 0) {
            if (this.needToPrepareDefineBuffer) {
                this.doDefineFetch();
                this.needToPrepareDefineBuffer = false;
            } else {
                this.t2cOutput[2] = 0L;
                this.t2cOutput[5] = this.connection.useNio ? 1 : 0;
                this.t2cOutput[6] = this.defaultLobPrefetchSize;
                if (this.connection.useNio) {
                    this.resetNioAttributesBeforeFetch();
                    this.allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
                }
                if (this.lobPrefetchMetaData == null) {
                    this.lobPrefetchMetaData = this.getLobPrefetchMetaData();
                }
                this.resetStateBeforeFetch();
                this.validRows = T2CStatement.t2cFetch(this, this.c_state, this.needToPrepareDefineBuffer, rowsToFetch, this.OCIPrefetch, this.accessors, this.t2cOutput, this.nioBuffers, this.lobPrefetchMetaData);
                if (this.validRows == -1L || this.validRows == -4L) {
                    this.t2cConnection.checkError((int)this.validRows);
                }
                if (this.t2cOutput[2] != 0L) {
                    this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
                }
                if (this.lobPrefetchMetaData != null) {
                    this.processLobPrefetchMetaData(this.lobPrefetchMetaData);
                }
                if (this.connection.useNio && (this.validRows > 0L || this.validRows == -2L)) {
                    this.extractNioDefineBuffers(0);
                }
                if (this.isFetchStreams && this.validRows == -2L) {
                    this.copyStreamDataIntoDBA(firstRow);
                }
            }
        }
        this.isAllFetched = rowsToFetch < 1 || this.validRows >= 0L && this.validRows < (long)rowsToFetch;
        this.needToRetainRows = false;
    }

    @Override
    protected final void fetchAsync(int firstRow, boolean retainRows, Consumer<Throwable> callback) {
        callback.accept(new UnsupportedOperationException("Type 2 OCI connections do not support async execution"));
    }

    @Override
    final boolean isFetchAsyncSupported() {
        return false;
    }

    void resetNioAttributesBeforeFetch() {
        this.extractedCharOffset = 0;
        this.extractedByteOffset = 0;
    }

    @Override
    void extractNioDefineBuffers(int columnIndex) throws SQLException {
        if (this.accessors == null || this.defineIndicators == null || columnIndex == this.numberOfDefinePositions) {
            return;
        }
        int sizeToCopyBytes = 0;
        int sizeToCopyChars = 0;
        int sizeToCopyIndicators = 0;
        int lengthOffset = 0;
        int indOffset = 0;
        if (!this.hasStream) {
            sizeToCopyBytes = this.defineBytes != null ? this.defineBytes.length : 0;
            sizeToCopyChars = this.defineChars != null ? this.defineChars.length : 0;
            sizeToCopyIndicators = this.defineIndicators.length;
        } else {
            if (this.numberOfDefinePositions > columnIndex) {
                indOffset = this.accessors[columnIndex].indicatorIndex;
                lengthOffset = this.accessors[columnIndex].lengthIndex;
            }
            block3: for (int i = columnIndex; i < this.numberOfDefinePositions; ++i) {
                switch (this.accessors[i].internalType) {
                    case 8: 
                    case 24: {
                        break block3;
                    }
                    default: {
                        sizeToCopyBytes += this.accessors[i].byteLength;
                        sizeToCopyChars += this.accessors[i].charLength;
                        ++sizeToCopyIndicators;
                        continue block3;
                    }
                }
            }
        }
        ByteBuffer b = this.nioBuffers[0];
        if (b != null && this.defineBytes != null && sizeToCopyBytes > 0) {
            b.position(this.extractedByteOffset);
            b.get(this.defineBytes, this.extractedByteOffset, sizeToCopyBytes);
            this.extractedByteOffset += sizeToCopyBytes;
        }
        if (this.nioBuffers[1] != null && this.defineChars != null) {
            b = this.nioBuffers[1].order(ByteOrder.LITTLE_ENDIAN);
            CharBuffer c = b.asCharBuffer();
            if (sizeToCopyChars > 0) {
                c.position(this.extractedCharOffset);
                c.get(this.defineChars, this.extractedCharOffset, sizeToCopyChars);
                this.extractedCharOffset += sizeToCopyChars;
            }
        }
        if (this.nioBuffers[2] != null) {
            b = this.nioBuffers[2].order(ByteOrder.LITTLE_ENDIAN);
            ShortBuffer s = b.asShortBuffer();
            if (this.hasStream) {
                if (sizeToCopyIndicators > 0) {
                    s.position(indOffset);
                    s.get(this.defineIndicators, indOffset, sizeToCopyIndicators);
                    s.position(lengthOffset);
                    s.get(this.defineIndicators, lengthOffset, sizeToCopyIndicators);
                }
            } else {
                s.get(this.defineIndicators);
            }
        }
    }

    @Override
    void doClose() throws SQLException {
        if (this.defineBytes != null) {
            this.defineBytes = null;
        }
        if (this.defineChars != null) {
            this.defineChars = null;
        }
        if (this.defineIndicators != null) {
            this.defineIndicators = null;
        }
        int returnCode = T2CStatement.t2cCloseStatement(this.c_state);
        this.nioBuffers = null;
        if (returnCode != 0) {
            this.t2cConnection.checkError(returnCode);
        }
        this.t2cOutput = null;
    }

    @Override
    void closeQuery() throws SQLException {
        this.connection.needLine();
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException exc) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exc).fillInStackTrace();
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    @Override
    void closeUsedStreams(int columnIndex) throws SQLException {
        while (this.nextStream != null && this.nextStream.columnIndex < 1 + this.offsetOfFirstUserColumn + columnIndex) {
            try {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, this.CLASS_NAME, "closeUsedStreams", "closeUsedStream({0}) closing {1} at index {2}", (String)null, (Throwable)null, (Object)(1 + this.offsetOfFirstUserColumn + columnIndex), (Object)this.nextStream, (Object)this.nextStream.columnIndex);
                this.nextStream.close();
            }
            catch (IOException exc) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exc).fillInStackTrace();
            }
            this.nextStream = this.nextStream.nextStream;
        }
        if (this.nextStream != null) {
            try {
                this.nextStream.needBytes();
            }
            catch (IOException e) {
                this.interalCloseOnIOException(e);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e).fillInStackTrace();
            }
        }
    }

    void interalCloseOnIOException(IOException ea) throws SQLException {
        this.closed = true;
        if (this.currentResultSet != null) {
            this.currentResultSet.closed = true;
        }
        this.doClose();
    }

    @Override
    void fetchDmlReturnParams() throws SQLException {
        this.rowsDmlReturned = T2CStatement.t2cGetRowsDmlReturned(this.c_state);
        if (this.rowsDmlReturned != 0) {
            this.allocateDmlReturnStorage();
            this.resetStateBeforeFetch();
            int status = T2CStatement.t2cFetchDmlReturnParams(this.c_state, this, this.accessors, this.returnParamBytes, this.returnParamChars, this.returnParamIndicators);
            if (status == -1 || status == -4) {
                this.t2cConnection.checkError(status);
            }
            if (this.t2cOutput[2] != 0L) {
                this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
            }
            if (this.connection.useNio && (status > 0 || status == -2)) {
                this.extractNioDefineBuffers(0);
            }
        }
        AggregateByteArray _bindData = (AggregateByteArray)this.bindData;
        if (this.returnParamBytes != null) {
            _bindData.setBytes(this.returnParamBytes);
        }
        ((T2CCharByteArray)_bindData.extension).setChars(this.returnParamChars);
        ((T2CCharByteArray)_bindData.extension).setDBConversion(this.connection.conversion);
        int bindBytesLength = this.returnParamBytes == null ? 0 : this.returnParamBytes.length;
        int nullIndex = 0;
        int lenIndex = this.numReturnParams * this.rowsDmlReturned;
        int byteOffset = 0;
        int charOffset = bindBytesLength;
        int returnParamCount = 0;
        for (int aIndex = 0; aIndex < this.numberOfBindPositions; ++aIndex) {
            Accessor accessor = this.accessors[aIndex];
            if (accessor == null) continue;
            accessor.setCapacity(this.rowsDmlReturned);
            for (int rowNumber = 0; rowNumber < this.rowsDmlReturned; ++rowNumber) {
                if (accessor.internalType == 109 || accessor.internalType == 111) {
                    ++returnParamCount;
                    continue;
                }
                int len = this.returnParamIndicators[lenIndex++];
                boolean isNull = this.returnParamIndicators[nullIndex++] == -1;
                int lenPrefix = 0;
                if (accessor.internalType == 104) {
                    lenPrefix = 2;
                } else if (accessor.defineType == 6 || accessor.defineType == 9 || accessor.defineType == 1) {
                    lenPrefix = 1;
                }
                if (accessor.charLength > 0) {
                    accessor.setOffset(rowNumber, charOffset + lenPrefix);
                    charOffset += accessor.charLength;
                } else {
                    accessor.setOffset(rowNumber, byteOffset + lenPrefix);
                    byteOffset += accessor.byteLength;
                }
                if (isNull || len == 0) {
                    accessor.setLengthAndNull(rowNumber, 0);
                    continue;
                }
                if (accessor.internalType == 1) {
                    len /= 2;
                }
                accessor.setLengthAndNull(rowNumber, len);
            }
        }
        this.returnParamsFetched = true;
    }

    @Override
    void processDmlReturningBind() throws SQLException {
        super.processDmlReturningBind();
        this.returnParamRowBytes = 0;
        this.returnParamRowChars = 0;
        for (int i = 0; i < this.numberOfBindPositions; ++i) {
            Accessor accessor = this.accessors[i];
            if (accessor == null) continue;
            if (accessor.charLength > 0) {
                this.returnParamRowChars += accessor.charLength;
                continue;
            }
            this.returnParamRowBytes += accessor.byteLength;
        }
        this.returnParamMeta[1] = this.returnParamRowBytes;
        this.returnParamMeta[2] = this.returnParamRowChars;
    }

    @Override
    void allocateDmlReturnStorage() {
        if (this.rowsDmlReturned == 0) {
            return;
        }
        int totalBytes = this.returnParamRowBytes * this.rowsDmlReturned;
        int totalChars = this.returnParamRowChars * this.rowsDmlReturned;
        int indicatorLength = 2 * this.numReturnParams * this.rowsDmlReturned;
        this.returnParamBytes = new byte[totalBytes];
        this.returnParamChars = new char[totalChars];
        this.returnParamIndicators = new int[indicatorLength];
        for (int i = 0; i < this.numberOfBindPositions; ++i) {
            Accessor accessor = this.accessors[i];
            if (accessor == null) continue;
            accessor.setCapacity(this.rowsDmlReturned);
        }
    }

    void cleanupReturnParameterBuffers() {
        this.returnParamBytes = null;
        this.returnParamChars = null;
        this.returnParamIndicators = null;
    }

    @Override
    void initializeIndicatorSubRange() {
        this.bindIndicatorSubRange = this.numberOfBindPositions * PREAMBLE_PER_POSITION;
    }

    @Override
    int calculateIndicatorSubRangeSize() {
        return this.numberOfBindPositions * PREAMBLE_PER_POSITION;
    }

    @Override
    short getInoutIndicator(int bindPosition) {
        return this.bindIndicators[bindPosition * PREAMBLE_PER_POSITION];
    }

    void resetStateBeforeFetch() {
        this.lastProcessedCell = 0;
        this.lastProcessedAccessorIndex = 0;
        this.accessorsProcessed = 0;
        this.previousMode = 0;
        if (this.rowData != null) {
            if (this.needToRetainRows) {
                this.rowData.setPosition(this.rowData.length());
            } else {
                this.rowData.reset();
            }
        }
    }

    public int updateData(int mode, int numberOfCells, int numberOfRowsFetched, int[] columnMetaData, byte[] buffer) {
        try {
            if (this.previousMode != mode) {
                this.accessorsProcessed = 0;
            }
            this.previousMode = mode;
            int offset = 0;
            int rowNumber = 0;
            int colNumber = 0;
            int len = 0;
            boolean isNull = false;
            switch (mode) {
                case 16: 
                case 32: {
                    for (int cellIndex = 0; cellIndex < numberOfCells; ++cellIndex) {
                        rowNumber = columnMetaData[cellIndex * 4 + 0];
                        colNumber = columnMetaData[cellIndex * 4 + 1];
                        len = columnMetaData[cellIndex * 4 + 2];
                        isNull = columnMetaData[cellIndex * 4 + 3] == -1;
                        Accessor a = this.accessors[colNumber];
                        a.setOffset((this.needToRetainRows ? this.storedRowCount : 0) + rowNumber);
                        if (len > 0) {
                            switch (a.defineType) {
                                case 1: 
                                case 23: 
                                case 96: 
                                case 104: {
                                    offset += 2;
                                    len -= 2;
                                    break;
                                }
                                case 6: {
                                    ++offset;
                                    --len;
                                }
                            }
                            this.rowData.put(buffer, offset, len);
                            offset += len;
                        }
                        a.setLengthAndNull((this.needToRetainRows ? this.storedRowCount : 0) + rowNumber, len);
                        ++this.accessorsProcessed;
                        ++this.lastProcessedCell;
                    }
                    break;
                }
                case 64: {
                    int columnOffset = 0;
                    Accessor[] outOrReturnDmlAccessors = null;
                    if (this.outBindAccessors != null) {
                        columnOffset = (this.bindBytes == null ? 0 : this.bindBytes.length) + (this.bindChars == null ? 0 : this.bindChars.length) + (this.ibtBindBytes == null ? 0 : this.ibtBindBytes.length) + (this.ibtBindChars == null ? 0 : this.ibtBindChars.length);
                        outOrReturnDmlAccessors = this.outBindAccessors;
                    } else {
                        columnOffset = (this.returnParamBytes == null ? 0 : this.returnParamBytes.length) + (this.returnParamChars == null ? 0 : this.returnParamChars.length) + (this.ibtBindBytes == null ? 0 : this.ibtBindBytes.length) + (this.ibtBindChars == null ? 0 : this.ibtBindChars.length);
                        outOrReturnDmlAccessors = this.accessors;
                    }
                    assert (outOrReturnDmlAccessors != null) : "No OUT binds or Return Parameters";
                    ByteArray adtByteArray = this.bindData;
                    while (adtByteArray instanceof AggregateByteArray && (adtByteArray = ((AggregateByteArray)adtByteArray).extension) != null) {
                    }
                    columnOffset = (int)((long)columnOffset + adtByteArray.getPosition());
                    int accessorIndexForOutBinds = this.accessorsProcessed;
                    for (int cellIndex = 0; cellIndex < numberOfCells; ++cellIndex) {
                        rowNumber = columnMetaData[cellIndex * 4 + 0];
                        colNumber = columnMetaData[cellIndex * 4 + 1];
                        len = columnMetaData[cellIndex * 4 + 2];
                        isNull = columnMetaData[cellIndex * 4 + 3] == -1;
                        Accessor a = outOrReturnDmlAccessors[colNumber];
                        a.setOffset((this.needToRetainRows ? this.storedRowCount : 0) + rowNumber, columnOffset);
                        adtByteArray.put(buffer, offset, len);
                        a.setLengthAndNull((this.needToRetainRows ? this.storedRowCount : 0) + rowNumber, len);
                        offset += len;
                        columnOffset += len;
                        ++this.lastProcessedCell;
                    }
                    break;
                }
            }
        }
        catch (SQLException ea) {
            this.updateDataException = ea;
            return -3;
        }
        return 0;
    }

    final boolean bit(long value, long mask) {
        return (value & mask) == value;
    }

    public static String toHex(byte[] value, int length) {
        if (value == null) {
            return "null";
        }
        if (length > value.length) {
            return "byte array not long enough";
        }
        Object result = "0:";
        int len = length;
        for (int i = 0; i < len; ++i) {
            if (i != 0 && i % 10 == 0) {
                result = (String)result + "\n" + i + ": ";
            }
            result = (String)result + OracleLog.toHex(value[i]) + " ";
        }
        return result;
    }

    @Override
    void locationToPutBytes(Accessor acc, int row, int length) throws SQLException {
        acc.setOffset(row, this.allocateRowDataSpace(length));
    }

    @Override
    long allocateRowDataSpace(int size) {
        return this.rowData.length();
    }

    @Override
    public String getSqlId() throws SQLException {
        return super.getSqlId();
    }

    @Override
    boolean areOutBindsStoredInBindData() {
        return true;
    }

    @Override
    Accessor allocateAccessor(int internal_type, int external_type, int col_index, int max_len, short form, String typeName, boolean isOutBind) throws SQLException {
        Accessor result = null;
        switch (internal_type) {
            case 102: 
            case 116: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                result = new T2CResultSetAccessor(this, max_len, form, external_type, isOutBind);
                return result;
            }
            case 8: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                if (isOutBind) {
                    return new VarcharAccessor(this, max_len, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
                }
                return new T2CLongAccessor(this, col_index, max_len, form, external_type, isOutBind);
            }
            case 1: {
                if (!isOutBind) break;
                if (typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                result = new T2CVarcharAccessor(this, max_len, form, external_type, isOutBind);
                return result;
            }
            case 24: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                if (isOutBind) {
                    return new OutRawAccessor(this, max_len, form, external_type);
                }
                return new T2CLongRawAccessor(this, col_index, max_len, form, external_type, isOutBind);
            }
        }
        return super.allocateAccessor(internal_type, external_type, col_index, max_len, form, typeName, isOutBind);
    }

    @Override
    void prepareBindPreambles(int number_of_rows_to_be_bound, int number_of_rows_to_be_set_up) {
        int preambleSize = this.calculateIndicatorSubRangeSize();
        int currentPreambleIndex = this.bindIndicatorSubRange - preambleSize;
        for (int i = 0; i < this.numberOfBindPositions; ++i) {
            int inout;
            OracleTypeADT otype;
            Binder binder = this.lastBinders[i];
            if (binder == this.theReturnParamBinder) {
                otype = (OracleTypeADT)this.accessors[i].internalOtype;
                inout = 0;
            } else {
                OracleTypeADT oracleTypeADT = otype = this.binders[this.firstRowInBatch] == null ? null : this.getOtype(this.binders[this.firstRowInBatch][i]);
                if (this.outBindAccessors == null) {
                    inout = 0;
                } else {
                    Accessor accessor = this.outBindAccessors[i];
                    if (accessor == null) {
                        inout = 0;
                    } else if (binder == this.theOutBinder) {
                        inout = 1;
                        if (otype == null) {
                            otype = (OracleTypeADT)accessor.internalOtype;
                        }
                    } else {
                        inout = 2;
                    }
                }
                inout = binder.updateInoutIndicatorValue((short)inout);
            }
            this.bindIndicators[currentPreambleIndex++] = inout;
            if (otype != null) {
                long tdo = otype.getTdoCState();
                this.bindIndicators[currentPreambleIndex + 0] = (short)(tdo >> 48 & 0xFFFFL);
                this.bindIndicators[currentPreambleIndex + 1] = (short)(tdo >> 32 & 0xFFFFL);
                this.bindIndicators[currentPreambleIndex + 2] = (short)(tdo >> 16 & 0xFFFFL);
                this.bindIndicators[currentPreambleIndex + 3] = (short)(tdo & 0xFFFFL);
            }
            currentPreambleIndex += 4;
        }
    }

    @Override
    void releaseBuffers() {
        super.releaseBuffers();
    }

    void setLengthForOutAccessors() throws SQLException {
        if (this.outBindAccessors == null) {
            return;
        }
        Accessor a = null;
        for (int columnNumber = 0; columnNumber < this.numberOfBindPositions; ++columnNumber) {
            a = this.outBindAccessors[columnNumber];
            if (a == null || a.defineType == 998 || a.defineType == 111 || a.defineType == 109) continue;
            for (int rowNumber = 0; rowNumber < this.binders.length; ++rowNumber) {
                int length;
                boolean isNull = a.rowSpaceIndicator[a.indicatorIndex + rowNumber] == -1;
                int n = length = isNull ? 0 : a.rowSpaceIndicator[a.lengthIndex + rowNumber] & 0xFFFF;
                if (this.sqlKind != OracleStatement.SqlKind.CALL_BLOCK && a.externalType == -8) {
                    a.setLengthAndNull(rowNumber, length);
                    continue;
                }
                if (a.defineType == 9 || a.defineType == 1) {
                    a.setLengthAndNull(rowNumber, length / 2);
                    continue;
                }
                if (a.defineType == 109 || a.defineType == 111) continue;
                a.setLengthAndNull(rowNumber, length);
            }
        }
    }

    @Override
    void doDescribe(boolean includeNames) throws SQLException {
        boolean try_again;
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
        if (this.described) {
            return;
        }
        if (!this.isOpen) {
            this.connection.open(this);
            this.isOpen = true;
        }
        do {
            try_again = false;
            boolean needToExecute = this.sqlKind.isSELECT() && this.needToParse && (!this.described || !this.serverCursor);
            byte[] array_sql = needToExecute ? this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals) : PhysicalConnection.EMPTY_BYTE_ARRAY;
            this.numberOfDefinePositions = T2CStatement.t2cDescribe(this.c_state, this.t2cConnection.queryMetaData1, this.t2cConnection.queryMetaData2, this.t2cConnection.queryMetaData1Offset, this.t2cConnection.queryMetaData2Offset, this.t2cConnection.queryMetaData1Size, this.t2cConnection.queryMetaData2Size, array_sql, array_sql.length, needToExecute);
            if (!this.described) {
                this.described = true;
            }
            if (this.numberOfDefinePositions == -1) {
                this.t2cConnection.checkError(this.numberOfDefinePositions);
            }
            if (this.numberOfDefinePositions != T2C_EXTEND_BUFFER) continue;
            try_again = true;
            this.t2cConnection.reallocateQueryMetaData(this.t2cConnection.queryMetaData1Size * 2, this.t2cConnection.queryMetaData2Size * 2);
        } while (try_again);
        this.processDescribeData();
    }

    @Override
    protected void configureRowData() {
        this.rowData = DynamicByteArray.createDynamicByteArray(this.connection.getDiagnosable(), this.connection.getBlockSource());
        DynamicByteArray adtByteArray = DynamicByteArray.createDynamicByteArray(this.connection.getDiagnosable(), this.connection.getBlockSource());
        T2CCharByteArray ibtBindCharsArray = new T2CCharByteArray(this.connection.getDiagnosable(), PhysicalConnection.EMPTY_CHAR_ARRAY, (ByteArray)adtByteArray);
        AggregateByteArray ibtBindBytesArray = new AggregateByteArray(this.connection.getDiagnosable(), PhysicalConnection.EMPTY_BYTE_ARRAY, ibtBindCharsArray);
        T2CCharByteArray bindCharArray = new T2CCharByteArray(this.connection.getDiagnosable(), PhysicalConnection.EMPTY_CHAR_ARRAY, (ByteArray)ibtBindBytesArray);
        this.bindData = new AggregateByteArray(this.connection.getDiagnosable(), PhysicalConnection.EMPTY_BYTE_ARRAY, bindCharArray);
    }

    @Override
    boolean isThinDriver() {
        return false;
    }

    @Override
    void resetBindersToNull(int first_row_to_be_bound) {
        if (this.binders != null) {
            for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                for (int rowInBuffers = 0; rowInBuffers < this.numberOfBoundRows; ++rowInBuffers) {
                    int rowInBinders = first_row_to_be_bound + rowInBuffers;
                    this.binders[rowInBinders][bindPos] = null;
                }
            }
        }
    }

    @Override
    void setupBindBuffers(int first_row_to_be_bound, int number_of_rows_to_be_bound) throws SQLException {
        assert (!this.bindUseDBA) : "bindUseDBA is true for T2C or T2S driver.";
        if (this.bindIndicators == null) {
            this.allocBinds(number_of_rows_to_be_bound);
        }
        try {
            int per_position_metadata_offset;
            if (this.numberOfBindPositions == 0) {
                if (number_of_rows_to_be_bound != 0) {
                    this.numberOfBoundRows = number_of_rows_to_be_bound;
                    this.bindIndicators[this.bindIndicatorSubRange + 3] = (short)((this.numberOfBoundRows & 0xFFFF0000) >> 16);
                    this.bindIndicators[this.bindIndicatorSubRange + 4] = (short)(this.numberOfBoundRows & 0xFFFF);
                }
                return;
            }
            this.preparedAllBinds = this.currentBatchNeedToPrepareBinds;
            this.preparedByteBinds = false;
            this.preparedCharBinds = false;
            this.currentBatchNeedToPrepareBinds = false;
            this.numberOfBoundRows = number_of_rows_to_be_bound;
            this.bindIndicators[this.bindIndicatorSubRange + 3] = (short)((this.numberOfBoundRows & 0xFFFF0000) >> 16);
            this.bindIndicators[this.bindIndicatorSubRange + 4] = (short)(this.numberOfBoundRows & 0xFFFF);
            int number_of_rows_to_be_set_up = this.bindBufferCapacity;
            if (this.numberOfBoundRows > this.bindBufferCapacity) {
                number_of_rows_to_be_set_up = this.numberOfBoundRows;
                this.preparedAllBinds = true;
            }
            if (this.currentBatchBindAccessors != null) {
                if (this.outBindAccessors == null) {
                    this.outBindAccessors = new Accessor[this.numberOfBindPositions];
                }
                for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                    Accessor accessor;
                    this.outBindAccessors[bindPos] = accessor = this.currentBatchBindAccessors[bindPos];
                    if (accessor == null) continue;
                    int bytelen = accessor.byteLength;
                    int charlen = accessor.charLength;
                    if (this.currentBatchByteLens[bindPos] < bytelen) {
                        this.currentBatchByteLens[bindPos] = bytelen;
                    }
                    if (charlen != 0 && this.currentBatchCharLens[bindPos] >= charlen) continue;
                    this.currentBatchCharLens[bindPos] = charlen;
                }
            }
            int row_charlen = 0;
            int row_bytelen = 0;
            int metadata_offset = per_position_metadata_offset = this.bindIndicatorSubRange + 5;
            if (this.preparedAllBinds) {
                this.preparedByteBinds = true;
                this.preparedCharBinds = true;
                Binder[] firstRankBinders = this.binders[first_row_to_be_bound];
                for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                    short type;
                    Binder binder = firstRankBinders[bindPos];
                    int bytelen = this.currentBatchByteLens[bindPos];
                    int charlen = this.currentBatchCharLens[bindPos];
                    if (binder == this.theOutBinder) {
                        Accessor accessor = this.currentBatchBindAccessors[bindPos];
                        type = (short)accessor.defineType;
                    } else {
                        type = binder.type;
                    }
                    row_bytelen += bytelen;
                    row_charlen += charlen;
                    this.bindIndicators[metadata_offset + 0] = type;
                    this.bindIndicators[metadata_offset + 1] = (short)bytelen;
                    this.bindIndicators[metadata_offset + 2] = (short)charlen;
                    this.bindIndicators[metadata_offset + 9] = this.currentBatchFormOfUse[bindPos];
                    metadata_offset += 10;
                }
            } else if (this.preparedByteBinds | this.preparedCharBinds) {
                for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                    int bytelen = this.currentBatchByteLens[bindPos];
                    int charlen = this.currentBatchCharLens[bindPos];
                    row_bytelen += bytelen;
                    row_charlen += charlen;
                    this.bindIndicators[metadata_offset + 1] = (short)bytelen;
                    this.bindIndicators[metadata_offset + 2] = (short)charlen;
                    metadata_offset += 10;
                }
            } else {
                for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                    boolean wasLastBindNull;
                    int bytePitchOffset = metadata_offset + 1;
                    int charPitchOffset = metadata_offset + 2;
                    int bytelen = this.currentBatchByteLens[bindPos];
                    int charlen = this.currentBatchCharLens[bindPos];
                    int oldbytelen = this.bindIndicators[bytePitchOffset];
                    int oldcharlen = this.bindIndicators[charPitchOffset];
                    int ind_offset = (this.bindIndicators[metadata_offset + 5] << 16) + (this.bindIndicators[metadata_offset + 6] & 0xFFFF);
                    boolean bl = wasLastBindNull = this.bindIndicators[ind_offset] == -1;
                    if (wasLastBindNull && bytelen > 1) {
                        this.preparedByteBinds = true;
                    }
                    if (oldbytelen >= bytelen && !this.preparedByteBinds) {
                        this.currentBatchByteLens[bindPos] = oldbytelen;
                        row_bytelen += oldbytelen;
                    } else {
                        this.bindIndicators[bytePitchOffset] = (short)bytelen;
                        row_bytelen += bytelen;
                        this.preparedByteBinds = true;
                    }
                    if (wasLastBindNull && charlen > 1) {
                        this.preparedCharBinds = true;
                    }
                    if (oldcharlen >= charlen && !this.preparedCharBinds) {
                        this.currentBatchCharLens[bindPos] = oldcharlen;
                        row_charlen += oldcharlen;
                    } else {
                        this.bindIndicators[charPitchOffset] = (short)charlen;
                        row_charlen += charlen;
                        this.preparedCharBinds = true;
                    }
                    metadata_offset += 10;
                }
            }
            if (this.preparedByteBinds | this.preparedCharBinds) {
                this.initializeBindSubRanges(this.numberOfBoundRows, number_of_rows_to_be_set_up);
            }
            if (this.preparedByteBinds) {
                int total_bytelen = this.bindByteSubRange + row_bytelen * number_of_rows_to_be_set_up;
                if (this.lastBoundNeeded || total_bytelen > this.totalBindByteLength) {
                    this.bindByteOffset = 0;
                    this.bindBytes = this.connection.getByteBuffer(total_bytelen);
                    this.totalBindByteLength = total_bytelen;
                }
                this.bindBufferCapacity = number_of_rows_to_be_set_up;
                this.bindIndicators[this.bindIndicatorSubRange + 1] = (short)((this.bindBufferCapacity & 0xFFFF0000) >> 16);
                this.bindIndicators[this.bindIndicatorSubRange + 2] = (short)(this.bindBufferCapacity & 0xFFFF);
            }
            if (this.preparedCharBinds) {
                int total_charlen = this.bindCharSubRange + row_charlen * this.bindBufferCapacity;
                if (this.lastBoundNeeded || total_charlen > this.totalBindCharLength) {
                    this.bindCharOffset = 0;
                    this.bindChars = this.connection.getCharBuffer(total_charlen);
                    this.totalBindCharLength = total_charlen;
                }
                this.bindByteSubRange += this.bindByteOffset;
                this.bindCharSubRange += this.bindCharOffset;
            }
            int byteoffset = this.bindByteSubRange;
            int charoffset = this.bindCharSubRange;
            int indoffset = this.indicatorsOffset;
            int lenoffset = this.valueLengthsOffset;
            metadata_offset = per_position_metadata_offset;
            if (this.preparedByteBinds | this.preparedCharBinds) {
                int valueoffset;
                int bytelen;
                int bindPos;
                if (this.currentBatchBindAccessors == null) {
                    for (bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                        bytelen = this.currentBatchByteLens[bindPos];
                        int charlen = this.currentBatchCharLens[bindPos];
                        valueoffset = charlen == 0 ? byteoffset : charoffset;
                        this.bindIndicators[metadata_offset + 3] = (short)(valueoffset >> 16);
                        this.bindIndicators[metadata_offset + 4] = (short)(valueoffset & 0xFFFF);
                        byteoffset += bytelen * this.bindBufferCapacity;
                        charoffset += charlen * this.bindBufferCapacity;
                        metadata_offset += 10;
                    }
                } else {
                    for (bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                        bytelen = this.currentBatchByteLens[bindPos];
                        int charlen = this.currentBatchCharLens[bindPos];
                        valueoffset = charlen == 0 ? byteoffset : charoffset;
                        this.bindIndicators[metadata_offset + 3] = (short)(valueoffset >> 16);
                        this.bindIndicators[metadata_offset + 4] = (short)(valueoffset & 0xFFFF);
                        Accessor accessor = this.currentBatchBindAccessors[bindPos];
                        if (accessor != null) {
                            if (charlen > 0) {
                                accessor.columnDataOffset = charoffset;
                                accessor.charLength = charlen;
                            } else {
                                accessor.columnDataOffset = byteoffset;
                                accessor.byteLength = bytelen;
                            }
                            accessor.lengthIndex = lenoffset;
                            accessor.indicatorIndex = indoffset;
                            accessor.rowSpaceIndicator = this.bindIndicators;
                            accessor.setCapacity(this.bindBufferCapacity);
                        }
                        byteoffset += bytelen * this.bindBufferCapacity;
                        charoffset += charlen * this.bindBufferCapacity;
                        indoffset += this.numberOfBindRowsAllocated;
                        lenoffset += this.numberOfBindRowsAllocated;
                        metadata_offset += 10;
                    }
                }
                byteoffset = this.bindByteSubRange;
                charoffset = this.bindCharSubRange;
                indoffset = this.indicatorsOffset;
                lenoffset = this.valueLengthsOffset;
                metadata_offset = per_position_metadata_offset;
            }
            int unused_rows = this.bindBufferCapacity - this.numberOfBoundRows;
            int lastrow_in_buffers = this.numberOfBoundRows - 1;
            int lastrow_in_binders = lastrow_in_buffers + first_row_to_be_bound;
            Binder[] lastRowBinders = this.binders[lastrow_in_binders];
            if (this.hasIbtBind) {
                this.processPlsqlIndexTabBinds(first_row_to_be_bound);
            }
            if (this.numReturnParams > 0) {
                this.requireDmlReturningRegistration();
                this.initializeAutoKeyInfo();
                this.processDmlReturningBind();
            }
            boolean clearPriorBindValues = !this.sqlKind.isPlsqlOrCall() || this.currentRowBindAccessors == null;
            this.localCheckSum = this.checkSum;
            for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                int bytelen = this.currentBatchByteLens[bindPos];
                int charlen = this.currentBatchCharLens[bindPos];
                short formOfUse = this.currentBatchFormOfUse[bindPos];
                this.lastBinders[bindPos] = lastRowBinders[bindPos];
                this.lastBoundByteLens[bindPos] = bytelen;
                for (int rowInBuffers = 0; rowInBuffers < this.numberOfBoundRows; ++rowInBuffers) {
                    int rowInBinders = first_row_to_be_bound + rowInBuffers;
                    int bindDataIndex = rowInBuffers * this.numberOfBindPositions + bindPos;
                    this.localCheckSum = this.binders[rowInBinders][bindPos].bind(this, bindPos, rowInBuffers, rowInBinders, this.bindBytes, this.bindChars, this.bindIndicators, bytelen, charlen, byteoffset, charoffset, lenoffset + rowInBuffers, indoffset + rowInBuffers, clearPriorBindValues, this.localCheckSum, this.bindData, this.bindDataOffsets, this.bindDataLengths, bindDataIndex, this.bindUseDBA, formOfUse);
                    if (this.userStream != null) {
                        this.userStream[rowInBuffers][bindPos] = null;
                    }
                    byteoffset += bytelen;
                    charoffset += charlen;
                    continue;
                }
                if (this.bindChecksumListener != null) {
                    boolean contFlag = this.bindChecksumListener.shouldContinue(this.checkSum);
                    this.bindChecksumListener = null;
                    if (!contFlag) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 290).fillInStackTrace();
                    }
                }
                this.lastBoundByteOffsets[bindPos] = byteoffset - bytelen;
                this.lastBoundCharOffsets[bindPos] = charoffset - charlen;
                this.lastBoundInds[bindPos] = this.bindIndicators[indoffset + lastrow_in_buffers];
                this.lastBoundLens[bindPos] = this.bindIndicators[lenoffset + lastrow_in_buffers];
                this.lastBoundByteLens[bindPos] = 0;
                this.lastBoundCharLens[bindPos] = 0;
                byteoffset += unused_rows * bytelen;
                charoffset += unused_rows * charlen;
                indoffset += this.numberOfBindRowsAllocated;
                lenoffset += this.numberOfBindRowsAllocated;
                metadata_offset += 10;
            }
            this.checkSum = this.localCheckSum;
            this.lastBoundBytes = this.bindBytes;
            this.lastBoundByteOffset = this.bindByteOffset;
            this.lastBoundChars = this.bindChars;
            this.lastBoundCharOffset = this.bindCharOffset;
            if (this.parameterStream != null) {
                this.lastBoundStream = this.parameterStream[first_row_to_be_bound + this.numberOfBoundRows - 1];
            }
            int[] tmpByteLens = this.currentBatchByteLens;
            this.currentBatchByteLens = this.lastBoundByteLens;
            this.lastBoundByteLens = tmpByteLens;
            int[] tmpCharLens = this.currentBatchCharLens;
            this.currentBatchCharLens = this.lastBoundCharLens;
            this.lastBoundCharLens = tmpCharLens;
            this.lastBoundNeeded = false;
            this.prepareBindPreambles(this.numberOfBoundRows, this.bindBufferCapacity);
            this.configureBindData();
            this.checkSum = this.localCheckSum;
            this.localCheckSum = 0L;
        }
        catch (NullPointerException e) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, null, (Throwable)e).fillInStackTrace();
        }
    }

    @Override
    void onBindTypeChange() {
        this.needToParse = true;
    }

    @Override
    void registerOutParameterInternal(int paramIndex, int external_type, int scale, int maxLength, String sqlName) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(3).fillInStackTrace();
        }
        int internal_type = this.getInternalType(external_type);
        if (internal_type == 995) {
            throw (SQLException)DatabaseError.createSqlException(4).fillInStackTrace();
        }
        this.currentRowNeedToPrepareBinds = true;
        if (this.currentRowBindAccessors == null) {
            this.currentRowBindAccessors = new Accessor[this.numberOfBindPositions];
        }
        switch (external_type) {
            case -4: 
            case -3: 
            case -1: 
            case 1: 
            case 12: 
            case 70: {
                break;
            }
            case -16: 
            case -15: 
            case -9: {
                this.currentRowFormOfUse[index] = 2;
                break;
            }
            case 2011: {
                maxLength = 0;
                this.currentRowFormOfUse[index] = 2;
                break;
            }
            case 2009: {
                maxLength = 0;
                sqlName = "SYS.XMLTYPE";
                break;
            }
            case 2002: 
            case 2003: {
                if (sqlName == null || sqlName.length() == 0) {
                    throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                }
                maxLength = 0;
                break;
            }
            default: {
                maxLength = 0;
            }
        }
        this.currentRowBindAccessors[index] = this.allocateAccessor(internal_type, external_type, paramIndex, maxLength, this.currentRowFormOfUse[index], sqlName, true);
        this.currentRowBindAccessors[index].setCapacity(1);
    }

    @Override
    Accessor allocateIndexTableAccessor(PlsqlIbtBindInfo ibtBindInfo, short form) throws SQLException {
        return new T2CPlsqlIndexTableAccessor(this, ibtBindInfo, form);
    }
}

