/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import oracle.jdbc.OracleHostnameResolver;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.net.jdbc.TNSAddress.Address;
import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.nt.ConnectDescription;
import oracle.net.resolver.InetAddressResolver;
import oracle.net.resolver.NavSchemaObject;

public class NavAddress
extends Address
implements NavSchemaObject {
    final NVNavigator nav = new NVNavigator();

    public NavAddress(SchemaObjectFactoryInterface fac) {
        super(fac);
    }

    @Override
    public void navigate(ConnStrategy cs, StringBuffer sBuf) throws NetException {
        boolean needToCloseDescription = false;
        if (cs.currentDescription() == null) {
            cs.newConnectDescription();
            needToCloseDescription = true;
        }
        try {
            this.parseAddressParamsAndNavigate(cs.getHostnameResolver(), cs, sBuf);
        }
        catch (NetException e) {
            throw e;
        }
        catch (NLException e) {
            throw new NetException(18951);
        }
        if (needToCloseDescription) {
            cs.closeDescription();
        }
    }

    @Override
    public void addToString(ConnStrategy cs) {
        String NVString = this.toString();
        ArrayList<ConnOption> cOpts = cs.currentDescription().getConnectOptions();
        for (ConnOption co : cOpts) {
            if (co.done) continue;
            co.conn_data.append(NVString);
        }
    }

    private void parseAddressParamsAndNavigate(OracleHostnameResolver hostnameResolver, ConnStrategy cs, StringBuffer sBuf) throws NLException, NetException {
        NVPair nvpWebSockUri;
        int port;
        String webSocketURI = null;
        NVPair nvpAddr = new NVFactory().createNVPair(this.addr);
        NVPair nvpProt = this.nav.findNVPair(nvpAddr, "PROTOCOL");
        if (nvpProt == null) {
            throw new NLException("NoNVPair-04614", "PROTOCOL");
        }
        String protocol = nvpProt.getAtom();
        NVPair nvpHost = this.nav.findNVPair(nvpAddr, "HOST");
        if (nvpHost == null) {
            throw new NLException("NoNVPair-04614", "HOST");
        }
        String host = nvpHost.getAtom();
        NVPair nvpPort = this.nav.findNVPair(nvpAddr, "PORT");
        if (nvpPort != null) {
            try {
                port = Integer.parseInt(nvpPort.getAtom());
            }
            catch (Exception e) {
                throw (NLException)new NLException(new NetException(17866).getMessage()).initCause(e);
            }
        } else {
            port = 1521;
        }
        if (port < 0 || port > 65535) {
            throw new NLException(new NetException(17866).getMessage());
        }
        if ("WSS".equalsIgnoreCase(protocol) && (nvpWebSockUri = this.nav.findNVPair(nvpAddr, "WEBSOCK_URI")) != null) {
            webSocketURI = nvpWebSockUri.getAtom();
        }
        this.readHttpsProxyConfigFromAddress(cs, nvpAddr);
        try {
            Iterator<InetSocketAddress> resolvedSocketAddresses = InetAddressResolver.resolveInetSocketAddresses(host, port, hostnameResolver, cs.socketOptions, protocol, this.addr);
            while (resolvedSocketAddresses.hasNext()) {
                InetSocketAddress socketAddr = resolvedSocketAddresses.next();
                ConnOption co = new ConnOption();
                co.addr = String.format("(ADDRESS=(PROTOCOL=%s)(HOST=%s)(PORT=%s))", protocol, socketAddr.getHostString(), port);
                co.host = host;
                co.port = port;
                co.protocol = protocol;
                co.httpsProxy = this.httpsProxy;
                co.httpsProxyPort = this.httpsProxyPort;
                co.inetSocketAddress = socketAddr;
                co.webSocketUri = webSocketURI;
                co.conn_data.append(sBuf.toString());
                co.conn_data.append(this.toString());
                CommonDiagnosable.getInstance().trace(Level.CONFIG, SecurityLabel.CONFIG, this.getClass().getName(), "parseAddressParams", "New conn option created using IP={0} from host={1} after hostname resolution", null, null, socketAddr.getAddress(), host);
                cs.currentDescription().addConnectOption(co);
            }
        }
        catch (UnknownHostException e) {
            throw new NetException(17868, e.getMessage());
        }
    }

    private void readHttpsProxyConfigFromAddress(ConnStrategy cs, NVPair nvpAddr) {
        ConnectDescription desc = cs.currentDescription();
        NVPair nvpHttpProxy = this.nav.findNVPair(nvpAddr, "HTTPS_PROXY");
        NVPair nvpHttpProxyPort = this.nav.findNVPair(nvpAddr, "HTTPS_PROXY_PORT");
        this.httpsProxy = nvpHttpProxy != null ? nvpHttpProxy.getAtom() : desc.getHttpsProxy();
        if (this.httpsProxy != null) {
            this.httpsProxyPort = nvpHttpProxyPort != null ? Integer.parseInt(nvpHttpProxyPort.getAtom()) : desc.getHttpsProxyPort();
        }
    }
}

