/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.txoj.abstractrecords;

import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.internal.txoj.abstractrecords.CadaverLockManager;
import com.arjuna.ats.internal.txoj.abstractrecords.LockRecord;
import com.arjuna.ats.txoj.LockManager;
import com.arjuna.ats.txoj.lockstore.LockStore;
import com.arjuna.ats.txoj.logging.txojLogger;
import java.io.PrintWriter;

public class CadaverLockRecord
extends LockRecord {
    private LockStore cadaverLockStore;
    private String objectTypeName;
    private boolean doRelease;

    public CadaverLockRecord(LockStore store, LockManager lm, BasicAction currAct) {
        super(lm, currAct);
        this.cadaverLockStore = store;
        this.objectTypeName = new String(lm.type());
        this.doRelease = lm.getObjectModel() != 0;
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("CadaverLockRecord::CadaverLockRecord(" + store + ", " + lm.get_uid() + ")"));
        }
    }

    @Override
    public boolean propagateOnAbort() {
        return true;
    }

    @Override
    public int nestedAbort() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("CadaverLockRecord::nestedAbort() for " + this.order()));
        }
        if (this.doRelease) {
            CadaverLockManager manager = new CadaverLockManager(this.order(), this.objectTypeName);
            if (this.actionHandle == null) {
                throw new FatalError(txojLogger.i18NLogger.get_CadaverLockRecord_1());
            }
            return manager.releaseAll(this.actionHandle.get_uid()) ? 7 : 8;
        }
        return 7;
    }

    @Override
    public int nestedCommit() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("CadaverLockRecord::nestedCommit() for " + this.order()));
        }
        if (this.doRelease) {
            if (this.actionHandle == null) {
                throw new FatalError(txojLogger.i18NLogger.get_CadaverLockRecord_2());
            }
            CadaverLockManager manager = new CadaverLockManager(this.order(), this.objectTypeName);
            return manager.propagate(this.actionHandle.get_uid(), this.actionHandle.parent().get_uid()) ? 7 : 8;
        }
        return 7;
    }

    @Override
    public int topLevelAbort() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("CadaverLockRecord::topLevelAbort() for " + this.order()));
        }
        if (this.doRelease) {
            if (this.actionHandle == null) {
                throw new FatalError(txojLogger.i18NLogger.get_CadaverLockRecord_3());
            }
            CadaverLockManager manager = new CadaverLockManager(this.order(), this.objectTypeName);
            return manager.releaseAll(this.actionHandle.get_uid()) ? 7 : 8;
        }
        return 7;
    }

    @Override
    public int topLevelCommit() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("CadaverLockRecord::topLevelCommit() for " + this.order()));
        }
        if (this.doRelease) {
            if (this.actionHandle == null) {
                throw new FatalError(txojLogger.i18NLogger.get_CadaverLockRecord_4());
            }
            CadaverLockManager manager = new CadaverLockManager(this.order(), this.objectTypeName);
            return manager.releaseAll(this.actionHandle.get_uid()) ? 7 : 8;
        }
        return 7;
    }

    @Override
    public void print(PrintWriter strm) {
        strm.println("CadaverLockRecord : ");
        super.print(strm);
    }

    @Override
    public String type() {
        return "/StateManager/AbstractRecord/LockRecord/CadaverLockRecord";
    }

    @Override
    public boolean shouldReplace(AbstractRecord ar) {
        return this.order().equals(ar.order()) && ar.typeIs() == 121;
    }

    @Override
    public void replace(AbstractRecord ar) {
        LockRecord lr = (LockRecord)ar;
        this.objectTypeName = lr.lockType();
    }

    protected CadaverLockRecord() {
        this.cadaverLockStore = null;
        this.objectTypeName = null;
        this.doRelease = false;
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)"CadaverLockRecord::CadaverLockRecord ()");
        }
    }
}

