/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hibernate.HibernateError;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class OracleJdbcHelper {
    public static boolean isUsable(ServiceRegistry serviceRegistry) {
        ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        try {
            classLoaderService.classForName("oracle.jdbc.OracleConnection");
            return true;
        }
        catch (ClassLoadingException ex) {
            return false;
        }
    }

    public static JdbcType getArrayJdbcType(ServiceRegistry serviceRegistry) {
        return OracleJdbcHelper.createJdbcType(serviceRegistry, "org.hibernate.dialect.OracleArrayJdbcType");
    }

    public static JdbcType getStructJdbcType(ServiceRegistry serviceRegistry) {
        return OracleJdbcHelper.createJdbcType(serviceRegistry, "org.hibernate.dialect.OracleStructJdbcType");
    }

    public static JdbcType createJdbcType(ServiceRegistry serviceRegistry, String className) {
        ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        try {
            Class clazz = classLoaderService.classForName(className);
            Constructor constructor = clazz.getConstructor(new Class[0]);
            return (JdbcType)constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new HibernateError("Class does not have an empty constructor", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new HibernateError("Could not construct JdbcType", e);
        }
    }
}

