/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.storage.database.jpa;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.hibernate.orm.PersistenceUnit;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.SynchronizationType;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import org.hibernate.internal.SessionFactoryImpl;
import org.keycloak.Config;
import org.keycloak.connections.jpa.JpaConnectionProviderFactory;
import org.keycloak.connections.jpa.PersistenceExceptionConverter;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.quarkus.runtime.configuration.Configuration;

public abstract class AbstractJpaConnectionProviderFactory
implements JpaConnectionProviderFactory {
    protected Config.Scope config;
    protected EntityManagerFactory entityManagerFactory;

    public Connection getConnection() {
        SessionFactoryImpl entityManagerFactory = (SessionFactoryImpl)this.entityManagerFactory.unwrap(SessionFactoryImpl.class);
        try {
            return entityManagerFactory.getJdbcServices().getBootstrapJdbcConnectionAccess().obtainConnection();
        }
        catch (SQLException cause) {
            throw new RuntimeException("Failed to obtain JDBC connection", cause);
        }
    }

    public String getSchema() {
        return Configuration.getRawValue("kc.db-schema");
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
        this.entityManagerFactory = this.getEntityManagerFactory();
    }

    public void close() {
        if (this.entityManagerFactory != null) {
            this.entityManagerFactory.close();
        }
    }

    protected abstract EntityManagerFactory getEntityManagerFactory();

    protected Optional<EntityManagerFactory> getEntityManagerFactory(final String unitName) {
        InjectableInstance instance = Arc.container().select(EntityManagerFactory.class, new Annotation[]{new PersistenceUnit(){

            public Class<? extends Annotation> annotationType() {
                return PersistenceUnit.class;
            }

            public String value() {
                return unitName;
            }
        }});
        if (instance.isResolvable()) {
            return Optional.of((EntityManagerFactory)instance.get());
        }
        return Optional.empty();
    }

    protected EntityManager createEntityManager(EntityManagerFactory emf, KeycloakSession session) {
        EntityManager entityManager = PersistenceExceptionConverter.create((KeycloakSession)session, (EntityManager)emf.createEntityManager(SynchronizationType.SYNCHRONIZED));
        entityManager.setFlushMode(FlushModeType.AUTO);
        return entityManager;
    }
}

