/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.List;
import org.infinispan.distribution.Ownership;
import org.infinispan.remoting.transport.Address;

public class DistributionInfo {
    private final int segmentId;
    private final Address primary;
    private final List<Address> readOwners;
    private final List<Address> writeOwners;
    private final Collection<Address> writeBackups;
    private final boolean isPrimary;
    private final boolean isReadOwner;
    private final boolean isWriteOwner;
    private final boolean isWriteBackup;

    public DistributionInfo(int segmentId, Address primary, List<Address> readOwners, List<Address> writeOwners, Collection<Address> writeBackups, Address localAddress) {
        this.segmentId = segmentId;
        this.primary = primary;
        this.readOwners = readOwners;
        this.writeOwners = writeOwners;
        this.writeBackups = writeBackups;
        this.isPrimary = primary != null && primary.equals(localAddress);
        this.isReadOwner = readOwners.contains(localAddress);
        this.isWriteOwner = writeOwners.contains(localAddress);
        this.isWriteBackup = this.isWriteOwner && !this.isPrimary;
    }

    public int segmentId() {
        return this.segmentId;
    }

    public Address primary() {
        return this.primary;
    }

    public List<Address> readOwners() {
        return this.readOwners;
    }

    public List<Address> writeOwners() {
        return this.writeOwners;
    }

    public Collection<Address> writeBackups() {
        return this.writeBackups;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public boolean isReadOwner() {
        return this.isReadOwner;
    }

    public boolean isWriteOwner() {
        return this.isWriteOwner;
    }

    public boolean isWriteBackup() {
        return this.isWriteBackup;
    }

    public Ownership readOwnership() {
        return this.isPrimary ? Ownership.PRIMARY : (this.isReadOwner ? Ownership.BACKUP : Ownership.NON_OWNER);
    }

    public Ownership writeOwnership() {
        return this.isPrimary ? Ownership.PRIMARY : (this.isWriteOwner ? Ownership.BACKUP : Ownership.NON_OWNER);
    }

    public String toString() {
        return "DistributionInfo{" + (this.isPrimary ? "primary, " : (this.isReadOwner ? "read+write, " : (this.isWriteBackup ? "write-only, " : ""))) + "segmentId=" + this.segmentId + ", readOwners=" + this.readOwners + ", writeOwners=" + this.writeOwners + "}";
    }
}

