/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.deployment;

import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.agroal.spi.JdbcDriverBuildItem;
import io.quarkus.arc.deployment.BuildTimeConditionBuildItem;
import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceResultBuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BootstrapConfigSetupCompleteBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.StaticInitConfigSourceProviderBuildItem;
import io.quarkus.hibernate.orm.deployment.AdditionalJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import io.quarkus.hibernate.orm.deployment.PersistenceXmlDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.resteasy.server.common.deployment.ResteasyDeploymentCustomizerBuildItem;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.smallrye.config.ConfigValue;
import jakarta.persistence.Entity;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Handler;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.internal.PersistenceXmlParser;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticatorSpi;
import org.keycloak.authentication.authenticators.browser.DeployedScriptAuthenticatorFactory;
import org.keycloak.authorization.policy.provider.PolicySpi;
import org.keycloak.authorization.policy.provider.js.DeployedScriptPolicyFactory;
import org.keycloak.common.Profile;
import org.keycloak.common.crypto.FipsMode;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.config.DatabaseOptions;
import org.keycloak.config.SecurityOptions;
import org.keycloak.config.StorageOptions;
import org.keycloak.connections.jpa.DefaultJpaConnectionProviderFactory;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.connections.jpa.JpaConnectionSpi;
import org.keycloak.connections.jpa.updater.liquibase.LiquibaseJpaUpdaterProviderFactory;
import org.keycloak.connections.jpa.updater.liquibase.conn.DefaultLiquibaseConnectionProvider;
import org.keycloak.connections.jpa.util.JpaUtils;
import org.keycloak.models.map.storage.jpa.JpaMapStorageProviderFactory;
import org.keycloak.policy.BlacklistPasswordPolicyProviderFactory;
import org.keycloak.protocol.ProtocolMapperSpi;
import org.keycloak.protocol.oidc.mappers.DeployedScriptOIDCProtocolMapper;
import org.keycloak.protocol.saml.mappers.DeployedScriptSAMLProtocolMapper;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ProviderManager;
import org.keycloak.provider.Spi;
import org.keycloak.quarkus.deployment.CheckJdbcBuildStep;
import org.keycloak.quarkus.deployment.ConfigBuildItem;
import org.keycloak.quarkus.deployment.CryptoProviderInitBuildItem;
import org.keycloak.quarkus.deployment.IsIntegrationTest;
import org.keycloak.quarkus.deployment.IsJpaStoreEnabled;
import org.keycloak.quarkus.deployment.IsLegacyStoreEnabled;
import org.keycloak.quarkus.deployment.IsReAugmentation;
import org.keycloak.quarkus.deployment.KeycloakSessionFactoryPreInitBuildItem;
import org.keycloak.quarkus.deployment.ProfileBuildItem;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.KeycloakRecorder;
import org.keycloak.quarkus.runtime.Providers;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.KeycloakConfigSourceProvider;
import org.keycloak.quarkus.runtime.configuration.MicroProfileConfigProvider;
import org.keycloak.quarkus.runtime.configuration.QuarkusPropertiesConfigSource;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import org.keycloak.quarkus.runtime.integration.health.ReactiveLivenessHandler;
import org.keycloak.quarkus.runtime.integration.jaxrs.QuarkusKeycloakApplication;
import org.keycloak.quarkus.runtime.integration.web.NotFoundHandler;
import org.keycloak.quarkus.runtime.services.health.KeycloakReadyHealthCheck;
import org.keycloak.quarkus.runtime.storage.database.jpa.NamedJpaConnectionProviderFactory;
import org.keycloak.quarkus.runtime.themes.FlatClasspathThemeResourceProviderFactory;
import org.keycloak.representations.provider.ScriptProviderDescriptor;
import org.keycloak.representations.provider.ScriptProviderMetadata;
import org.keycloak.services.ServicesLogger;
import org.keycloak.theme.ClasspathThemeProviderFactory;
import org.keycloak.theme.ClasspathThemeResourceProviderFactory;
import org.keycloak.theme.FolderThemeProviderFactory;
import org.keycloak.theme.JarThemeProviderFactory;
import org.keycloak.theme.ThemeResourceSpi;
import org.keycloak.transaction.JBossJtaTransactionManagerLookup;
import org.keycloak.url.DefaultHostnameProviderFactory;
import org.keycloak.url.FixedHostnameProviderFactory;
import org.keycloak.url.RequestHostnameProviderFactory;
import org.keycloak.util.JsonSerialization;
import org.keycloak.vault.FilesKeystoreVaultProviderFactory;
import org.keycloak.vault.FilesPlainTextVaultProviderFactory;

class KeycloakProcessor {
    private static final Logger logger = Logger.getLogger(KeycloakProcessor.class);
    private static final String JAR_FILE_SEPARATOR = "!/";
    private static final Map<String, Function<ScriptProviderMetadata, ProviderFactory>> DEPLOYEABLE_SCRIPT_PROVIDERS = new HashMap<String, Function<ScriptProviderMetadata, ProviderFactory>>();
    private static final String KEYCLOAK_SCRIPTS_JSON_PATH = "META-INF/keycloak-scripts.json";
    private static final List<Class<? extends ProviderFactory>> IGNORED_PROVIDER_FACTORY = List.of(JBossJtaTransactionManagerLookup.class, DefaultJpaConnectionProviderFactory.class, DefaultLiquibaseConnectionProvider.class, FolderThemeProviderFactory.class, LiquibaseJpaUpdaterProviderFactory.class, DefaultHostnameProviderFactory.class, FixedHostnameProviderFactory.class, RequestHostnameProviderFactory.class, FilesKeystoreVaultProviderFactory.class, FilesPlainTextVaultProviderFactory.class, BlacklistPasswordPolicyProviderFactory.class, ClasspathThemeResourceProviderFactory.class, JarThemeProviderFactory.class, JpaMapStorageProviderFactory.class);
    public static final String QUARKUS_HEALTH_ROOT_PROPERTY = "quarkus.smallrye-health.root-path";
    public static final String QUARKUS_METRICS_PATH_PROPERTY = "quarkus.micrometer.export.prometheus.path";
    public static final String QUARKUS_DEFAULT_HEALTH_PATH = "health";
    public static final String QUARKUS_DEFAULT_METRICS_PATH = "metrics";

    KeycloakProcessor() {
    }

    private static ProviderFactory registerScriptAuthenticator(ScriptProviderMetadata metadata) {
        return new DeployedScriptAuthenticatorFactory(metadata);
    }

    private static ProviderFactory registerScriptPolicy(ScriptProviderMetadata metadata) {
        return new DeployedScriptPolicyFactory(metadata);
    }

    private static ProviderFactory registerScriptMapper(ScriptProviderMetadata metadata) {
        return new DeployedScriptOIDCProtocolMapper(metadata);
    }

    private static ProviderFactory registerSAMLScriptMapper(ScriptProviderMetadata metadata) {
        return new DeployedScriptSAMLProtocolMapper(metadata);
    }

    @BuildStep
    FeatureBuildItem getFeature() {
        return new FeatureBuildItem("keycloak");
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    ConfigBuildItem initConfig(KeycloakRecorder recorder) {
        Config.init((Config.ConfigProvider)new MicroProfileConfigProvider());
        recorder.initConfig();
        return new ConfigBuildItem();
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    @Consume(value=ConfigBuildItem.class)
    ProfileBuildItem configureProfile(KeycloakRecorder recorder) {
        Profile profile = Environment.getCurrentOrCreateFeatureProfile();
        recorder.configureProfile(profile.getName(), profile.getFeatures());
        return new ProfileBuildItem();
    }

    @BuildStep(onlyIf={IsJpaStoreEnabled.class})
    @Produce(value=CheckJdbcBuildStep.class)
    void checkJdbcDriver(BuildProducer<JdbcDriverBuildItem> ignore) {
        Optional dbDriver = Configuration.getOptionalValue((String)"quarkus.datasource.jdbc.driver");
        if (dbDriver.isPresent()) {
            try {
                Class.forName((String)dbDriver.get(), false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                InitialConfigurator.DELAYED_HANDLER.setBuildTimeHandlers(new Handler[0]);
                throw new ConfigurationException(String.format("Unable to find the JDBC driver (%s). You need to install it.", dbDriver.get()));
            }
        }
    }

    @BuildStep(onlyIf={IsJpaStoreEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void configurePersistenceUnits(HibernateOrmConfig config, List<PersistenceXmlDescriptorBuildItem> descriptors, List<JdbcDataSourceBuildItem> jdbcDataSources, BuildProducer<AdditionalJpaModelBuildItem> additionalJpaModel, CombinedIndexBuildItem indexBuildItem, BuildProducer<HibernateOrmIntegrationRuntimeConfiguredBuildItem> runtimeConfigured, KeycloakRecorder recorder) {
        ParsedPersistenceXmlDescriptor defaultUnitDescriptor = null;
        ArrayList<String> userManagedEntities = new ArrayList<String>();
        for (PersistenceXmlDescriptorBuildItem item : descriptors) {
            ParsedPersistenceXmlDescriptor descriptor = item.getDescriptor();
            if ("keycloak-default".equals(descriptor.getName())) {
                defaultUnitDescriptor = descriptor;
                this.configureDefaultPersistenceUnitProperties(defaultUnitDescriptor, config, KeycloakProcessor.getDefaultDataSource(jdbcDataSources));
                runtimeConfigured.produce((BuildItem)new HibernateOrmIntegrationRuntimeConfiguredBuildItem("keycloak", defaultUnitDescriptor.getName()).setInitListener(recorder.createDefaultUnitListener()));
                continue;
            }
            Properties properties = descriptor.getProperties();
            runtimeConfigured.produce((BuildItem)new HibernateOrmIntegrationRuntimeConfiguredBuildItem("keycloak", descriptor.getName()).setInitListener(recorder.createUserDefinedUnitListener(properties.getProperty("hibernate.connection.datasource"))));
            userManagedEntities.addAll(descriptor.getManagedClassNames());
        }
        if (defaultUnitDescriptor == null) {
            throw new RuntimeException("No default persistence unit found.");
        }
        this.configureDefaultPersistenceUnitEntities(defaultUnitDescriptor, indexBuildItem, userManagedEntities);
    }

    @BuildStep(onlyIf={IsJpaStoreEnabled.class})
    @Consume(value=CheckJdbcBuildStep.class)
    void produceDefaultPersistenceUnit(BuildProducer<PersistenceXmlDescriptorBuildItem> producer) {
        String storage = Configuration.getRawValue((String)"kc.".concat(StorageOptions.STORAGE.getKey()));
        ParsedPersistenceXmlDescriptor descriptor = storage == null ? PersistenceXmlParser.locateIndividualPersistenceUnit((URL)Thread.currentThread().getContextClassLoader().getResource("default-persistence.xml")) : PersistenceXmlParser.locateIndividualPersistenceUnit((URL)Thread.currentThread().getContextClassLoader().getResource("default-map-jpa-persistence.xml"));
        producer.produce((BuildItem)new PersistenceXmlDescriptorBuildItem(descriptor));
    }

    private void configureDefaultPersistenceUnitProperties(ParsedPersistenceXmlDescriptor descriptor, HibernateOrmConfig config, JdbcDataSourceBuildItem defaultDataSource) {
        if (defaultDataSource == null || !defaultDataSource.isDefault()) {
            throw new RuntimeException("The server datasource must be the default datasource.");
        }
        Properties unitProperties = descriptor.getProperties();
        Optional dialect = Configuration.getOptionalKcValue((String)DatabaseOptions.DB_DIALECT.getKey());
        dialect.ifPresent(d -> unitProperties.setProperty("hibernate.dialect", (String)d));
        Optional defaultSchema = Configuration.getOptionalKcValue((String)DatabaseOptions.DB_SCHEMA.getKey());
        defaultSchema.ifPresent(ds -> unitProperties.setProperty("hibernate.default_schema", (String)ds));
        unitProperties.setProperty("jakarta.persistence.transactionType", PersistenceUnitTransactionType.JTA.name());
        descriptor.setTransactionType(PersistenceUnitTransactionType.JTA);
        Optional lockTimeoutConfigValue = Configuration.getOptionalValue((String)"spi-map-storage-jpa-lock-timeout");
        lockTimeoutConfigValue.ifPresent(v -> unitProperties.setProperty("jakarta.persistence.lock.timeout", (String)v));
        unitProperties.setProperty("hibernate.query.startup_check", Boolean.FALSE.toString());
        String dbKind = defaultDataSource.getDbKind();
        for (Map.Entry<Object, Object> query : JpaUtils.loadSpecificNamedQueries((String)dbKind.toLowerCase()).entrySet()) {
            unitProperties.setProperty("kc.query." + query.getKey(), query.getValue().toString());
        }
    }

    private void configureDefaultPersistenceUnitEntities(ParsedPersistenceXmlDescriptor descriptor, CombinedIndexBuildItem indexBuildItem, List<String> userManagedEntities) {
        IndexView index = indexBuildItem.getIndex();
        Collection annotations = index.getAnnotations(DotName.createSimple((String)Entity.class.getName()));
        for (AnnotationInstance annotation : annotations) {
            AnnotationTarget target = annotation.target();
            String targetName = target.asClass().name().toString();
            if (userManagedEntities.contains(targetName) || targetName.startsWith("org.keycloak") && !targetName.startsWith("org.keycloak.testsuite")) continue;
            descriptor.addClasses(new String[]{targetName});
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    @Consume(value=CryptoProviderInitBuildItem.class)
    KeycloakSessionFactoryPreInitBuildItem configureKeycloakSessionFactory(KeycloakRecorder recorder, List<PersistenceXmlDescriptorBuildItem> descriptors) {
        HashMap<Spi, Map<Class<? extends Provider>, Map<String, Class<? extends ProviderFactory>>>> factories = new HashMap<Spi, Map<Class<? extends Provider>, Map<String, Class<? extends ProviderFactory>>>>();
        HashMap<Class<? extends Provider>, String> defaultProviders = new HashMap<Class<? extends Provider>, String>();
        HashMap<String, ProviderFactory> preConfiguredProviders = new HashMap<String, ProviderFactory>();
        for (Map.Entry<Spi, Map<Class<? extends Provider>, Map<String, ProviderFactory>>> entry : this.loadFactories(preConfiguredProviders).entrySet()) {
            Spi spi = entry.getKey();
            this.checkProviders(spi, entry.getValue(), defaultProviders);
            for (Map.Entry<Class<? extends Provider>, Map<String, ProviderFactory>> value : entry.getValue().entrySet()) {
                for (ProviderFactory factory : value.getValue().values()) {
                    factories.computeIfAbsent(spi, key -> new HashMap()).computeIfAbsent(spi.getProviderClass(), aClass -> new HashMap()).put(factory.getId(), factory.getClass());
                }
            }
            if (spi instanceof JpaConnectionSpi) {
                this.configureUserDefinedPersistenceUnits(descriptors, factories, preConfiguredProviders, spi);
            }
            if (!(spi instanceof ThemeResourceSpi)) continue;
            this.configureThemeResourceProviders(factories, spi);
        }
        recorder.configSessionFactory(factories, defaultProviders, preConfiguredProviders, this.loadThemesFromClassPath(), Environment.isRebuild().booleanValue());
        return new KeycloakSessionFactoryPreInitBuildItem();
    }

    private List<ClasspathThemeProviderFactory.ThemesRepresentation> loadThemesFromClassPath() {
        try {
            ArrayList<ClasspathThemeProviderFactory.ThemesRepresentation> themes = new ArrayList<ClasspathThemeProviderFactory.ThemesRepresentation>();
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("META-INF/keycloak-themes.json");
            while (resources.hasMoreElements()) {
                themes.add((ClasspathThemeProviderFactory.ThemesRepresentation)JsonSerialization.readValue((InputStream)resources.nextElement().openStream(), ClasspathThemeProviderFactory.ThemesRepresentation.class));
            }
            return themes;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load themes", e);
        }
    }

    private void configureThemeResourceProviders(Map<Spi, Map<Class<? extends Provider>, Map<String, Class<? extends ProviderFactory>>>> factories, Spi spi) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resources = classLoader.getResources("theme-resources");
            if (resources.hasMoreElements()) {
                factories.computeIfAbsent(spi, key -> new HashMap()).computeIfAbsent(spi.getProviderClass(), aClass -> new HashMap()).put("flat-classpath", FlatClasspathThemeResourceProviderFactory.class);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to install default theme resource provider", e);
        }
    }

    private void configureUserDefinedPersistenceUnits(List<PersistenceXmlDescriptorBuildItem> descriptors, final Map<Spi, Map<Class<? extends Provider>, Map<String, Class<? extends ProviderFactory>>>> factories, final Map<String, ProviderFactory> preConfiguredProviders, final Spi spi) {
        descriptors.stream().map(PersistenceXmlDescriptorBuildItem::getDescriptor).map(ParsedPersistenceXmlDescriptor::getName).filter(Predicate.not("keycloak-default"::equals)).forEach(new Consumer<String>(){

            @Override
            public void accept(String unitName) {
                NamedJpaConnectionProviderFactory factory = new NamedJpaConnectionProviderFactory();
                factory.setUnitName(unitName);
                ((Map)((Map)factories.get(spi)).get(JpaConnectionProvider.class)).put(unitName, NamedJpaConnectionProviderFactory.class);
                preConfiguredProviders.put(unitName, factory);
            }
        });
    }

    @BuildStep(onlyIfNot={IsIntegrationTest.class})
    void configureConfigSources(BuildProducer<StaticInitConfigSourceProviderBuildItem> configSources) {
        configSources.produce((BuildItem)new StaticInitConfigSourceProviderBuildItem(KeycloakConfigSourceProvider.class.getName()));
    }

    @BuildStep(onlyIf={IsIntegrationTest.class})
    void prepareTestEnvironment(BuildProducer<StaticInitConfigSourceProviderBuildItem> configSources, DevServicesDatasourceResultBuildItem dbConfig) {
        configSources.produce((BuildItem)new StaticInitConfigSourceProviderBuildItem("org.keycloak.quarkus.runtime.configuration.test.TestKeycloakConfigSourceProvider"));
        if (dbConfig != null && dbConfig.getDefaultDatasource() != null) {
            Map configProperties = dbConfig.getDefaultDatasource().getConfigProperties();
            for (Map.Entry dbConfigProperty : configProperties.entrySet()) {
                String kcProperty;
                PropertyMapper mapper = PropertyMappers.getMapper((String)((String)dbConfigProperty.getKey()));
                if (mapper == null || (kcProperty = mapper.getFrom()).endsWith("db")) continue;
                System.setProperty(kcProperty, (String)dbConfigProperty.getValue());
            }
        }
    }

    @BuildStep(onlyIf={IsReAugmentation.class})
    void persistBuildTimeProperties(BuildProducer<GeneratedResourceBuildItem> resources) {
        String profile;
        Properties properties = new Properties();
        this.putPersistedProperty(properties, "kc.db");
        for (String name : Configuration.getPropertyNames()) {
            this.putPersistedProperty(properties, name);
        }
        for (File jar : Environment.getProviderFiles().values()) {
            properties.put(String.format("kc.provider.file.%s.last-modified", jar.getName()), String.valueOf(jar.lastModified()));
        }
        if (!Environment.isRebuildCheck()) {
            Configuration.markAsOptimized((Properties)properties);
        }
        if ((profile = Environment.getProfile()) != null) {
            properties.put("kc.profile", profile);
            properties.put("quarkus.profile", profile);
        }
        properties.put("kc.quarkus-properties-enabled", String.valueOf(QuarkusPropertiesConfigSource.getConfigurationFile() != null));
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            properties.store(outputStream, " Auto-generated, DO NOT change this file");
            resources.produce((BuildItem)new GeneratedResourceBuildItem("META-INF/keycloak-persisted.properties", outputStream.toByteArray()));
        }
        catch (Exception cause) {
            throw new RuntimeException("Failed to persist configuration", cause);
        }
    }

    private void putPersistedProperty(Properties properties, String name) {
        PropertyMapper mapper = PropertyMappers.getMapper((String)name);
        ConfigValue value = null;
        if (mapper == null) {
            if (name.startsWith("quarkus") && !QuarkusPropertiesConfigSource.isSameSource((ConfigValue)(value = Configuration.getConfigValue((String)name)))) {
                return;
            }
        } else if (mapper.isBuildTime()) {
            name = mapper.getFrom();
            value = Configuration.getConfigValue((String)name);
        }
        if (value != null && value.getValue() != null) {
            if (value.getConfigSourceName() == null) {
                return;
            }
            String rawValue = value.getRawValue();
            if (rawValue == null) {
                rawValue = value.getValue();
            }
            properties.put(name, rawValue);
        }
    }

    @BuildStep
    void index(BuildProducer<IndexDependencyBuildItem> indexDependencyBuildItemBuildProducer) {
        indexDependencyBuildItemBuildProducer.produce((BuildItem)new IndexDependencyBuildItem("org.liquibase", "liquibase-core"));
        indexDependencyBuildItemBuildProducer.produce((BuildItem)new IndexDependencyBuildItem("org.keycloak", "keycloak-services"));
    }

    @BuildStep(onlyIf={IsJpaStoreEnabled.class}, onlyIfNot={IsLegacyStoreEnabled.class})
    @Consume(value=CheckJdbcBuildStep.class)
    void indexNewJpaStore(BuildProducer<IndexDependencyBuildItem> indexDependencyBuildItemBuildProducer) {
        indexDependencyBuildItemBuildProducer.produce((BuildItem)new IndexDependencyBuildItem("org.keycloak", "keycloak-model-map-jpa"));
    }

    @BuildStep(onlyIf={IsLegacyStoreEnabled.class})
    @Consume(value=CheckJdbcBuildStep.class)
    void indexLegacyJpaStore(BuildProducer<IndexDependencyBuildItem> indexDependencyBuildItemBuildProducer) {
        indexDependencyBuildItemBuildProducer.produce((BuildItem)new IndexDependencyBuildItem("org.keycloak", "keycloak-model-jpa"));
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void initializeFilter(BuildProducer<FilterBuildItem> filters, KeycloakRecorder recorder, ExecutorBuildItem executor, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem) {
        ArrayList<String> ignoredPaths = new ArrayList<String>();
        if (this.isHealthEnabled()) {
            ignoredPaths.add(nonApplicationRootPathBuildItem.resolvePath(Configuration.getOptionalValue((String)QUARKUS_HEALTH_ROOT_PROPERTY).orElse(QUARKUS_DEFAULT_HEALTH_PATH)));
        }
        if (this.isMetricsEnabled()) {
            ignoredPaths.add(nonApplicationRootPathBuildItem.resolvePath(Configuration.getOptionalValue((String)QUARKUS_METRICS_PATH_PROPERTY).orElse(QUARKUS_DEFAULT_METRICS_PATH)));
        }
        filters.produce((BuildItem)new FilterBuildItem((io.vertx.core.Handler)recorder.createRequestFilter(ignoredPaths, (ExecutorService)executor.getExecutorProxy()), 90));
    }

    @BuildStep
    void disableMetricsEndpoint(BuildProducer<RouteBuildItem> routes) {
        if (!this.isMetricsEnabled()) {
            routes.produce((BuildItem)RouteBuildItem.builder().route("/metrics".concat("/*")).handler((io.vertx.core.Handler)new NotFoundHandler()).build());
        }
    }

    @BuildStep
    void disableHealthEndpoint(BuildProducer<RouteBuildItem> routes, BuildProducer<BuildTimeConditionBuildItem> removeBeans, CombinedIndexBuildItem index) {
        boolean metricsDisabled;
        boolean healthDisabled;
        boolean bl = healthDisabled = !this.isHealthEnabled();
        if (healthDisabled) {
            routes.produce((BuildItem)RouteBuildItem.builder().route("/health".concat("/*")).handler((io.vertx.core.Handler)new NotFoundHandler()).build());
        } else if (!this.isHealthClassicProbesEnabled()) {
            routes.produce((BuildItem)RouteBuildItem.builder().route("/health".concat("/live")).handler((io.vertx.core.Handler)new ReactiveLivenessHandler()).build());
        }
        boolean bl2 = metricsDisabled = !this.isMetricsEnabled();
        if (healthDisabled || metricsDisabled) {
            ClassInfo disabledBean = index.getIndex().getClassByName(DotName.createSimple((String)KeycloakReadyHealthCheck.class.getName()));
            removeBeans.produce((BuildItem)new BuildTimeConditionBuildItem((AnnotationTarget)disabledBean.asClass(), false));
        }
    }

    @BuildStep
    void configureResteasy(BuildProducer<ResteasyDeploymentCustomizerBuildItem> deploymentCustomizerProducer) {
        deploymentCustomizerProducer.produce((BuildItem)new ResteasyDeploymentCustomizerBuildItem((Consumer)new Consumer<ResteasyDeployment>(){

            @Override
            public void accept(ResteasyDeployment resteasyDeployment) {
                resteasyDeployment.setApplicationClass(QuarkusKeycloakApplication.class.getName());
                resteasyDeployment.setProperty("resteasy.disable.html.sanitizer", (Object)Boolean.TRUE);
            }
        }));
    }

    @Consume.List(value={@Consume(value=BootstrapConfigSetupCompleteBuildItem.class), @Consume(value=ProfileBuildItem.class)})
    @Produce(value=CryptoProviderInitBuildItem.class)
    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setCryptoProvider(KeycloakRecorder recorder) {
        FipsMode fipsMode = Configuration.getOptionalValue((String)("kc." + SecurityOptions.FIPS_MODE.getKey())).map(FipsMode::valueOfOption).orElse(FipsMode.DISABLED);
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.FIPS) && !fipsMode.isFipsEnabled()) {
            fipsMode = FipsMode.NON_STRICT;
        } else if (fipsMode.isFipsEnabled() && !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.FIPS)) {
            throw new RuntimeException("FIPS mode cannot be enabled without enabling the FIPS feature --features=fips");
        }
        recorder.setCryptoProvider(fipsMode);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void configureDevMode(BuildProducer<HotDeploymentWatchedFileBuildItem> hotFiles) {
        hotFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem("META-INF/keycloak.conf"));
    }

    private Map<Spi, Map<Class<? extends Provider>, Map<String, ProviderFactory>>> loadFactories(Map<String, ProviderFactory> preConfiguredProviders) {
        Config.init((Config.ConfigProvider)new MicroProfileConfigProvider());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ProviderManager pm = Providers.getProviderManager((ClassLoader)classLoader);
        HashMap<Spi, Map<Class<? extends Provider>, Map<String, ProviderFactory>>> factories = new HashMap<Spi, Map<Class<? extends Provider>, Map<String, ProviderFactory>>>();
        for (Spi spi : pm.loadSpis()) {
            HashMap<Class, Map> providers = new HashMap<Class, Map>();
            ArrayList<ProviderFactory> loadedFactories = new ArrayList<ProviderFactory>();
            String provider = Config.getProvider((String)spi.getName());
            if (provider == null) {
                loadedFactories.addAll(pm.load(spi));
            } else {
                ProviderFactory factory = pm.load(spi, provider);
                if (factory != null) {
                    loadedFactories.add(factory);
                }
            }
            Map<String, ProviderFactory> deployedScriptProviders = this.loadDeployedScriptProviders(classLoader, spi);
            loadedFactories.addAll(deployedScriptProviders.values());
            preConfiguredProviders.putAll(deployedScriptProviders);
            for (ProviderFactory factory : loadedFactories) {
                if (IGNORED_PROVIDER_FACTORY.contains(factory.getClass())) continue;
                Config.Scope scope = Config.scope((String[])new String[]{spi.getName(), factory.getId()});
                if (this.isEnabled(factory, scope)) {
                    if (spi.isInternal() && !this.isInternal(factory)) {
                        ServicesLogger.LOGGER.spiMayChange(factory.getId(), factory.getClass().getName(), spi.getName());
                    }
                    providers.computeIfAbsent(spi.getProviderClass(), aClass -> new HashMap()).put(factory.getId(), factory);
                    continue;
                }
                logger.debugv("SPI {0} provider {1} disabled", (Object)spi.getName(), (Object)factory.getId());
            }
            factories.put(spi, providers);
        }
        return factories;
    }

    private Map<String, ProviderFactory> loadDeployedScriptProviders(ClassLoader classLoader, Spi spi) {
        HashMap<String, ProviderFactory> providers = new HashMap<String, ProviderFactory>();
        if (this.supportsDeployeableScripts(spi)) {
            try {
                Enumeration<URL> urls = classLoader.getResources(KEYCLOAK_SCRIPTS_JSON_PATH);
                while (urls.hasMoreElements()) {
                    ScriptProviderDescriptor descriptor;
                    URL url = urls.nextElement();
                    int fileSeparator = url.getFile().indexOf(JAR_FILE_SEPARATOR);
                    if (fileSeparator == -1) continue;
                    JarFile jarFile = new JarFile(url.getFile().substring("file:".length(), fileSeparator));
                    JarEntry descriptorEntry = jarFile.getJarEntry(KEYCLOAK_SCRIPTS_JSON_PATH);
                    try (InputStream is = jarFile.getInputStream(descriptorEntry);){
                        descriptor = (ScriptProviderDescriptor)JsonSerialization.readValue((InputStream)is, ScriptProviderDescriptor.class);
                    }
                    for (Map.Entry<String, List<ScriptProviderMetadata>> entry : descriptor.getProviders().entrySet()) {
                        if (!this.isScriptForSpi(spi, (String)entry.getKey())) continue;
                        for (ScriptProviderMetadata metadata : (List)entry.getValue()) {
                            ProviderFactory provider = this.createDeployableScriptProvider(jarFile, entry, metadata);
                            providers.put(metadata.getId(), provider);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to discover script providers", e);
            }
        }
        return providers;
    }

    private ProviderFactory createDeployableScriptProvider(JarFile jarFile, Map.Entry<String, List<ScriptProviderMetadata>> entry, ScriptProviderMetadata metadata) throws IOException {
        String fileName = metadata.getFileName();
        if (fileName == null) {
            throw new RuntimeException("You must provide the script file name");
        }
        JarEntry scriptFile = jarFile.getJarEntry(fileName);
        try (InputStream in = jarFile.getInputStream(scriptFile);){
            metadata.setCode(StreamUtil.readString((InputStream)in, (Charset)StandardCharsets.UTF_8));
        }
        metadata.setId("script" + "-" + fileName);
        String name = metadata.getName();
        if (name == null) {
            name = fileName;
        }
        metadata.setName(name);
        return DEPLOYEABLE_SCRIPT_PROVIDERS.get(entry.getKey()).apply(metadata);
    }

    private boolean isScriptForSpi(Spi spi, String type) {
        if (spi instanceof ProtocolMapperSpi && ("mappers".equals(type) || "saml-mappers".equals(type))) {
            return true;
        }
        if (spi instanceof PolicySpi && "policies".equals(type)) {
            return true;
        }
        return spi instanceof AuthenticatorSpi && "authenticators".equals(type);
    }

    private boolean supportsDeployeableScripts(Spi spi) {
        return spi instanceof ProtocolMapperSpi || spi instanceof PolicySpi || spi instanceof AuthenticatorSpi;
    }

    private boolean isEnabled(ProviderFactory factory, Config.Scope scope) {
        if (!scope.getBoolean("enabled", Boolean.valueOf(true)).booleanValue()) {
            return false;
        }
        if (factory instanceof EnvironmentDependentProviderFactory) {
            return ((EnvironmentDependentProviderFactory)factory).isSupported(scope);
        }
        return true;
    }

    private boolean isInternal(ProviderFactory<?> factory) {
        String packageName = factory.getClass().getPackage().getName();
        return packageName.startsWith("org.keycloak") && !packageName.startsWith("org.keycloak.examples");
    }

    private void checkProviders(Spi spi, Map<Class<? extends Provider>, Map<String, ProviderFactory>> factoriesMap, Map<Class<? extends Provider>, String> defaultProviders) {
        String defaultProvider = Config.getProvider((String)spi.getName());
        if (defaultProvider != null) {
            Map<String, ProviderFactory> map = factoriesMap.get(spi.getProviderClass());
            if (map == null || map.get(defaultProvider) == null) {
                throw new RuntimeException("Failed to find provider " + defaultProvider + " for " + spi.getName());
            }
        } else {
            Optional<ProviderFactory> highestPriority;
            Map<String, ProviderFactory> factories = factoriesMap.get(spi.getProviderClass());
            if (factories != null && factories.size() == 1) {
                defaultProvider = factories.values().iterator().next().getId();
            }
            if (factories != null && defaultProvider == null && (highestPriority = factories.values().stream().max(Comparator.comparing(ProviderFactory::order))).isPresent() && highestPriority.get().order() > 0) {
                defaultProvider = highestPriority.get().getId();
            }
            if (defaultProvider == null && (factories == null || factories.containsKey("default"))) {
                defaultProvider = "default";
            }
        }
        if (defaultProvider != null) {
            defaultProviders.put(spi.getProviderClass(), defaultProvider);
        } else {
            logger.debugv("No default provider for {0}", (Object)spi.getName());
        }
    }

    private boolean isMetricsEnabled() {
        return Configuration.getOptionalBooleanValue((String)"kc.".concat("metrics-enabled")).orElse(false);
    }

    private boolean isHealthEnabled() {
        return Configuration.getOptionalBooleanValue((String)"kc.".concat("health-enabled")).orElse(false);
    }

    private boolean isHealthClassicProbesEnabled() {
        return Configuration.getOptionalBooleanValue((String)"kc.".concat("health-classic-probes-enabled")).orElse(false);
    }

    static JdbcDataSourceBuildItem getDefaultDataSource(List<JdbcDataSourceBuildItem> jdbcDataSources) {
        for (JdbcDataSourceBuildItem jdbcDataSource : jdbcDataSources) {
            if (!jdbcDataSource.isDefault()) continue;
            return jdbcDataSource;
        }
        throw new RuntimeException("No default datasource found. The server datasource must be the default datasource.");
    }

    static {
        DEPLOYEABLE_SCRIPT_PROVIDERS.put("authenticators", KeycloakProcessor::registerScriptAuthenticator);
        DEPLOYEABLE_SCRIPT_PROVIDERS.put("policies", KeycloakProcessor::registerScriptPolicy);
        DEPLOYEABLE_SCRIPT_PROVIDERS.put("mappers", KeycloakProcessor::registerScriptMapper);
        DEPLOYEABLE_SCRIPT_PROVIDERS.put("saml-mappers", KeycloakProcessor::registerSAMLScriptMapper);
    }
}

