/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.sessions.infinispan.InfinispanStickySessionEncoderProvider;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.sessions.StickySessionEncoderProvider;
import org.keycloak.sessions.StickySessionEncoderProviderFactory;

public class InfinispanStickySessionEncoderProviderFactory
implements StickySessionEncoderProviderFactory,
EnvironmentDependentProviderFactory {
    private static final Logger log = Logger.getLogger(InfinispanStickySessionEncoderProviderFactory.class);
    private boolean shouldAttachRoute;

    public StickySessionEncoderProvider create(KeycloakSession session) {
        return new InfinispanStickySessionEncoderProvider(session, this.shouldAttachRoute);
    }

    public void init(Config.Scope config) {
        this.shouldAttachRoute = config.getBoolean("shouldAttachRoute", Boolean.valueOf(true));
        log.debugf("Should attach route to the sticky session cookie: %b", (Object)this.shouldAttachRoute);
    }

    public void setShouldAttachRoute(boolean shouldAttachRoute) {
        this.shouldAttachRoute = shouldAttachRoute;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "infinispan";
    }

    public int order() {
        return 1;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("shouldAttachRoute").type("boolean").helpText("If the route should be attached to cookies to reflect the node that owns a particular session.").defaultValue((Object)true).add().build();
    }

    public boolean isSupported() {
        return !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }
}

