/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization.entity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.keycloak.models.map.authorization.entity.MapPolicyEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;

public class MapPolicyEntityImpl
extends MapPolicyEntity.AbstractMapPolicyEntity
implements MapPolicyEntity {
    private String fId;
    private Set<String> fAssociatedPolicyIds;
    private Map<String, String> fConfigs;
    private DecisionStrategy fDecisionStrategy;
    private String fDescription;
    private Logic fLogic;
    private String fName;
    private String fOwner;
    private String fRealmId;
    private Set<String> fResourceIds;
    private String fResourceServerId;
    private Set<String> fScopeIds;
    private String fType;

    private MapPolicyEntityImpl() {
        this(DeepCloner.DUMB_CLONER);
    }

    public MapPolicyEntityImpl(DeepCloner cloner) {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapPolicyEntityImpl)) {
            return false;
        }
        MapPolicyEntityImpl other = (MapPolicyEntityImpl)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAssociatedPolicyIds(), other.getAssociatedPolicyIds()) && Objects.equals(this.getConfigs(), other.getConfigs()) && Objects.equals(this.getDecisionStrategy(), other.getDecisionStrategy()) && Objects.equals(this.getDescription(), other.getDescription()) && Objects.equals(this.getLogic(), other.getLogic()) && Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getOwner(), other.getOwner()) && Objects.equals(this.getRealmId(), other.getRealmId()) && Objects.equals(this.getResourceIds(), other.getResourceIds()) && Objects.equals(this.getResourceServerId(), other.getResourceServerId()) && Objects.equals(this.getScopeIds(), other.getScopeIds()) && Objects.equals(this.getType(), other.getType());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    @Override
    public Set<String> getAssociatedPolicyIds() {
        return this.fAssociatedPolicyIds;
    }

    @Override
    public void addAssociatedPolicyId(String p0) {
        if (UndefinedValuesUtils.isUndefined(p0)) {
            return;
        }
        if (this.fAssociatedPolicyIds == null) {
            this.fAssociatedPolicyIds = new HashSet<String>();
        }
        this.updated |= this.fAssociatedPolicyIds.add(p0);
    }

    @Override
    public void removeAssociatedPolicyId(String p0) {
        if (this.fAssociatedPolicyIds == null) {
            return;
        }
        boolean removed = this.fAssociatedPolicyIds.remove(p0);
        this.updated |= removed;
    }

    @Override
    public void setConfigs(Map<String, String> p0) {
        HashMap<String, String> hashMap = p0 = p0 == null ? null : new HashMap<String, String>(p0);
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        this.updated |= !Objects.equals(this.fConfigs, p0);
        this.fConfigs = p0;
    }

    @Override
    public Map<String, String> getConfigs() {
        return this.fConfigs;
    }

    @Override
    public String getConfig(String p0) {
        return this.fConfigs == null ? null : this.fConfigs.get(p0);
    }

    @Override
    public void setConfig(String p0, String p1) {
        String v;
        boolean valueUndefined = UndefinedValuesUtils.isUndefined(p1);
        if (valueUndefined) {
            if (this.fConfigs != null) {
                this.updated |= this.fConfigs.remove(p0) != null;
            }
            return;
        }
        if (this.fConfigs == null) {
            this.fConfigs = new HashMap<String, String>();
        }
        this.updated |= !Objects.equals(v = this.fConfigs.put(p0, p1), p1);
    }

    @Override
    public void removeConfig(String p0) {
        if (this.fConfigs == null) {
            return;
        }
        boolean removed = this.fConfigs.remove(p0) != null;
        this.updated |= removed;
    }

    @Override
    public void setDecisionStrategy(DecisionStrategy p0) {
        this.updated |= !Objects.equals(this.fDecisionStrategy, p0);
        this.fDecisionStrategy = p0;
    }

    @Override
    public DecisionStrategy getDecisionStrategy() {
        return this.fDecisionStrategy;
    }

    @Override
    public void setDescription(String p0) {
        this.updated |= !Objects.equals(this.fDescription, p0);
        this.fDescription = p0;
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    @Override
    public void setLogic(Logic p0) {
        this.updated |= !Objects.equals(this.fLogic, p0);
        this.fLogic = p0;
    }

    @Override
    public Logic getLogic() {
        return this.fLogic;
    }

    @Override
    public void setName(String p0) {
        this.updated |= !Objects.equals(this.fName, p0);
        this.fName = p0;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setOwner(String p0) {
        this.updated |= !Objects.equals(this.fOwner, p0);
        this.fOwner = p0;
    }

    @Override
    public String getOwner() {
        return this.fOwner;
    }

    @Override
    public String getRealmId() {
        return this.fRealmId;
    }

    @Override
    public void setRealmId(String p0) {
        this.updated |= !Objects.equals(this.fRealmId, p0);
        this.fRealmId = p0;
    }

    @Override
    public void removeResourceId(String p0) {
        if (this.fResourceIds == null) {
            return;
        }
        boolean removed = this.fResourceIds.remove(p0);
        this.updated |= removed;
    }

    @Override
    public Set<String> getResourceIds() {
        return this.fResourceIds;
    }

    @Override
    public void addResourceId(String p0) {
        if (UndefinedValuesUtils.isUndefined(p0)) {
            return;
        }
        if (this.fResourceIds == null) {
            this.fResourceIds = new HashSet<String>();
        }
        this.updated |= this.fResourceIds.add(p0);
    }

    @Override
    public String getResourceServerId() {
        return this.fResourceServerId;
    }

    @Override
    public void setResourceServerId(String p0) {
        this.updated |= !Objects.equals(this.fResourceServerId, p0);
        this.fResourceServerId = p0;
    }

    @Override
    public void removeScopeId(String p0) {
        if (this.fScopeIds == null) {
            return;
        }
        boolean removed = this.fScopeIds.remove(p0);
        this.updated |= removed;
    }

    @Override
    public Set<String> getScopeIds() {
        return this.fScopeIds;
    }

    @Override
    public void addScopeId(String p0) {
        if (UndefinedValuesUtils.isUndefined(p0)) {
            return;
        }
        if (this.fScopeIds == null) {
            this.fScopeIds = new HashSet<String>();
        }
        this.updated |= this.fScopeIds.add(p0);
    }

    @Override
    public void setType(String p0) {
        this.updated |= !Objects.equals(this.fType, p0);
        this.fType = p0;
    }

    @Override
    public String getType() {
        return this.fType;
    }

    public static class Empty
    extends MapPolicyEntity.AbstractMapPolicyEntity
    implements MapPolicyEntity {
        public static final Empty INSTANCE = new Empty();

        @Override
        public void setId(String id) {
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public Set<String> getAssociatedPolicyIds() {
            return null;
        }

        @Override
        public void addAssociatedPolicyId(String policyId) {
        }

        @Override
        public void removeAssociatedPolicyId(String policyId) {
        }

        @Override
        public void setConfigs(Map<String, String> config) {
        }

        @Override
        public Map<String, String> getConfigs() {
            return null;
        }

        @Override
        public String getConfig(String name) {
            return null;
        }

        @Override
        public void setConfig(String name, String value) {
        }

        @Override
        public void removeConfig(String name) {
        }

        @Override
        public void setDecisionStrategy(DecisionStrategy decisionStrategy) {
        }

        @Override
        public DecisionStrategy getDecisionStrategy() {
            return null;
        }

        @Override
        public void setDescription(String description) {
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public void setLogic(Logic logic) {
        }

        @Override
        public Logic getLogic() {
            return null;
        }

        @Override
        public void setName(String name) {
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public void setOwner(String owner) {
        }

        @Override
        public String getOwner() {
            return null;
        }

        @Override
        public String getRealmId() {
            return null;
        }

        @Override
        public void setRealmId(String realmId) {
        }

        @Override
        public void removeResourceId(String resourceId) {
        }

        @Override
        public Set<String> getResourceIds() {
            return null;
        }

        @Override
        public void addResourceId(String resourceId) {
        }

        @Override
        public String getResourceServerId() {
            return null;
        }

        @Override
        public void setResourceServerId(String resourceServerId) {
        }

        @Override
        public void removeScopeId(String scopeId) {
        }

        @Override
        public Set<String> getScopeIds() {
            return null;
        }

        @Override
        public void addScopeId(String scopeId) {
        }

        @Override
        public void setType(String type) {
        }

        @Override
        public String getType() {
            return null;
        }

        @Override
        public boolean isUpdated() {
            return false;
        }
    }
}

