/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.accesslog;

import io.undertow.UndertowLogger;
import io.undertow.Version;
import io.undertow.attribute.AuthenticationTypeExchangeAttribute;
import io.undertow.attribute.BytesSentAttribute;
import io.undertow.attribute.CompositeExchangeAttribute;
import io.undertow.attribute.ConstantExchangeAttribute;
import io.undertow.attribute.CookieAttribute;
import io.undertow.attribute.DateTimeAttribute;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeParser;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.attribute.LocalIPAttribute;
import io.undertow.attribute.QueryStringAttribute;
import io.undertow.attribute.QuotingExchangeAttribute;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.attribute.RemoteIPAttribute;
import io.undertow.attribute.RemoteUserAttribute;
import io.undertow.attribute.RequestHeaderAttribute;
import io.undertow.attribute.RequestMethodAttribute;
import io.undertow.attribute.RequestProtocolAttribute;
import io.undertow.attribute.RequestSchemeAttribute;
import io.undertow.attribute.RequestURLAttribute;
import io.undertow.attribute.ResponseCodeAttribute;
import io.undertow.attribute.ResponseHeaderAttribute;
import io.undertow.attribute.ResponseTimeAttribute;
import io.undertow.attribute.SecureExchangeAttribute;
import io.undertow.attribute.SubstituteEmptyWrapper;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.accesslog.LogFileHeaderGenerator;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ExtendedAccessLogParser {
    private final ExchangeAttributeParser parser;

    public ExtendedAccessLogParser(ClassLoader classLoader) {
        this.parser = ExchangeAttributes.parser(classLoader, QuotingExchangeAttribute.WRAPPER);
    }

    public ExchangeAttribute parse(String pattern) {
        ArrayList<ExchangeAttribute> list = new ArrayList<ExchangeAttribute>();
        PatternTokenizer tokenizer = new PatternTokenizer(pattern);
        try {
            tokenizer.getWhiteSpaces();
            if (tokenizer.isEnded()) {
                UndertowLogger.ROOT_LOGGER.extendedAccessLogEmptyPattern();
                return null;
            }
            String token = tokenizer.getToken();
            while (token != null) {
                ExchangeAttribute element;
                if (UndertowLogger.ROOT_LOGGER.isDebugEnabled()) {
                    UndertowLogger.ROOT_LOGGER.debug("token = " + token);
                }
                if ((element = this.getLogElement(token, tokenizer)) == null) break;
                list.add(element);
                String whiteSpaces = tokenizer.getWhiteSpaces();
                if (whiteSpaces.length() > 0) {
                    list.add(new ConstantExchangeAttribute(whiteSpaces));
                }
                if (tokenizer.isEnded()) break;
                token = tokenizer.getToken();
            }
            if (UndertowLogger.ROOT_LOGGER.isDebugEnabled()) {
                UndertowLogger.ROOT_LOGGER.debug("finished decoding with element size of: " + list.size());
            }
            return new CompositeExchangeAttribute(list.toArray(new ExchangeAttribute[list.size()]));
        }
        catch (IOException e) {
            UndertowLogger.ROOT_LOGGER.extendedAccessLogPatternParseError(e);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ExchangeAttribute getLogElement(String token, PatternTokenizer tokenizer) throws IOException {
        if ("date".equals(token)) {
            return new DateTimeAttribute("yyyy-MM-dd", "GMT");
        }
        if ("time".equals(token)) {
            if (!tokenizer.hasSubToken()) return new DateTimeAttribute("HH:mm:ss", "GMT");
            String nextToken = tokenizer.getToken();
            if ("taken".equals(nextToken)) {
                return new SubstituteEmptyWrapper.SubstituteEmptyAttribute(new ResponseTimeAttribute(TimeUnit.SECONDS), "-");
            }
        } else {
            if ("bytes".equals(token)) {
                return new BytesSentAttribute(true);
            }
            if ("cached".equals(token)) {
                return new ConstantExchangeAttribute("-");
            }
            if ("c".equals(token)) {
                String nextToken = tokenizer.getToken();
                if ("ip".equals(nextToken)) {
                    return RemoteIPAttribute.INSTANCE;
                }
                if ("dns".equals(nextToken)) {
                    return new ExchangeAttribute(){

                        @Override
                        public String readAttribute(HttpServerExchange exchange) {
                            InetSocketAddress peerAddress = exchange.getSourceAddress();
                            try {
                                return peerAddress.getHostName();
                            }
                            catch (Throwable e) {
                                return peerAddress.getHostString();
                            }
                        }

                        @Override
                        public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
                            throw new ReadOnlyAttributeException();
                        }
                    };
                }
            } else if ("s".equals(token)) {
                String nextToken = tokenizer.getToken();
                if ("ip".equals(nextToken)) {
                    return LocalIPAttribute.INSTANCE;
                }
                if ("dns".equals(nextToken)) {
                    return new ExchangeAttribute(){

                        @Override
                        public String readAttribute(HttpServerExchange exchange) {
                            try {
                                return exchange.getDestinationAddress().getHostName();
                            }
                            catch (Throwable e) {
                                return "localhost";
                            }
                        }

                        @Override
                        public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
                            throw new ReadOnlyAttributeException();
                        }
                    };
                }
            } else {
                if ("cs".equals(token)) {
                    return this.getClientToServerElement(tokenizer);
                }
                if ("sc".equals(token)) {
                    return this.getServerToClientElement(tokenizer);
                }
                if ("sr".equals(token) || "rs".equals(token)) {
                    return this.getProxyElement(tokenizer);
                }
                if ("x".equals(token)) {
                    return this.getXParameterElement(tokenizer);
                }
            }
        }
        UndertowLogger.ROOT_LOGGER.extendedAccessLogUnknownToken(token);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ExchangeAttribute getClientToServerElement(PatternTokenizer tokenizer) throws IOException {
        if (tokenizer.hasSubToken()) {
            String token = tokenizer.getToken();
            if ("method".equals(token)) {
                return RequestMethodAttribute.INSTANCE;
            }
            if ("uri".equals(token)) {
                if (!tokenizer.hasSubToken()) return new ExchangeAttribute(){

                    @Override
                    public String readAttribute(HttpServerExchange exchange) {
                        String query = exchange.getQueryString();
                        if (query.isEmpty()) {
                            return exchange.getRequestURI();
                        }
                        StringBuilder buf = new StringBuilder();
                        buf.append(exchange.getRequestURI());
                        buf.append('?');
                        buf.append(exchange.getQueryString());
                        return buf.toString();
                    }

                    @Override
                    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
                        throw new ReadOnlyAttributeException();
                    }
                };
                token = tokenizer.getToken();
                if ("stem".equals(token)) {
                    return RequestURLAttribute.INSTANCE;
                }
                if ("query".equals(token)) {
                    return new SubstituteEmptyWrapper.SubstituteEmptyAttribute(QueryStringAttribute.BARE_INSTANCE, "-");
                }
            }
        } else if (tokenizer.hasParameter()) {
            String parameter = tokenizer.getParameter();
            if (parameter != null) return new QuotingExchangeAttribute(new RequestHeaderAttribute(parameter));
            UndertowLogger.ROOT_LOGGER.extendedAccessLogMissingClosing();
            return null;
        }
        UndertowLogger.ROOT_LOGGER.extendedAccessLogCannotDecode(tokenizer.getRemains());
        return null;
    }

    protected ExchangeAttribute getServerToClientElement(PatternTokenizer tokenizer) throws IOException {
        if (tokenizer.hasSubToken()) {
            String token = tokenizer.getToken();
            if ("status".equals(token)) {
                return ResponseCodeAttribute.INSTANCE;
            }
            if ("comment".equals(token)) {
                return new ConstantExchangeAttribute("?");
            }
        } else if (tokenizer.hasParameter()) {
            String parameter = tokenizer.getParameter();
            if (parameter == null) {
                UndertowLogger.ROOT_LOGGER.extendedAccessLogMissingClosing();
                return null;
            }
            return new QuotingExchangeAttribute(new ResponseHeaderAttribute(parameter));
        }
        UndertowLogger.ROOT_LOGGER.extendedAccessLogCannotDecode(tokenizer.getRemains());
        return null;
    }

    protected ExchangeAttribute getProxyElement(PatternTokenizer tokenizer) throws IOException {
        String token = null;
        if (tokenizer.hasSubToken()) {
            tokenizer.getToken();
            return new ConstantExchangeAttribute("-");
        }
        if (tokenizer.hasParameter()) {
            tokenizer.getParameter();
            return new ConstantExchangeAttribute("-");
        }
        UndertowLogger.ROOT_LOGGER.extendedAccessLogCannotDecode(token);
        return null;
    }

    protected ExchangeAttribute getXParameterElement(PatternTokenizer tokenizer) throws IOException {
        if (!tokenizer.hasSubToken()) {
            UndertowLogger.ROOT_LOGGER.extendedAccessLogBadXParam();
            return null;
        }
        String token = tokenizer.getToken();
        if (!tokenizer.hasParameter()) {
            UndertowLogger.ROOT_LOGGER.extendedAccessLogBadXParam();
            return null;
        }
        final String parameter = tokenizer.getParameter();
        if (parameter == null) {
            UndertowLogger.ROOT_LOGGER.extendedAccessLogMissingClosing();
            return null;
        }
        if ("A".equals(token)) {
            return new SubstituteEmptyWrapper.SubstituteEmptyAttribute(this.parser.parse("%{sc," + parameter + "}"), "-");
        }
        if ("C".equals(token)) {
            return new SubstituteEmptyWrapper.SubstituteEmptyAttribute(new CookieAttribute(parameter), "-");
        }
        if ("R".equals(token)) {
            return this.parser.parse("%{r," + parameter + "}");
        }
        if ("S".equals(token)) {
            return new SubstituteEmptyWrapper.SubstituteEmptyAttribute(this.parser.parse("%{s," + parameter + "}"), "-");
        }
        if ("H".equals(token)) {
            return this.getServletRequestElement(parameter);
        }
        if ("P".equals(token)) {
            return new SubstituteEmptyWrapper.SubstituteEmptyAttribute(this.parser.parse("%{rp," + parameter + "}"), "-");
        }
        if ("O".equals(token)) {
            return new QuotingExchangeAttribute(new ExchangeAttribute(){

                @Override
                public String readAttribute(HttpServerExchange exchange) {
                    List<String> values = exchange.getResponseHeaders(parameter);
                    if (values != null && values.size() > 0) {
                        StringBuilder buffer = new StringBuilder();
                        for (int i = 0; i < values.size(); ++i) {
                            String string = values.get(i);
                            buffer.append(string);
                            if (i + 1 >= values.size()) continue;
                            buffer.append(",");
                        }
                        return buffer.toString();
                    }
                    return null;
                }

                @Override
                public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
                    throw new ReadOnlyAttributeException();
                }
            });
        }
        UndertowLogger.ROOT_LOGGER.extendedAccessLogCannotDecodeXParamValue(token);
        return null;
    }

    protected ExchangeAttribute getServletRequestElement(String parameter) {
        if ("authType".equals(parameter)) {
            return new SubstituteEmptyWrapper.SubstituteEmptyAttribute(AuthenticationTypeExchangeAttribute.INSTANCE, "-");
        }
        if ("remoteUser".equals(parameter)) {
            return new SubstituteEmptyWrapper.SubstituteEmptyAttribute(RemoteUserAttribute.INSTANCE, "-");
        }
        if ("requestedSessionId".equals(parameter)) {
            return this.parser.parse("%{REQUESTED_SESSION_ID}");
        }
        if ("requestedSessionIdFromCookie".equals(parameter)) {
            return this.parser.parse("%{REQUESTED_SESSION_ID_FROM_COOKIE}");
        }
        if ("requestedSessionIdValid".equals(parameter)) {
            return this.parser.parse("%{REQUESTED_SESSION_ID_VALID}");
        }
        if ("contentLength".equals(parameter)) {
            return new QuotingExchangeAttribute(new RequestHeaderAttribute("Content-Length"));
        }
        if ("characterEncoding".equals(parameter)) {
            return this.parser.parse("%{REQUEST_CHARACTER_ENCODING}");
        }
        if ("locale".equals(parameter)) {
            return this.parser.parse("%{REQUEST_LOCALE}");
        }
        if ("getProtocol".equals(parameter)) {
            return RequestProtocolAttribute.INSTANCE;
        }
        if ("scheme".equals(parameter)) {
            return RequestSchemeAttribute.INSTANCE;
        }
        if ("secure".equals(parameter)) {
            return SecureExchangeAttribute.INSTANCE;
        }
        UndertowLogger.ROOT_LOGGER.extendedAccessLogCannotDecodeXParamValue(parameter);
        return null;
    }

    public static class ExtendedAccessLogHeaderGenerator
    implements LogFileHeaderGenerator {
        private final String pattern;

        public ExtendedAccessLogHeaderGenerator(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public String generateHeader() {
            StringBuilder sb = new StringBuilder();
            sb.append("#Fields: ");
            sb.append(this.pattern);
            sb.append("\n#Version: 2.0\n");
            sb.append("#Software: ");
            sb.append(Version.getFullVersionString());
            sb.append("\n");
            return sb.toString();
        }
    }

    private static class PatternTokenizer {
        private StringReader sr = null;
        private StringBuilder buf = new StringBuilder();
        private boolean ended = false;
        private boolean subToken;
        private boolean parameter;

        PatternTokenizer(String str) {
            this.sr = new StringReader(str);
        }

        public boolean hasSubToken() {
            return this.subToken;
        }

        public boolean hasParameter() {
            return this.parameter;
        }

        public String getToken() throws IOException {
            if (this.ended) {
                return null;
            }
            String result = null;
            this.subToken = false;
            this.parameter = false;
            int c = this.sr.read();
            while (c != -1) {
                switch (c) {
                    case 32: {
                        result = this.buf.toString();
                        this.buf = new StringBuilder();
                        this.buf.append((char)c);
                        return result;
                    }
                    case 45: {
                        result = this.buf.toString();
                        this.buf = new StringBuilder();
                        this.subToken = true;
                        return result;
                    }
                    case 40: {
                        result = this.buf.toString();
                        this.buf = new StringBuilder();
                        this.parameter = true;
                        return result;
                    }
                    case 41: {
                        result = this.buf.toString();
                        this.buf = new StringBuilder();
                        break;
                    }
                    default: {
                        this.buf.append((char)c);
                    }
                }
                c = this.sr.read();
            }
            this.ended = true;
            if (this.buf.length() != 0) {
                return this.buf.toString();
            }
            return null;
        }

        public String getParameter() throws IOException {
            if (!this.parameter) {
                return null;
            }
            this.parameter = false;
            int c = this.sr.read();
            while (c != -1) {
                if (c == 41) {
                    String result = this.buf.toString();
                    this.buf = new StringBuilder();
                    return result;
                }
                this.buf.append((char)c);
                c = this.sr.read();
            }
            return null;
        }

        public String getWhiteSpaces() throws IOException {
            if (this.isEnded()) {
                return "";
            }
            StringBuilder whiteSpaces = new StringBuilder();
            if (this.buf.length() > 0) {
                whiteSpaces.append((CharSequence)this.buf);
                this.buf = new StringBuilder();
            }
            int c = this.sr.read();
            while (Character.isWhitespace((char)c)) {
                whiteSpaces.append((char)c);
                c = this.sr.read();
            }
            if (c == -1) {
                this.ended = true;
            } else {
                this.buf.append((char)c);
            }
            return whiteSpaces.toString();
        }

        public boolean isEnded() {
            return this.ended;
        }

        public String getRemains() throws IOException {
            StringBuilder remains = new StringBuilder();
            int c = this.sr.read();
            while (c != -1) {
                remains.append((char)c);
                c = this.sr.read();
            }
            return remains.toString();
        }
    }
}

