/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.AnnotationCreator;
import io.quarkus.gizmo.AnnotationCreatorImpl;
import io.quarkus.gizmo.AnnotationUtils;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.BytecodeCreatorImpl;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FunctionCreatorImpl;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class MethodCreatorImpl
extends BytecodeCreatorImpl
implements MethodCreator {
    private final List<String> exceptions = new ArrayList<String>();
    private final List<AnnotationCreatorImpl> annotations = new ArrayList<AnnotationCreatorImpl>();
    private final Map<Integer, AnnotationParameters> parameterAnnotations = new LinkedHashMap<Integer, AnnotationParameters>();
    private final MethodDescriptor methodDescriptor;
    private final String declaringClassName;
    private final ClassCreator classCreator;
    private String signature;
    private int modifiers = 1;
    private String[] parameterNames;

    MethodCreatorImpl(BytecodeCreatorImpl enclosing, MethodDescriptor methodDescriptor, String declaringClassName, ClassCreator classCreator) {
        super(enclosing, true);
        this.methodDescriptor = methodDescriptor;
        this.declaringClassName = declaringClassName;
        this.classCreator = classCreator;
    }

    @Override
    public MethodCreator addException(String exception) {
        this.exceptions.add(exception.replace('.', '/'));
        return this;
    }

    @Override
    public List<String> getExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }

    @Override
    public MethodDescriptor getMethodDescriptor() {
        return this.methodDescriptor;
    }

    @Override
    public AnnotatedElement getParameterAnnotations(int param) {
        if (this.parameterAnnotations.containsKey(param)) {
            return this.parameterAnnotations.get(param);
        }
        AnnotationParameters p = new AnnotationParameters();
        this.parameterAnnotations.put(param, p);
        return p;
    }

    @Override
    public void setParameterNames(String[] parameterNames) {
        if (parameterNames == null) {
            this.parameterNames = null;
            return;
        }
        if (this.methodDescriptor.getParameterTypes().length != parameterNames.length) {
            throw new IllegalArgumentException("Method " + this.methodDescriptor.getDeclaringClass() + "#" + this.methodDescriptor.getName() + " has " + this.methodDescriptor.getParameterTypes().length + " parameters, but provided parameter names array has " + parameterNames.length + ": " + Arrays.toString(parameterNames));
        }
        this.parameterNames = parameterNames;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public MethodCreator setModifiers(int mods) {
        boolean isOnInterface = this.classCreator.isInterface();
        if (isOnInterface && (mods & 4) != 0) {
            throw new IllegalArgumentException("Interface method may not be protected: " + this.methodDescriptor);
        }
        if (isOnInterface && (mods & 0x10) != 0) {
            throw new IllegalArgumentException("Interface method may not be final: " + this.methodDescriptor);
        }
        if (isOnInterface && (mods & 0x20) != 0) {
            throw new IllegalArgumentException("Interface method may not be synchronized: " + this.methodDescriptor);
        }
        if (isOnInterface && (mods & 0x100) != 0) {
            throw new IllegalArgumentException("Interface method may not be native: " + this.methodDescriptor);
        }
        this.modifiers = mods;
        return this;
    }

    @Override
    public void write(ClassVisitor file) {
        MethodVisitor visitor = file.visitMethod(this.modifiers, this.methodDescriptor.getName(), this.methodDescriptor.getDescriptor(), this.signature, this.exceptions.toArray(new String[0]));
        int localVarCount = Modifier.isStatic(this.modifiers) ? 0 : 1;
        for (int i = 0; i < this.methodDescriptor.getParameterTypes().length; ++i) {
            String s = this.methodDescriptor.getParameterTypes()[i];
            if (s.equals("J") || s.equals("D")) {
                localVarCount += 2;
                continue;
            }
            ++localVarCount;
        }
        int varCount = this.allocateLocalVariables(localVarCount);
        this.writeOperations(visitor);
        visitor.visitMaxs(0, varCount);
        for (AnnotationCreatorImpl annotationCreatorImpl : this.annotations) {
            AnnotationVisitor av = visitor.visitAnnotation(DescriptorUtils.extToInt(annotationCreatorImpl.getAnnotationType()), annotationCreatorImpl.getRetentionPolicy() == RetentionPolicy.RUNTIME);
            for (Map.Entry<String, Object> e : annotationCreatorImpl.getValues().entrySet()) {
                AnnotationUtils.visitAnnotationValue(av, e.getKey(), e.getValue());
            }
            av.visitEnd();
        }
        for (Map.Entry entry : this.parameterAnnotations.entrySet()) {
            for (AnnotationCreatorImpl annotationCreatorImpl : ((AnnotationParameters)entry.getValue()).annotations) {
                AnnotationVisitor av = visitor.visitParameterAnnotation(((Integer)entry.getKey()).intValue(), DescriptorUtils.extToInt(annotationCreatorImpl.getAnnotationType()), annotationCreatorImpl.getRetentionPolicy() == RetentionPolicy.RUNTIME);
                for (Map.Entry<String, Object> e : annotationCreatorImpl.getValues().entrySet()) {
                    AnnotationUtils.visitAnnotationValue(av, e.getKey(), e.getValue());
                }
                av.visitEnd();
            }
        }
        if (this.parameterNames != null) {
            for (Iterator<Object> iterator : this.parameterNames) {
                visitor.visitParameter(iterator, 0);
            }
        }
        visitor.visitEnd();
    }

    @Override
    ResultHandle resolve(ResultHandle handle, BytecodeCreator creator) {
        return handle;
    }

    @Override
    ResultHandle[] resolve(BytecodeCreator owner, ResultHandle ... handles) {
        return handles;
    }

    public String toString() {
        return "MethodCreatorImpl [declaringClassName=" + this.getDeclaringClassName() + ", methodDescriptor=" + this.methodDescriptor + "]";
    }

    @Override
    public AnnotationCreator addAnnotation(String annotationType, RetentionPolicy retentionPolicy) {
        AnnotationCreatorImpl ac = new AnnotationCreatorImpl(annotationType, retentionPolicy);
        this.annotations.add(ac);
        return ac;
    }

    String getDeclaringClassName() {
        return this.declaringClassName;
    }

    ClassOutput getClassOutput() {
        return this.classCreator.getClassOutput();
    }

    ClassCreator getClassCreator() {
        return this.classCreator;
    }

    FunctionCreatorImpl addFunctionBody(ResultHandle instance, ClassCreator cc, MethodCreatorImpl mc, BytecodeCreatorImpl owner) {
        final FunctionCreatorImpl fc = new FunctionCreatorImpl(instance, cc, mc, owner);
        this.operations.add(new BytecodeCreatorImpl.Operation(){

            @Override
            void writeBytecode(MethodVisitor methodVisitor) {
                fc.getBytecode().writeOperations(methodVisitor);
            }

            @Override
            Set<ResultHandle> getInputResultHandles() {
                return Collections.emptySet();
            }

            @Override
            ResultHandle getTopResultHandle() {
                return null;
            }

            @Override
            ResultHandle getOutgoingResultHandle() {
                return null;
            }

            @Override
            public void findResultHandles(Set<ResultHandle> vc) {
                fc.getBytecode().findActiveResultHandles(vc);
            }
        });
        return fc;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public MethodCreator setSignature(String signature) {
        this.signature = signature;
        return this;
    }

    private static class AnnotationParameters
    implements AnnotatedElement {
        final List<AnnotationCreatorImpl> annotations = new ArrayList<AnnotationCreatorImpl>();

        private AnnotationParameters() {
        }

        @Override
        public AnnotationCreator addAnnotation(String annotationType, RetentionPolicy retentionPolicy) {
            AnnotationCreatorImpl ret = new AnnotationCreatorImpl(annotationType, retentionPolicy);
            this.annotations.add(ret);
            return ret;
        }
    }
}

