/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.Properties;
import oracle.jdbc.spi.OracleConfigurationProvider;
import oracle.jdbc.util.ThreadSafeCache;

public abstract class OracleConfigurationCacheProvider
implements OracleConfigurationProvider {
    private static final int MAX_ENTRIES = 100;
    ThreadSafeCache<String, CacheEntry> cachedProperties = new ThreadSafeCache(100);

    class CacheEntry {
        private static final long DEFAULT_TTL = 60000L;
        private Properties properties;
        private long expiringTimeMillis;

        public CacheEntry(Properties properties) {
            this.properties = properties;
            this.expiringTimeMillis = System.currentTimeMillis() + 60000L;
        }

        public CacheEntry(Properties properties, long timeToLive) {
            this.properties = properties;
            this.expiringTimeMillis = timeToLive < 0L ? Long.MAX_VALUE : System.currentTimeMillis() + timeToLive * 1000L;
        }

        public long getExpiringTimeMillis() {
            return this.expiringTimeMillis;
        }

        public Properties getProperties() {
            return this.properties;
        }
    }
}

