/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.security.MessageDigest;
import java.sql.SQLException;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DBConversion;
import oracle.sql.CharacterSet;

class SimpleByteArray
extends ByteArray {
    protected byte[] bytes;

    protected SimpleByteArray(Diagnosable diagnosable, byte[] _bytes) {
        super(diagnosable);
        this.setBytes(_bytes);
    }

    void setBytes(byte[] _bytes) {
        this.bytes = _bytes;
    }

    @Override
    long length() {
        return this.bytes.length;
    }

    @Override
    void put(long index, byte value) {
        assert (index >= 0L && index < (long)this.bytes.length) : "index = " + index + " length = " + this.bytes.length;
        this.bytes[(int)index] = value;
    }

    @Override
    byte get(long index) {
        assert (index >= 0L && index < (long)this.bytes.length) : "index = " + index + " length = " + this.bytes.length;
        return this.bytes[(int)index];
    }

    @Override
    void put(long offset, byte[] src, int srcOffset, int length) {
        assert (offset >= 0L && offset + (long)length < (long)this.bytes.length) : "offset = " + offset + " length = " + length + " bytes.length = " + this.bytes.length;
        assert (srcOffset >= 0 && srcOffset + length < src.length) : "srcOffset = " + srcOffset + " length = " + length + " src.length = " + src.length;
        System.arraycopy(src, srcOffset, this.bytes, (int)offset, length);
    }

    @Override
    void get(long offset, byte[] dest, int destOffset, int length) {
        assert (offset >= 0L && offset + (long)length <= (long)this.bytes.length && destOffset >= 0 && destOffset + length <= dest.length) : " offset: " + offset + " bytes.length: " + this.bytes.length + " destOffset: " + destOffset + " length: " + length;
        System.arraycopy(this.bytes, (int)offset, dest, destOffset, length);
    }

    char[] getChars(long offset, int lengthInBytes, DBConversion conversion, int formOfUse, int[] out_lengthInChars) throws SQLException {
        int charsConverted;
        assert (offset >= 0L && lengthInBytes >= 0 && (long)this.bytes.length >= offset + (long)lengthInBytes) : "bytes.length: " + this.bytes.length + " offset: " + offset + " lengthInBytes: " + lengthInBytes;
        assert (conversion != null) : "conversion is null";
        assert (out_lengthInChars != null && out_lengthInChars.length >= 1) : "out_lengthInChars: " + out_lengthInChars;
        boolean isNchar = formOfUse == 2;
        char[] cBuf = new char[lengthInBytes * conversion.cMaxCharSize];
        int[] nbytes = new int[]{lengthInBytes};
        out_lengthInChars[0] = charsConverted = conversion.CHARBytesToJavaChars(this.bytes, (int)offset, cBuf, 0, nbytes, cBuf.length, isNchar);
        return cBuf;
    }

    @Override
    char[] getChars(long offset, int lengthInBytes, CharacterSet charSet, int[] out_lengthInChars) throws SQLException {
        assert (offset >= 0L && lengthInBytes >= 0) : "offset: " + offset + " lengthInBytes: " + lengthInBytes;
        assert ((long)this.bytes.length >= offset + (long)lengthInBytes) : "bytes.length: " + this.bytes.length + " offset: " + offset + " lengthInBytes: " + lengthInBytes;
        assert (out_lengthInChars != null && out_lengthInChars.length > 0) : "out_lengthInChars: " + out_lengthInChars;
        String s = charSet.toString(this.bytes, (int)offset, lengthInBytes);
        char[] c = s.toCharArray();
        out_lengthInChars[0] = c.length;
        return c;
    }

    @Override
    long updateChecksum(long offset, int length, CRC64 crc, long checksum) {
        return CRC64.updateChecksum(checksum, this.bytes, (int)offset, length);
    }

    @Override
    void updateDigest(MessageDigest md, long valOffset, int valLen) {
        assert (valOffset >= 0L && valOffset + (long)valLen <= (long)this.bytes.length) : " valOffset: " + valOffset + " bytes.length: " + this.bytes.length + " valLen: " + valLen;
        md.update(this.bytes, (int)valOffset, valLen);
    }

    @Override
    byte[] getBlockBasic(long offset, int[] initialByteIndex) {
        initialByteIndex[0] = (int)offset;
        return offset < (long)this.bytes.length ? this.bytes : null;
    }

    @Override
    void free() {
    }

    @Override
    long getCapacity() {
        return this.bytes.length;
    }
}

