/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonGenerationException;
import oracle.sql.json.OracleJsonParsingException;

public abstract class OracleJsonExceptions {
    public static final ExceptionFactory ORACLE_FACTORY = new OracleExceptionFactory();
    private static final int JSON_ERROR_BASE = 26300;
    public static final OracleJsonExceptions IO = OracleJsonExceptions.jzn(OracleJsonExceptions.getKey(1));
    public static final OracleJsonExceptions BAD_YEAR = OracleJsonExceptions.jzn(OracleJsonExceptions.getKey(2));
    public static final OracleJsonExceptions NOT_IMPLEMENTED = OracleJsonExceptions.jzn(OracleJsonExceptions.getKey(4));
    public static final OracleJsonExceptions CORRUPT = OracleJsonExceptions.jzn(OracleJsonExceptions.getKey(5));
    public static final OracleJsonExceptions UNSUPPORTED_VERSION = OracleJsonExceptions.jzn(OracleJsonExceptions.getKey(6));
    public static final OracleJsonExceptions LONG_KEY = OracleJsonExceptions.jzn(OracleJsonExceptions.getKey(7));
    public static final OracleJsonExceptions IMAGE_TOO_BIG = OracleJsonExceptions.jzn(OracleJsonExceptions.getKey(8));
    public static final OracleJsonExceptions CORRUPT2 = OracleJsonExceptions.jzn(OracleJsonExceptions.getKey(9));
    public static final OracleJsonExceptions NO_DAYS_ALLOWED = OracleJsonExceptions.jzn(OracleJsonExceptions.getKey(10));
    public static final OracleJsonExceptions BAD_WRAP = OracleJsonExceptions.jzn(OracleJsonExceptions.getKey(20));
    public static final OracleJsonExceptions PARSER_ENC_DETECT_FAIL = OracleJsonExceptions.jzn(OracleJsonExceptions.getKey(24));
    public static final OracleJsonExceptions BAD_TIMESTAMP_TZ = OracleJsonExceptions.jzn(OracleJsonExceptions.getKey(36));
    public static final OracleJsonExceptions GENERATION_INCOMPLETE = OracleJsonExceptions.gen(OracleJsonExceptions.getKey(11));
    public static final OracleJsonExceptions MISSING_KEY = OracleJsonExceptions.gen(OracleJsonExceptions.getKey(12));
    public static final OracleJsonExceptions EXTRA_EVENTS = OracleJsonExceptions.gen(OracleJsonExceptions.getKey(13));
    public static final OracleJsonExceptions BAD_END = OracleJsonExceptions.gen(OracleJsonExceptions.getKey(14));
    public static final OracleJsonExceptions BAD_KEY = OracleJsonExceptions.gen(OracleJsonExceptions.getKey(15));
    public static final OracleJsonExceptions EXPECTED_VALUE = OracleJsonExceptions.gen(OracleJsonExceptions.getKey(16));
    public static final OracleJsonExceptions DUPLICATE_KEY = OracleJsonExceptions.gen(OracleJsonExceptions.getKey(23));
    public static final OracleJsonExceptions PARSER_EXPECTED_EOF = OracleJsonExceptions.par(OracleJsonExceptions.getKey(25));
    public static final OracleJsonExceptions TOKEN_UNEXPECTED_CHAR = OracleJsonExceptions.par(OracleJsonExceptions.getKey(26));
    public static final OracleJsonExceptions TOKEN_EXPECTED_CHAR = OracleJsonExceptions.par(OracleJsonExceptions.getKey(27));
    public static final OracleJsonExceptions PARSER_INVALID_TOKEN = OracleJsonExceptions.par(OracleJsonExceptions.getKey(28));
    public static final OracleJsonExceptions OVERFLOW = OracleJsonExceptions.ill(OracleJsonExceptions.getKey(3));
    public static final OracleJsonExceptions BAD_PARSER_STATE = OracleJsonExceptions.ill(OracleJsonExceptions.getKey(17));
    public static final OracleJsonExceptions BAD_PARSER_STATE3 = OracleJsonExceptions.ill(OracleJsonExceptions.getKey(18));
    public static final OracleJsonExceptions BAD_PARSER_STATE_VALUE = OracleJsonExceptions.ill(OracleJsonExceptions.getKey(19));
    public static final OracleJsonExceptions PARSER_GETSTRING_ERR = OracleJsonExceptions.ill(OracleJsonExceptions.getKey(29));
    public static final OracleJsonExceptions PARSER_ISINTEGRAL_ERR = OracleJsonExceptions.ill(OracleJsonExceptions.getKey(30));
    public static final OracleJsonExceptions PARSER_GETINT_ERR = OracleJsonExceptions.ill(OracleJsonExceptions.getKey(31));
    public static final OracleJsonExceptions PARSER_GETLONG_ERR = OracleJsonExceptions.ill(OracleJsonExceptions.getKey(32));
    public static final OracleJsonExceptions PARSER_GETBIGDECIMAL_ERR = OracleJsonExceptions.ill(OracleJsonExceptions.getKey(33));
    public static final OracleJsonExceptions PARSER_GETARRAY_ERR = OracleJsonExceptions.ill(OracleJsonExceptions.getKey(34));
    public static final OracleJsonExceptions PARSER_GETOBJECT_ERR = OracleJsonExceptions.ill(OracleJsonExceptions.getKey(35));
    public static final OracleJsonExceptions OBJ_NOT_MUTABLE = OracleJsonExceptions.uso(OracleJsonExceptions.getKey(21));
    public static final OracleJsonExceptions ARR_NOT_MUTABLE = OracleJsonExceptions.uso(OracleJsonExceptions.getKey(22));
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle("oracle.jdbc.driver.json.ErrorMessagesJson");
    private String key;

    private static String getKey(int errorNumber) {
        return Integer.toString(26300 + errorNumber);
    }

    private OracleJsonExceptions(String key) {
        this.key = key;
    }

    public abstract RuntimeException create(ExceptionFactory var1, Throwable var2, Object ... var3);

    public abstract RuntimeException create(ExceptionFactory var1, Object ... var2);

    public String getMessage(Object ... params) {
        Object url = "";
        if (DatabaseError.isErrorUrlEnabled()) {
            url = System.lineSeparator() + "https://docs.oracle.com/error-help/db/ora-" + this.key + "/";
        }
        return "ORA-" + this.key + ": " + MessageFormat.format(MESSAGES.getString(this.key), params) + (String)url;
    }

    private static OracleJsonExceptions jzn(String key) {
        return new OracleJsonExceptions(key){

            @Override
            public RuntimeException create(ExceptionFactory f, Throwable cause, Object ... params) {
                return f.createJsonException(this.getMessage(params), cause);
            }

            @Override
            public RuntimeException create(ExceptionFactory f, Object ... params) {
                return f.createJsonException(this.getMessage(params));
            }
        };
    }

    private static OracleJsonExceptions par(String key) {
        return new OracleJsonExceptions(key){

            @Override
            public RuntimeException create(ExceptionFactory f, Throwable cause, Object ... params) {
                return f.createJsonException(this.getMessage(params), cause);
            }

            @Override
            public RuntimeException create(ExceptionFactory f, Object ... params) {
                return f.createJsonException(this.getMessage(params));
            }
        };
    }

    private static OracleJsonExceptions gen(String key) {
        return new OracleJsonExceptions(key){

            @Override
            public RuntimeException create(ExceptionFactory f, Throwable cause, Object ... params) {
                return f.createGenerationException(this.getMessage(params), cause);
            }

            @Override
            public RuntimeException create(ExceptionFactory f, Object ... params) {
                return f.createGenerationException(this.getMessage(params));
            }
        };
    }

    private static OracleJsonExceptions ill(String key) {
        return new OracleJsonExceptions(key){

            @Override
            public IllegalStateException create(ExceptionFactory f, Throwable cause, Object ... params) {
                return new IllegalStateException(this.getMessage(params), cause);
            }

            @Override
            public IllegalStateException create(ExceptionFactory f, Object ... params) {
                return new IllegalStateException(this.getMessage(params));
            }
        };
    }

    private static OracleJsonExceptions uso(String key) {
        return new OracleJsonExceptions(key){

            @Override
            public UnsupportedOperationException create(ExceptionFactory f, Throwable cause, Object ... params) {
                return new UnsupportedOperationException(this.getMessage(params), cause);
            }

            @Override
            public UnsupportedOperationException create(ExceptionFactory f, Object ... params) {
                return new UnsupportedOperationException(this.getMessage(params));
            }
        };
    }

    private static final class OracleExceptionFactory
    implements ExceptionFactory {
        private OracleExceptionFactory() {
        }

        @Override
        public RuntimeException createJsonException(String message, Throwable cause) {
            return new OracleJsonException(message, cause);
        }

        @Override
        public RuntimeException createJsonException(String message) {
            return new OracleJsonException(message);
        }

        @Override
        public RuntimeException createGenerationException(String message, Throwable cause) {
            return new OracleJsonGenerationException(message, cause);
        }

        @Override
        public RuntimeException createGenerationException(String message) {
            return new OracleJsonGenerationException(message);
        }

        @Override
        public RuntimeException createParsingException(String message) {
            return new OracleJsonParsingException(message);
        }

        @Override
        public RuntimeException createParsingException(String message, Throwable cause) {
            return new OracleJsonParsingException(message, cause);
        }
    }

    public static interface ExceptionFactory {
        public RuntimeException createJsonException(String var1, Throwable var2);

        public RuntimeException createJsonException(String var1);

        public RuntimeException createGenerationException(String var1);

        public RuntimeException createGenerationException(String var1, Throwable var2);

        public RuntimeException createParsingException(String var1);

        public RuntimeException createParsingException(String var1, Throwable var2);
    }
}

