/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.parser;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.jdbc.driver.parser.Cell;
import oracle.jdbc.driver.parser.LexerToken;
import oracle.jdbc.driver.parser.Matriceable;
import oracle.jdbc.driver.parser.Matrix;
import oracle.jdbc.driver.parser.ParseNode;
import oracle.jdbc.driver.parser.Parser;
import oracle.jdbc.driver.parser.RuleTuple;
import oracle.jdbc.driver.parser.Token;
import oracle.jdbc.driver.parser.Tuple;
import oracle.jdbc.driver.parser.util.Array;
import oracle.jdbc.driver.parser.util.Service;

public abstract class Earley
extends Parser {
    public int identifier = -1;
    protected int string_literal = -1;
    protected int digits = -1;
    public boolean isCaseSensitive = false;
    protected PredictedTerminals[] terminalPredictions = null;
    public Map<Integer, long[]> predicts = null;
    public boolean skipRanges = true;
    public boolean isAsc = false;

    protected abstract void initCell00(List<LexerToken> var1, Matrix var2);

    @Override
    public void parse(List<LexerToken> src, Matriceable m) {
        Matrix matrix = (Matrix)m;
        try {
            this.initCell00(src, matrix);
            this.predict(matrix);
            while (this.scan(matrix, src)) {
                this.complete(matrix, src.size());
                this.predict(matrix);
            }
        }
        catch (Exception e) {
            for (StackTraceElement elem : e.getStackTrace()) {
                if (!elem.toString().contains("UnitTest.assertion") && !elem.toString().contains("SqlEarley.main")) continue;
                System.err.println(e.toString());
                System.err.println("matrix.lastY=" + matrix.lastY() + ", src.size()=" + src.size());
                break;
            }
        }
    }

    @Override
    public ParseNode parse(List<LexerToken> src) {
        Matrix matrix = new Matrix(this);
        this.parse(src, matrix);
        return this.forest(src, matrix);
    }

    public Earley(Set<RuleTuple> originalRules) {
        this(originalRules, false);
    }

    public Earley(Set<RuleTuple> originalRules, boolean precomputePredictions) {
        super(originalRules);
        this.initProperties();
        if (precomputePredictions) {
            this.precomputePredictions();
        }
    }

    private void initProperties() {
        this.identifier = (Integer)this.symbolIndexes.get("identifier");
        try {
            this.string_literal = (Integer)this.symbolIndexes.get("string_literal");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.digits = (Integer)this.symbolIndexes.get("digits");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void precomputePredictions() {
        int before;
        Object tmp;
        if (this.predicts == null) {
            this.predicts = new HashMap<Integer, long[]>();
        }
        HashMap<Integer, int[]> closure = new HashMap<Integer, int[]>();
        HashMap<Integer, long[]> symbolHead2rules = new HashMap<Integer, long[]>();
        for (int i = 0; i < this.rules.length; ++i) {
            tmp = (int[])closure.get(this.rules[i].head);
            long[] tmp1 = (long[])symbolHead2rules.get(this.rules[i].head);
            tmp = Array.insert((int[])tmp, this.rules[i].rhs[0]);
            tmp1 = Array.insert(tmp1, Earley.makeMatrixCellElem(i, 0, this.rules[i]));
            closure.put(this.rules[i].head, (int[])tmp);
            symbolHead2rules.put(this.rules[i].head, tmp1);
        }
        do {
            before = this.size(closure);
            tmp = closure.keySet().iterator();
            while (tmp.hasNext()) {
                int k = (Integer)tmp.next();
                int[] v = (int[])closure.get(k);
                int[] tmp2 = Array.merge(v, new int[0]);
                for (int n : v) {
                    tmp2 = Array.merge(tmp2, (int[])closure.get(n));
                }
                closure.put(k, tmp2);
            }
        } while (before != this.size(closure));
        this.terminalPredictions = new PredictedTerminals[this.allSymbols.length];
        Iterator iterator = closure.keySet().iterator();
        while (iterator.hasNext()) {
            int k = (Integer)iterator.next();
            long[] tmp3 = (long[])symbolHead2rules.get(k);
            for (int n : (int[])closure.get(k)) {
                tmp3 = Array.merge(tmp3, (long[])symbolHead2rules.get(n));
                String rhs0 = this.allSymbols[n];
                if (rhs0.charAt(0) == '\'') {
                    if (this.terminalPredictions[k] == null) {
                        this.terminalPredictions[k] = new PredictedTerminals();
                    }
                    this.terminalPredictions[k].add(n);
                    continue;
                }
                if (n != this.identifier && n != this.digits && n != this.string_literal) continue;
                if (this.terminalPredictions[k] == null) {
                    this.terminalPredictions[k] = new PredictedTerminals();
                }
                this.terminalPredictions[k].invalidate();
            }
            this.predicts.put(k, tmp3);
        }
    }

    private int size(Map<Integer, int[]> closure) {
        int ret = 0;
        for (int[] tmp : closure.values()) {
            ret += tmp.length;
        }
        return ret;
    }

    protected abstract boolean scan(Matrix var1, List<LexerToken> var2);

    protected boolean isScannedSymbol(int y, List<LexerToken> src, int pos, Tuple t, Integer suspect) {
        int symbol = t.content(pos);
        LexerToken token = src.get(y);
        if (symbol == this.digits && token.type == Token.DIGITS) {
            return true;
        }
        if (symbol == this.string_literal && token.type == Token.QUOTED_STRING) {
            return true;
        }
        return suspect != null && suspect == symbol || this.isIdentifier(y, src, symbol, suspect) && (suspect == null || this.notConfusedAsId(suspect, t.head, pos));
    }

    protected abstract boolean notConfusedAsId(int var1, int var2, int var3);

    protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
        if (symbol != this.identifier) {
            return false;
        }
        LexerToken token = src.get(y);
        return symbol == this.identifier && token.type == Token.IDENTIFIER;
    }

    protected void predict(Matrix matrix) {
        if (this.predicts == null) {
            this.predicts = new HashMap<Integer, long[]>();
            this.precomputePredictions();
        }
        int y = matrix.lastY();
        Parser.EarleyCell cell = (Parser.EarleyCell)matrix.get(y, y);
        long[] content = null;
        if (cell != null) {
            content = cell.content;
        }
        int[] symbols = new int[]{};
        Map<Integer, Cell> xRange = matrix.getXRange(y);
        Iterator<Integer> iterator = xRange.keySet().iterator();
        while (iterator.hasNext()) {
            int mid = iterator.next();
            Cell candidateRules = matrix.get(mid, y);
            for (int j = 0; j < candidateRules.size(); ++j) {
                int pos = candidateRules.getPosition(j);
                int ruleNo = candidateRules.getRule(j);
                Tuple t = this.rules[ruleNo];
                if (t.size() <= pos) continue;
                int symbol = t.content(pos);
                symbols = Array.insert(symbols, symbol);
            }
        }
        for (Object symbol : (Iterator<Integer>)symbols) {
            PredictedTerminals terminal;
            if (matrix.LAsuspect != null && (terminal = this.terminalPredictions[symbol]) != null && !terminal.matches(matrix.LAsuspect)) continue;
            content = Array.merge(content, this.predicts.get((int)symbol));
        }
        if (content == null || content.length <= 0) {
            return;
        }
        matrix.put(y, y, new Parser.EarleyCell(this, content));
    }

    protected void complete(Matrix matrix, int srcLength) {
        long completionCandidate;
        HashMap<Integer, Integer> skipIntervals = new HashMap<Integer, Integer>();
        while ((completionCandidate = matrix.dequeue()) != -1L) {
            int symbol = Service.lY(completionCandidate);
            int mid = Service.lX(completionCandidate);
            int y = matrix.lastY();
            int indexX = Array.indexOf(matrix.allXs, mid);
            if (matrix.allXs.length - 1 < indexX) {
                indexX = matrix.allXs.length - 1;
            }
            if (mid < matrix.allXs[indexX]) {
                // empty if block
            }
            for (int i = --indexX; 0 <= i; --i) {
                Integer predecessor;
                int x = matrix.allXs[i];
                int skipTo = y;
                Cell pres = matrix.get(x, mid);
                if (pres == null) continue;
                long mask = (long)symbol << 48;
                int start = Array.indexOf(pres.getContent(), mask);
                int stop = Array.indexOf(pres.getContent(), mask | 0xFFFFFFFFFFFFL) + 1;
                Parser.EarleyCell content = (Parser.EarleyCell)matrix.get(x, y);
                for (int ii = start; ii < stop && ii < pres.size(); ++ii) {
                    int symPre;
                    int dotPre = pres.getPosition(ii);
                    int rulePre = pres.getRule(ii);
                    Tuple tPre = this.rules[rulePre];
                    if (tPre.size() == dotPre || (symPre = tPre.content(dotPre)) != symbol || y < srcLength && !this.lookaheadOK(tPre, dotPre + 1, matrix)) continue;
                    if (content == null) {
                        content = new Parser.EarleyCell(this, null);
                    }
                    long promotedRule = Earley.makeMatrixCellElem(rulePre, dotPre + 1, tPre);
                    int before = content.size();
                    content.insertContent(promotedRule);
                    int after = content.size();
                    if (before < after) {
                        matrix.put(x, y, content);
                        if (this.skipRanges && tPre.rhs.length == dotPre + 1 && mid < skipTo && this.allSymbols[tPre.head].charAt(0) != '\"' && this.allSymbols[symPre].charAt(0) != '\"') {
                            skipTo = mid;
                        }
                    }
                    if (tPre.size() != dotPre + 1 || before >= after) continue;
                    matrix.enqueue(Service.lPair(x, tPre.head));
                }
                if (!this.skipRanges || x >= skipTo || skipTo >= y || (predecessor = (Integer)skipIntervals.get(x + 1)) != null && skipTo >= predecessor) continue;
                skipIntervals.put(x + 1, skipTo);
            }
        }
        Iterator iterator = skipIntervals.keySet().iterator();
        while (iterator.hasNext()) {
            int y;
            int x = (Integer)iterator.next();
            if (x >= (y = ((Integer)skipIntervals.get(x)).intValue())) continue;
            matrix.allXs = Array.delete(matrix.allXs, x, y);
        }
    }

    protected abstract boolean lookaheadOK(Tuple var1, int var2, Matrix var3);

    public void initCell(Matrix matrix, int[] heads, int pos) {
        long[] content = null;
        block0: for (int i = 0; i < this.rules.length; ++i) {
            Tuple t = this.rules[i];
            for (int h : heads) {
                if (t.head != h) continue;
                content = Array.insert(content, Earley.makeMatrixCellElem(i, 0, t));
                continue block0;
            }
        }
        matrix.put(pos, pos, new Parser.EarleyCell(this, content));
        matrix.allXs = Array.insert(matrix.allXs, pos);
    }

    @Override
    public ParseNode treeForACell(List<LexerToken> src, Matrix m, Cell cell, int x, int y) {
        int rule = -1;
        int pos = -1;
        for (int i = 0; i < cell.size(); ++i) {
            rule = cell.getRule(i);
            pos = cell.getPosition(i);
            if (this.rules[rule].rhs.length != pos) continue;
            return this.tree(src, m, x, y, rule, pos);
        }
        if (rule != -1 && pos != -1) {
            return this.tree(src, m, x, y, rule, pos);
        }
        return null;
    }

    protected ParseNode tree(List<LexerToken> src, Matrix m, int x, int y, int rule, int pos) {
        long demotedRule;
        int indexOfDemotedRule;
        long ruleAtTheIndex;
        Parser.EarleyCell pre;
        if (pos != 0 && (pre = (Parser.EarleyCell)m.get(x, y - 1)) != null && (ruleAtTheIndex = pre.content[indexOfDemotedRule = Array.indexOf(pre.content, demotedRule = Earley.makeMatrixCellElem(rule, pos - 1, this.rules[rule]))]) == demotedRule) {
            Tuple t = this.rules[rule];
            LexerToken token = src.get(y - 1);
            Integer suspect = (Integer)this.symbolIndexes.get("'" + (this.isCaseSensitive ? token.content : token.content.toUpperCase()) + "'");
            if (this.isScannedSymbol(y - 1, src, pos - 1, t, suspect)) {
                ParseNode branch = new ParseNode(y - 1, y, this.rules[rule].rhs[pos - 1], this);
                if (x + 1 == y) {
                    if (this.rules[rule].rhs.length == 1) {
                        branch.addContent(this.rules[rule].head);
                    }
                    return branch;
                }
                int head = this.rules[rule].head;
                if (pos != this.rules[rule].rhs.length) {
                    head = -1;
                }
                ParseNode ret = new ParseNode(x, y, head, head, this);
                ret.lft = this.tree(src, m, x, y - 1, rule, pos - 1);
                ret.lft.parent = ret;
                ret.rgt = branch;
                ret.rgt.parent = ret;
                return ret;
            }
        }
        if (pos != 0) {
            long demotedRule2 = Earley.makeMatrixCellElem(rule, pos - 1, this.rules[rule]);
            TreeMap cellsAtY = (TreeMap)m.getXRange(y);
            Iterator iterator = (this.isAsc ? cellsAtY.keySet() : cellsAtY.descendingKeySet()).iterator();
            while (iterator.hasNext()) {
                Cell post;
                int mid = (Integer)iterator.next();
                Parser.EarleyCell pre2 = (Parser.EarleyCell)m.get(x, mid);
                if (pre2 == null || (post = m.get(mid, y)) == null || pre2.content[Array.indexOf(pre2.content, demotedRule2)] != demotedRule2) continue;
                for (int j = 0; j <= post.size() - 1; ++j) {
                    int rJ = post.getRule(j);
                    int pJ = post.getPosition(j);
                    if (this.rules[rJ].rhs.length != pJ || this.rules[rJ].head != this.rules[rule].rhs[pos - 1]) continue;
                    if (x != mid) {
                        ParseNode ret = new ParseNode(x, y, this.rules[rule].rhs.length != pos ? -1 : this.rules[rule].head, this);
                        ret.lft = this.tree(src, m, x, mid, rule, pos - 1);
                        ret.lft.parent = ret;
                        ret.rgt = this.tree(src, m, mid, y, rJ, pJ);
                        ret.rgt.parent = ret;
                        return ret;
                    }
                    if (rJ == rule && pJ == pos) continue;
                    ParseNode ret = this.tree(src, m, mid, y, rJ, pJ);
                    if (this.rules[rule].rhs.length == pos) {
                        ret.addContent(this.rules[rule].head);
                    }
                    return ret;
                }
            }
        }
        throw new AssertionError((Object)"Unexpected case");
    }

    public class PredictedTerminals
    implements Serializable {
        private boolean isValid = true;
        int[] symbols = null;

        void add(int sym) {
            if (this.isValid) {
                this.symbols = Array.insert(this.symbols, sym);
            } else {
                this.invalidate();
            }
        }

        void invalidate() {
            this.symbols = null;
            this.isValid = false;
        }

        public boolean matches(Integer lookahead) {
            if (!this.isValid) {
                return true;
            }
            if (this.symbols == null) {
                return true;
            }
            return lookahead != null && this.symbols[Array.indexOf(this.symbols, lookahead)] == lookahead;
        }
    }
}

