/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import org.keycloak.common.util.Resteasy;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionTaskWithResult;
import org.keycloak.models.utils.KeycloakModelUtils;

public abstract class ResponseSessionTask
implements KeycloakSessionTaskWithResult<Response> {
    private final KeycloakSession originalSession;

    public ResponseSessionTask(KeycloakSession originalSession) {
        this.originalSession = originalSession;
    }

    public Response run(KeycloakSession session) {
        KeycloakSession originalContextSession = Resteasy.getContextData(KeycloakSession.class);
        try {
            KeycloakModelUtils.cloneContextRealmClientSessionToSession((KeycloakContext)this.originalSession.getContext(), (KeycloakSession)session);
            Resteasy.pushContext(KeycloakSession.class, session);
            Response response = this.runInternal(session);
            return response;
        }
        catch (WebApplicationException we) {
            Response response = we.getResponse();
            if (response.getEntity() != null) {
                Response response2 = response;
                return response2;
            }
            throw we;
        }
        finally {
            Resteasy.pushContext(KeycloakSession.class, originalContextSession);
        }
    }

    public abstract Response runInternal(KeycloakSession var1);
}

