/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.AbstractTypedPropertiesConfiguration;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.cache.IndexReaderConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStartupMode;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.cache.IndexWriterConfigurationBuilder;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.cache.IndexingConfigurationChildBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;

public class IndexingConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements IndexingConfigurationChildBuilder,
Builder<IndexingConfiguration> {
    private static final String BACKEND_PREFIX = "hibernate.search.backend.";
    private static final String DIRECTORY_PROVIDER_KEY = "hibernate.search.backend.directory.type";
    private static final String EXCLUSIVE_INDEX_USE = "hibernate.search.default.exclusive_index_use";
    private static final String INDEX_MANAGER = "hibernate.search.default.indexmanager";
    private static final String READER_STRATEGY = "hibernate.search.default.reader.strategy";
    private static final String FS_PROVIDER = "local-filesystem";
    @Deprecated
    private static final String RAM_DIRECTORY_PROVIDER = "ram";
    private static final String LOCAL_HEAP_DIRECTORY_PROVIDER = "local-heap";
    private final AttributeSet attributes;
    private final Set<Class<?>> resolvedIndexedClasses = new HashSet();
    private final IndexReaderConfigurationBuilder readerConfigurationBuilder;
    private final IndexWriterConfigurationBuilder writerConfigurationBuilder;

    IndexingConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.attributes = IndexingConfiguration.attributeDefinitionSet();
        this.readerConfigurationBuilder = new IndexReaderConfigurationBuilder(this);
        this.writerConfigurationBuilder = new IndexWriterConfigurationBuilder(this);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public IndexingConfigurationBuilder enabled(boolean enabled) {
        if (this.attributes.attribute(IndexingConfiguration.INDEX).isModified()) {
            throw Log.CONFIG.indexEnabledAndIndexModeAreExclusive();
        }
        if (!enabled) {
            this.reset();
        }
        this.attributes.attribute(IndexingConfiguration.ENABLED).set((Object)enabled);
        return this;
    }

    @Override
    public IndexReaderConfigurationBuilder reader() {
        return this.readerConfigurationBuilder;
    }

    @Override
    public IndexWriterConfigurationBuilder writer() {
        return this.writerConfigurationBuilder;
    }

    public void reset() {
        this.attributes.attribute(IndexingConfiguration.INDEX).reset();
        this.attributes.attribute(IndexingConfiguration.AUTO_CONFIG).reset();
        this.attributes.attribute(IndexingConfiguration.ENABLED).reset();
        this.attributes.attribute(IndexingConfiguration.INDEXED_ENTITIES).reset();
        this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).reset();
        this.attributes.attribute(IndexingConfiguration.KEY_TRANSFORMERS).reset();
        this.attributes.attribute(IndexingConfiguration.STORAGE).reset();
        this.attributes.attribute(IndexingConfiguration.STARTUP_MODE).reset();
        this.attributes.attribute(IndexingConfiguration.PATH).reset();
    }

    @Override
    public IndexingConfigurationBuilder enable() {
        return this.enabled(true);
    }

    @Override
    public IndexingConfigurationBuilder disable() {
        return this.enabled(false);
    }

    public boolean enabled() {
        return (Boolean)this.attributes.attribute(IndexingConfiguration.ENABLED).get();
    }

    @Override
    public IndexingConfigurationBuilder path(String path) {
        this.attributes.attribute(IndexingConfiguration.PATH).set((Object)path);
        return this;
    }

    @Override
    public IndexingConfigurationBuilder storage(IndexStorage storage) {
        this.attributes.attribute(IndexingConfiguration.STORAGE).set((Object)storage);
        return this;
    }

    @Override
    public IndexingConfigurationBuilder startupMode(IndexStartupMode startupMode) {
        this.attributes.attribute(IndexingConfiguration.STARTUP_MODE).set((Object)startupMode);
        return this;
    }

    @Override
    public IndexingConfigurationBuilder addKeyTransformer(Class<?> keyClass, Class<?> keyTransformerClass) {
        Map<Class<?>, Class<?>> keyTransformers = this.keyTransformers();
        keyTransformers.put(keyClass, keyTransformerClass);
        this.attributes.attribute(IndexingConfiguration.KEY_TRANSFORMERS).set(keyTransformers);
        return this;
    }

    private Map<Class<?>, Class<?>> keyTransformers() {
        return (Map)this.attributes.attribute(IndexingConfiguration.KEY_TRANSFORMERS).get();
    }

    @Deprecated
    public IndexingConfigurationBuilder addProperty(String key, String value) {
        return this.setProperty(key, value);
    }

    @Deprecated
    public IndexingConfigurationBuilder setProperty(String key, Object value) {
        TypedProperties properties = (TypedProperties)this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).get();
        properties.put((Object)key, value);
        this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).set((Object)properties);
        return this;
    }

    @Deprecated
    public IndexingConfigurationBuilder withProperties(Properties props) {
        this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).set((Object)TypedProperties.toTypedProperties((Map)props));
        return this;
    }

    @Deprecated
    public IndexingConfigurationBuilder index(Index index) {
        if (this.attributes.attribute(IndexingConfiguration.ENABLED).isModified()) {
            throw Log.CONFIG.indexEnabledAndIndexModeAreExclusive();
        }
        this.enabled(index != null && index != Index.NONE);
        this.attributes.attribute(IndexingConfiguration.INDEX).set((Object)index);
        return this;
    }

    @Deprecated
    public IndexingConfigurationBuilder autoConfig(boolean autoConfig) {
        if (autoConfig && !this.attributes.attribute(IndexingConfiguration.ENABLED).isModified()) {
            this.enable();
        }
        this.attributes.attribute(IndexingConfiguration.AUTO_CONFIG).set((Object)autoConfig);
        return this;
    }

    @Deprecated
    public boolean autoConfig() {
        return (Boolean)this.attributes.attribute(IndexingConfiguration.AUTO_CONFIG).get();
    }

    @Override
    public IndexingConfigurationBuilder addIndexedEntity(String indexedEntity) {
        if (indexedEntity == null || indexedEntity.length() == 0) {
            throw new CacheConfigurationException("Type name must not be null or empty");
        }
        Set<String> indexedEntitySet = this.indexedEntities();
        indexedEntitySet.add(indexedEntity);
        this.attributes.attribute(IndexingConfiguration.INDEXED_ENTITIES).set(indexedEntitySet);
        return this;
    }

    @Override
    public IndexingConfigurationBuilder addIndexedEntities(String ... indexedEntities) {
        Set<String> indexedEntitySet = this.indexedEntities();
        for (String typeName : indexedEntities) {
            if (typeName == null || typeName.length() == 0) {
                throw new CacheConfigurationException("Type name must not be null or empty");
            }
            indexedEntitySet.add(typeName);
        }
        this.attributes.attribute(IndexingConfiguration.INDEXED_ENTITIES).set(indexedEntitySet);
        return this;
    }

    @Override
    public IndexingConfigurationBuilder addIndexedEntity(Class<?> indexedEntity) {
        this.addIndexedEntity(indexedEntity.getName());
        this.resolvedIndexedClasses.add(indexedEntity);
        return this;
    }

    @Override
    public IndexingConfigurationBuilder addIndexedEntities(Class<?> ... indexedEntities) {
        this.addIndexedEntities((String[])Arrays.stream(indexedEntities).map(Class::getName).toArray(String[]::new));
        Collections.addAll(this.resolvedIndexedClasses, indexedEntities);
        return this;
    }

    private Set<String> indexedEntities() {
        return (Set)this.attributes.attribute(IndexingConfiguration.INDEXED_ENTITIES).get();
    }

    public void validate() {
        if (this.enabled()) {
            if (this.clustering().cacheMode().isInvalidation()) {
                throw Log.CONFIG.invalidConfigurationIndexingWithInvalidation();
            }
            if (this.indexedEntities().isEmpty() && !this.getBuilder().template()) {
                throw Log.CONFIG.noIndexableClassesDefined();
            }
        } else if (!this.indexedEntities().isEmpty()) {
            throw Log.CONFIG.indexableClassesDefined();
        }
        if (this.attributes.attribute(IndexingConfiguration.INDEX).get() == Index.PRIMARY_OWNER) {
            throw Log.CONFIG.indexModeNotSupported(Index.PRIMARY_OWNER.name());
        }
        this.ensureSingleIndexingConfig();
    }

    private void ensureSingleIndexingConfig() {
        TypedProperties typedProperties = (TypedProperties)this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).get();
        boolean hasMultiIndexConfig = typedProperties.keySet().stream().map(Object::toString).filter(k -> k.contains(".")).map(k -> k.substring(k.lastIndexOf(46))).anyMatch(s -> typedProperties.keySet().stream().filter(k -> k.toString().endsWith((String)s)).count() > 1L);
        if (hasMultiIndexConfig) {
            throw Log.CONFIG.foundDifferentIndexConfigPerType();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        if (this.enabled()) {
            this.applyLegacyProperties((TypedProperties)this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).get());
            try {
                String clazz = "org.infinispan.query.Search";
                Util.loadClassStrict((String)clazz, (ClassLoader)globalConfig.classLoader());
            }
            catch (ClassNotFoundException e) {
                throw Log.CONFIG.invalidConfigurationIndexingWithoutModule();
            }
            if (this.attributes.attribute(IndexingConfiguration.STORAGE).get() == IndexStorage.FILESYSTEM) {
                boolean globalStateEnabled = globalConfig.globalState().enabled();
                String path = StringPropertyReplacer.replaceProperties((String)((String)this.attributes.attribute(IndexingConfiguration.PATH).get()));
                if (!globalStateEnabled) {
                    if (path == null) {
                        Log.CONFIG.indexLocationWorkingDir();
                    } else if (!Paths.get(path, new String[0]).isAbsolute()) {
                        Log.CONFIG.indexRelativeWorkingDir(path);
                    }
                }
            }
        }
    }

    private void applyAutoConfig(TypedProperties properties) {
        properties.putIfAbsent(DIRECTORY_PROVIDER_KEY, FS_PROVIDER);
        properties.putIfAbsent(EXCLUSIVE_INDEX_USE, "true");
        properties.putIfAbsent(INDEX_MANAGER, "near-real-time");
        properties.putIfAbsent(READER_STRATEGY, "shared");
    }

    public IndexingConfiguration create() {
        TypedProperties typedProperties = (TypedProperties)this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).get();
        if (typedProperties.size() > 0) {
            Log.CONFIG.indexingPropertiesDeprecated((Properties)typedProperties);
            this.applyLegacyProperties(typedProperties);
        }
        if (this.autoConfig()) {
            this.applyAutoConfig(typedProperties);
            this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).set((Object)typedProperties);
            this.ensureSingleIndexingConfig();
        }
        return new IndexingConfiguration(this.attributes.protect(), this.resolvedIndexedClasses, this.readerConfigurationBuilder.create(), this.writerConfigurationBuilder.create());
    }

    private void applyLegacyProperties(TypedProperties properties) {
        properties.forEach((k, v) -> {
            String prop = k.toString();
            String propValue = v.toString();
            if (prop.endsWith(".directory_provider")) {
                if (LOCAL_HEAP_DIRECTORY_PROVIDER.equals(propValue)) {
                    this.storage(IndexStorage.LOCAL_HEAP);
                } else {
                    this.storage(IndexStorage.FILESYSTEM);
                }
            }
            if (prop.endsWith(".indexBase")) {
                this.path(StringPropertyReplacer.replaceProperties((String)propValue));
            }
            if (prop.endsWith(".merge_factor")) {
                this.writer().merge().factor(Integer.parseInt(propValue));
            }
            if (prop.endsWith(".merge_max_size")) {
                this.writer().merge().maxSize(Integer.parseInt(propValue));
            }
            if (prop.endsWith(".ram_buffer_size")) {
                this.writer().ramBufferSize(Integer.parseInt(propValue));
            }
            if (prop.endsWith(".index_flush_interval")) {
                this.writer().commitInterval(Integer.parseInt(propValue));
            }
            if (prop.endsWith(".reader.async_refresh_period_ms")) {
                this.reader().refreshInterval(Long.parseLong(propValue));
            }
        });
    }

    public IndexingConfigurationBuilder read(IndexingConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        Index index = (Index)((Object)this.attributes.attribute(IndexingConfiguration.INDEX).get());
        if (index != null) {
            this.enabled(index != Index.NONE);
        }
        if (this.autoConfig() && !this.attributes.attribute(IndexingConfiguration.ENABLED).isModified()) {
            this.enable();
        }
        this.resolvedIndexedClasses.clear();
        this.resolvedIndexedClasses.addAll(template.indexedEntities());
        this.readerConfigurationBuilder.read((Object)template.reader());
        this.writerConfigurationBuilder.read((Object)template.writer());
        return this;
    }

    public String toString() {
        return "IndexingConfigurationBuilder{attributes=" + String.valueOf(this.attributes) + ", readerConfigurationBuilder=" + String.valueOf(this.readerConfigurationBuilder) + ", writerConfigurationBuilder=" + String.valueOf(this.writerConfigurationBuilder) + "}";
    }
}

