/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.keycloak.client.admin.cli.util.IoUtil;
import org.keycloak.client.admin.cli.util.ReturnFields;

public class OutputUtil {
    public static ObjectMapper MAPPER = new ObjectMapper();

    public static JsonNode convertToJsonNode(Object object) throws IOException {
        if (object instanceof JsonNode) {
            return (JsonNode)object;
        }
        return MAPPER.convertValue(object, JsonNode.class);
    }

    public static void printAsCsv(Object object, ReturnFields fields, boolean unquoted) throws IOException {
        OutputUtil.printAsCsv(object, fields, unquoted, IoUtil::printOut);
    }

    public static void printAsCsv(Object object, ReturnFields fields, boolean unquoted, Consumer<String> printer) throws IOException {
        JsonNode node = OutputUtil.convertToJsonNode(object);
        if (!node.isArray()) {
            ArrayNode listNode = MAPPER.createArrayNode();
            listNode.add(node);
            node = listNode;
        }
        for (JsonNode item : node) {
            StringBuilder buffer = new StringBuilder();
            OutputUtil.printObjectAsCsv(buffer, item, fields, unquoted);
            printer.accept(buffer.length() > 0 ? buffer.substring(1) : "");
        }
    }

    static void printObjectAsCsv(StringBuilder out, JsonNode node, boolean unquoted) {
        OutputUtil.printObjectAsCsv(out, node, null, unquoted);
    }

    static void printObjectAsCsv(StringBuilder out, JsonNode node, ReturnFields fields, boolean unquoted) {
        if (node == null) {
            out.append(",");
        } else if (node.isObject()) {
            if (fields == null) {
                Iterator<Map.Entry<String, JsonNode>> it = node.fields();
                while (it.hasNext()) {
                    OutputUtil.printObjectAsCsv(out, it.next().getValue(), unquoted);
                }
            } else {
                for (String field : fields) {
                    JsonNode attr = node.get(field);
                    OutputUtil.printObjectAsCsv(out, attr, fields.child(field), unquoted);
                }
            }
        } else if (node.isArray()) {
            for (JsonNode item : node) {
                OutputUtil.printObjectAsCsv(out, item, fields, unquoted);
            }
        } else {
            out.append(",");
            if (unquoted && node instanceof TextNode) {
                out.append(node.asText());
            } else {
                out.append(node.toString());
            }
        }
    }

    static {
        MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

