/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider.mappersync;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.broker.provider.mappersync.ConfigSynchronizer;
import org.keycloak.broker.provider.mappersync.GroupConfigPropertyByPathSynchronizer;
import org.keycloak.broker.provider.mappersync.RoleConfigPropertyByClientIdSynchronizer;
import org.keycloak.broker.provider.mappersync.RoleConfigPropertyByRoleNameSynchronizer;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;

public final class ConfigSyncEventListener
implements ProviderEventListener {
    private static final Logger LOG = Logger.getLogger(ConfigSyncEventListener.class);
    private static final List<ConfigSynchronizer<? extends ProviderEvent>> SYNCHRONIZERS = Arrays.asList(GroupConfigPropertyByPathSynchronizer.INSTANCE, RoleConfigPropertyByClientIdSynchronizer.INSTANCE, RoleConfigPropertyByRoleNameSynchronizer.INSTANCE);

    public void onEvent(ProviderEvent event) {
        List<IdentityProviderMapperModel> realmMappers = null;
        for (ConfigSynchronizer<? extends ProviderEvent> s : SYNCHRONIZERS) {
            ConfigSynchronizer<? extends ProviderEvent> configSynchronizer = s;
            if (ConfigSyncEventListener.eventMatchesSynchronizer(event, configSynchronizer)) {
                LOG.debugf("Synchronizer %s matches event: %s", configSynchronizer, (Object)event);
                if (realmMappers == null) {
                    RealmModel realm = configSynchronizer.extractRealm((ProviderEvent)event);
                    realmMappers = realm.getIdentityProviderMappersStream().collect(Collectors.toList());
                }
                realmMappers.forEach(idpMapper -> {
                    LOG.debugf("Apply synchronizer %s to event %s and mapper with name %s", (Object)configSynchronizer, (Object)event, (Object)idpMapper.getName());
                    configSynchronizer.handleEvent((ProviderEvent)event, (IdentityProviderMapperModel)idpMapper);
                });
                continue;
            }
            LOG.debugf("Synchronizer %s does not match event: %s", configSynchronizer, (Object)event);
        }
    }

    private static boolean eventMatchesSynchronizer(ProviderEvent event, ConfigSynchronizer<? extends ProviderEvent> synchronizer) {
        Class<? extends ProviderEvent> handledClass = synchronizer.getEventClass();
        return handledClass.isAssignableFrom(event.getClass());
    }
}

