/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.util.Arrays;
import liquibase.Scope;
import liquibase.util.StringUtil;

public class ValueHandlerUtil {
    public static String ARGUMENT_KEY = "key";

    public static <T extends Enum<T>> T getEnum(Class<T> enumClass, Object input, String parameterName) {
        if (input == null) {
            return null;
        }
        if (input instanceof String) {
            String stringInput = (String)input;
            if (Arrays.stream((Enum[])enumClass.getEnumConstants()).noneMatch(enumValue -> enumValue.toString().equalsIgnoreCase(stringInput))) {
                throw new IllegalArgumentException(String.format("WARNING: The %s value '%s' is not valid. Valid values include: '%s'", parameterName.toLowerCase(), stringInput, StringUtil.join(enumClass.getEnumConstants(), "', '", Object::toString)));
            }
            return Enum.valueOf(enumClass, stringInput.toUpperCase());
        }
        if (enumClass.isAssignableFrom(input.getClass())) {
            return (T)((Enum)enumClass.cast(input));
        }
        return null;
    }

    public static Boolean booleanValueHandler(Object input) {
        if (input == null) {
            return true;
        }
        if (input instanceof Boolean) {
            return (Boolean)input;
        }
        String verboseString = (String)input;
        if (verboseString.equalsIgnoreCase("true") || verboseString.equalsIgnoreCase("false")) {
            return Boolean.valueOf(verboseString);
        }
        String key = (String)((Object)Scope.getCurrentScope().get(ARGUMENT_KEY, String.class));
        String messageString = key != null ? "\nWARNING:  The input for '" + key + "' is '" + verboseString + "', which is not valid.  Options: 'true' or 'false'." : "\nWARNING:  The input '" + verboseString + "' is not valid.  Options: 'true' or 'false'.";
        throw new IllegalArgumentException(messageString);
    }
}

