/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.vertx.http.runtime.security.ImmutableSubstringMap;
import io.quarkus.vertx.http.runtime.security.SubstringMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.BiConsumer;

public class ImmutablePathMatcher<T> {
    private final ImmutableSubstringMap<T> paths;
    private final Map<String, T> exactPathMatches;
    private final int[] lengths;
    private final T defaultHandler;
    private final boolean hasPathWithInnerWildcard;
    private final boolean hasExactPathMatches;

    private ImmutablePathMatcher(T defaultHandler, ImmutableSubstringMap<T> paths, Map<String, T> exactPathMatches, int[] lengths, boolean hasPathWithInnerWildcard) {
        this.defaultHandler = defaultHandler;
        this.paths = paths;
        this.lengths = Arrays.copyOf(lengths, lengths.length);
        this.hasPathWithInnerWildcard = hasPathWithInnerWildcard;
        if (exactPathMatches.isEmpty()) {
            this.exactPathMatches = null;
            this.hasExactPathMatches = false;
        } else {
            this.exactPathMatches = Map.copyOf(exactPathMatches);
            this.hasExactPathMatches = true;
        }
    }

    public PathMatch<T> match(String path) {
        T match;
        if (this.hasExactPathMatches && (match = this.exactPathMatches.get(path)) != null) {
            return new PathMatch<T>(path, "", match);
        }
        int length = path.length();
        for (int pathLength : this.lengths) {
            ImmutableSubstringMap.SubstringMatch<T> next;
            char c;
            if (pathLength == length) {
                ImmutableSubstringMap.SubstringMatch<T> next2 = this.paths.get(path, length);
                if (next2 == null) continue;
                return new PathMatch<T>(path, "", next2.getValue());
            }
            if (pathLength >= length || (c = path.charAt(pathLength)) != '/' && (!this.hasPathWithInnerWildcard || pathLength != 1) || (next = this.paths.get(path, pathLength)) == null) continue;
            return new PathMatch<T>(next.getKey(), path.substring(pathLength), next.getValue());
        }
        return new PathMatch<T>("", path, this.defaultHandler);
    }

    public static <T> ImmutablePathMatcherBuilder<T> builder() {
        return new ImmutablePathMatcherBuilder();
    }

    public static final class PathMatch<T> {
        private final String matched;
        private final String remaining;
        private final T value;

        public PathMatch(String matched, String remaining, T value) {
            this.matched = matched;
            this.remaining = remaining;
            this.value = value;
        }

        @Deprecated
        public String getRemaining() {
            return this.remaining;
        }

        public String getMatched() {
            return this.matched;
        }

        public T getValue() {
            return this.value;
        }
    }

    public static class ImmutablePathMatcherBuilder<T> {
        private static final String STRING_PATH_SEPARATOR = "/";
        private final Map<String, T> exactPathMatches = new HashMap<String, T>();
        private final Map<String, Path<T>> pathsWithWildcard = new HashMap<String, Path<T>>();
        private BiConsumer<T, T> handlerAccumulator;

        private ImmutablePathMatcherBuilder() {
        }

        public ImmutablePathMatcherBuilder<T> handlerAccumulator(BiConsumer<T, T> handlerAccumulator) {
            this.handlerAccumulator = handlerAccumulator;
            return this;
        }

        public ImmutablePathMatcher<T> build() {
            Object defaultHandler = null;
            SubstringMap paths = new SubstringMap();
            boolean hasPathWithInnerWildcard = false;
            for (final Path<T> p : this.pathsWithWildcard.values()) {
                Object handler = null;
                ImmutablePathMatcher<T> subPathMatcher = null;
                if (p.prefixPathHandler != null) {
                    handler = p.prefixPathHandler;
                    if (STRING_PATH_SEPARATOR.equals(p.path)) {
                        if (defaultHandler == null) {
                            defaultHandler = p.prefixPathHandler;
                        } else {
                            this.handlerAccumulator.accept(defaultHandler, p.prefixPathHandler);
                        }
                    }
                }
                if (p.pathsWithInnerWildcard != null) {
                    if (!hasPathWithInnerWildcard) {
                        hasPathWithInnerWildcard = true;
                    }
                    ImmutablePathMatcherBuilder builder = new ImmutablePathMatcherBuilder();
                    if (this.handlerAccumulator != null) {
                        builder.handlerAccumulator(new BiConsumer<ImmutableSubstringMap.SubstringMatch<T>, ImmutableSubstringMap.SubstringMatch<T>>(){

                            @Override
                            public void accept(ImmutableSubstringMap.SubstringMatch<T> match1, ImmutableSubstringMap.SubstringMatch<T> match2) {
                                if (match2.hasSubPathMatcher()) {
                                    throw new IllegalStateException(String.format("Failed to merge sub-matches with key '%s' for path '%s'", match1.getKey(), p.originalPath));
                                }
                                handlerAccumulator.accept(match1.getValue(), match2.getValue());
                            }
                        });
                    }
                    for (PathWithInnerWildcard p1 : p.pathsWithInnerWildcard) {
                        builder.addPath(p.originalPath, p1.remaining, new ImmutableSubstringMap.SubstringMatch(p1.remaining, p1.handler));
                    }
                    subPathMatcher = builder.build();
                }
                paths.put(p.path, handler, subPathMatcher);
            }
            int[] lengths = ImmutablePathMatcherBuilder.buildLengths(paths.keys());
            return new ImmutablePathMatcher<Object>(defaultHandler, paths.asImmutableMap(), (Map<String, Object>)this.exactPathMatches, lengths, hasPathWithInnerWildcard);
        }

        public ImmutablePathMatcherBuilder<T> addPath(String path, T handler) {
            return this.addPath(path, path, handler);
        }

        private ImmutablePathMatcherBuilder<T> addPath(String originalPath, String path, T handler) {
            if (!path.startsWith(STRING_PATH_SEPARATOR)) {
                String errMsg = "Path must always start with a path separator, but was '" + path + "'";
                if (!originalPath.equals(path)) {
                    errMsg = errMsg + " created from original path pattern '" + originalPath + "'";
                }
                throw new IllegalArgumentException(errMsg);
            }
            int wildcardIdx = path.indexOf(42);
            if (wildcardIdx == -1) {
                this.addExactPath(path, handler);
            } else {
                this.addWildcardPath(path, handler, wildcardIdx, originalPath);
            }
            return this;
        }

        private void addWildcardPath(String path, T handler, int wildcardIdx, String originalPath) {
            String stripped;
            String pathAfter1stWildcard;
            String pathWithWildcard;
            int lastIdx = path.length() - 1;
            if (lastIdx == wildcardIdx) {
                pathWithWildcard = path;
                pathAfter1stWildcard = null;
            } else {
                pathWithWildcard = path.substring(0, wildcardIdx + 1);
                pathAfter1stWildcard = path.substring(wildcardIdx + 1);
                if (!pathWithWildcard.endsWith("/*") || !pathAfter1stWildcard.startsWith(STRING_PATH_SEPARATOR)) {
                    throw new ConfigurationException("HTTP permission path '" + originalPath + "' contains inner wildcard enclosed with a path character other than a separator. The inner wildcard must represent exactly one path segment. Please see this Quarkus guide for more information: https://quarkus.io/guides/security-authorize-web-endpoints-reference");
                }
            }
            String pathWithoutWildcard = pathWithWildcard.endsWith("/*") ? ((stripped = pathWithWildcard.substring(0, pathWithWildcard.length() - 2)).isEmpty() ? STRING_PATH_SEPARATOR : stripped) : pathWithWildcard.substring(0, pathWithWildcard.length() - 1);
            Path p = this.pathsWithWildcard.computeIfAbsent(pathWithoutWildcard, Path::new);
            p.originalPath = originalPath;
            if (pathAfter1stWildcard == null) {
                p.addPrefixPath(handler, this.handlerAccumulator);
            } else {
                p.addPathWithInnerWildcard(pathAfter1stWildcard, handler);
            }
        }

        private void addExactPath(String path, T handler) {
            if (path.isEmpty()) {
                throw new IllegalArgumentException("Path not specified");
            }
            if (this.exactPathMatches.containsKey(path) && this.handlerAccumulator != null) {
                this.handlerAccumulator.accept(this.exactPathMatches.get(path), handler);
            } else {
                this.exactPathMatches.put(path, handler);
            }
        }

        private static int[] buildLengths(Iterable<String> keys) {
            TreeSet<Integer> lengths = new TreeSet<Integer>(new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return -o1.compareTo(o2);
                }
            });
            for (String p : keys) {
                lengths.add(p.length());
            }
            int[] lengthArray = new int[lengths.size()];
            int pos = 0;
            Iterator iterator = lengths.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                lengthArray[pos++] = i;
            }
            return lengthArray;
        }
    }

    private static class PathWithInnerWildcard<T> {
        private final String remaining;
        private final T handler;

        private PathWithInnerWildcard(String remaining, T handler) {
            this.remaining = remaining;
            this.handler = handler;
        }
    }

    private static class Path<T> {
        private final String path;
        private String originalPath = null;
        private T prefixPathHandler = null;
        private List<PathWithInnerWildcard<T>> pathsWithInnerWildcard = null;

        private Path(String path) {
            this.path = path;
        }

        private void addPathWithInnerWildcard(String remaining, T handler) {
            if (this.pathsWithInnerWildcard == null) {
                this.pathsWithInnerWildcard = new ArrayList<PathWithInnerWildcard<T>>();
            }
            this.pathsWithInnerWildcard.add(new PathWithInnerWildcard<T>(remaining, handler));
        }

        public void addPrefixPath(T prefixPathHandler, BiConsumer<T, T> handlerAccumulator) {
            Objects.requireNonNull(prefixPathHandler);
            if (this.prefixPathHandler != null && handlerAccumulator != null) {
                handlerAccumulator.accept(this.prefixPathHandler, prefixPathHandler);
            } else {
                this.prefixPathHandler = prefixPathHandler;
            }
        }
    }
}

